/*
 * Decompiled with CFR 0.152.
 */
package com.kihira.corruption;

import com.kihira.corruption.client.CreativeTabCorruption;
import com.kihira.corruption.client.diary.PageData;
import com.kihira.corruption.common.CommandCorruption;
import com.kihira.corruption.common.EventHandler;
import com.kihira.corruption.common.FMLEventHandler;
import com.kihira.corruption.common.GuiHandler;
import com.kihira.corruption.common.block.BlockEnderCake;
import com.kihira.corruption.common.corruption.AfraidOfTheDarkCorruption;
import com.kihira.corruption.common.corruption.BlockTeleportCorruption;
import com.kihira.corruption.common.corruption.BloodLossCorruption;
import com.kihira.corruption.common.corruption.ColourBlindCorruption;
import com.kihira.corruption.common.corruption.CorruptionRegistry;
import com.kihira.corruption.common.corruption.GluttonyCorruption;
import com.kihira.corruption.common.corruption.StoneSkinCorruption;
import com.kihira.corruption.common.corruption.WaterAllergyCorruption;
import com.kihira.corruption.common.item.ItemDiary;
import com.kihira.corruption.common.item.ItemFleshArmor;
import com.kihira.corruption.common.network.PacketEventHandler;
import com.kihira.corruption.proxy.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="Corruption", modid="corruption")
public class Corruption {
    @SidedProxy(clientSide="com.kihira.corruption.proxy.ClientProxy", serverSide="com.kihira.corruption.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Corruption instance;
    public static boolean isCorruptionActiveGlobal;
    public static boolean isEnabledBlockTeleportCorr;
    public static boolean isEnabledStoneSkinCorr;
    public static boolean isEnabledWaterAllergyCorr;
    public static boolean isEnabledColourBlindCorr;
    public static boolean isEnabledAfraidOfTheDarkCorr;
    public static boolean isEnabledBloodLossCorr;
    public static boolean isEnabledGluttonyCorr;
    public static final CreativeTabCorruption creativeTab;
    public static final BlockEnderCake blockEnderCake;
    public static final ItemDiary itemDiary;
    public static final Item itemFleshArmourHelmet;
    public static final Item itemFleshArmourChest;
    public static final Item itemFleshArmourLegs;
    public static final Item itemFleshArmourBoots;
    public static final Logger logger;
    public static final FMLEventChannel eventChannel;
    public static final String CATEGORY_CORRUPTION = "corruption";
    public static Configuration config;
    public static boolean disableCorrOnDragonDeath;
    public static boolean disableCorrOnWitherDeath;
    public static int corrRemovedOnDeath;
    public static int corrSpeed;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.loadGeneralConfig(e.getSuggestedConfigurationFile());
        this.registerCorruptionEffects();
        this.registerBlocks();
        this.registerItems();
        this.registerRecipes();
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        eventChannel.register((Object)new PacketEventHandler());
        proxy.registerRenderers();
        PageData.registerPageData();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandCorruption());
    }

    private void loadGeneralConfig(File file) {
        config = new Configuration(file);
        config.load();
        Property prop = config.get(CATEGORY_CORRUPTION, "Enable Block Teleport Corruption Effect", true);
        isEnabledBlockTeleportCorr = prop.getBoolean(true);
        prop = config.get(CATEGORY_CORRUPTION, "Enable Stone Skin Corruption Effect", true);
        isEnabledStoneSkinCorr = prop.getBoolean(true);
        prop = config.get(CATEGORY_CORRUPTION, "Enable Water Allergy Corruption Effect", true);
        isEnabledWaterAllergyCorr = prop.getBoolean(true);
        prop = config.get(CATEGORY_CORRUPTION, "Enable Colour Blind Corruption Effect", true);
        isEnabledColourBlindCorr = prop.getBoolean(true);
        prop = config.get(CATEGORY_CORRUPTION, "Enable Afraid of the Dark Corruption Effect", true);
        isEnabledAfraidOfTheDarkCorr = prop.getBoolean(true);
        prop = config.get(CATEGORY_CORRUPTION, "Enable Blood Loss Corruption Effect", true);
        isEnabledBloodLossCorr = prop.getBoolean(true);
        prop = config.get(CATEGORY_CORRUPTION, "Enable Gluttony Corruption Effect", true);
        isEnabledGluttonyCorr = prop.getBoolean(true);
        prop = config.get("general", "Disable corruption on dragon death", true);
        prop.comment = "When the dragon is killed, corruption is disabled for ALL players no matter when they play";
        disableCorrOnDragonDeath = prop.getBoolean(true);
        prop = config.get("general", "Disable corruption on wither death", false);
        prop.comment = "If a player kills a wither, corruption is disabled for THAT PLAYER ONLY";
        disableCorrOnWitherDeath = prop.getBoolean(false);
        prop = config.get("general", "Corruptioned removed on death", 0);
        prop.comment = "If a player dies, this amount of corruption will be removed (set to 0 to disable)";
        corrRemovedOnDeath = prop.getInt();
        prop = config.get("general", "Corruption Speed", 20);
        prop.comment = "How often in ticks to apply corruption. ModJam speed is 20, normal speed is 200";
        corrSpeed = prop.getInt();
        prop = config.get("general", "Disable Corruption", false);
        prop.comment = "DO NOT CHANGE THIS >=(";
        boolean bl = isCorruptionActiveGlobal = !prop.getBoolean(false);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void setDiableCorruption() {
        Property prop = config.get("general", "Disable Corruption", false);
        prop.set(true);
        config.save();
        isCorruptionActiveGlobal = false;
    }

    private void registerCorruptionEffects() {
        if (isEnabledWaterAllergyCorr) {
            new WaterAllergyCorruption();
            CorruptionRegistry.registerRandomCorruptionEffect("waterAllergy");
        }
        if (isEnabledStoneSkinCorr) {
            new StoneSkinCorruption();
            CorruptionRegistry.registerRandomCorruptionEffect("stoneSkin");
        }
        if (isEnabledColourBlindCorr) {
            new ColourBlindCorruption();
            CorruptionRegistry.registerRandomCorruptionEffect("colourBlind");
        }
        if (isEnabledGluttonyCorr) {
            new GluttonyCorruption();
            CorruptionRegistry.registerRandomCorruptionEffect("gluttony");
        }
        if (isEnabledAfraidOfTheDarkCorr) {
            new AfraidOfTheDarkCorruption();
        }
        if (isEnabledBlockTeleportCorr) {
            new BlockTeleportCorruption();
        }
        if (isEnabledBloodLossCorr) {
            new BloodLossCorruption();
        }
    }

    private void registerBlocks() {
        GameRegistry.registerBlock((Block)blockEnderCake, (String)"blockEnderCake");
    }

    private void registerItems() {
        GameRegistry.registerItem((Item)itemDiary, (String)"itemDiary");
        GameRegistry.registerItem((Item)itemFleshArmourHelmet, (String)"itemFleshArmourHelmet");
        GameRegistry.registerItem((Item)itemFleshArmourChest, (String)"itemFleshArmourChest");
        GameRegistry.registerItem((Item)itemFleshArmourLegs, (String)"itemFleshArmourLegs");
        GameRegistry.registerItem((Item)itemFleshArmourBoots, (String)"itemFleshArmourBoots");
    }

    private void registerRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockEnderCake, 1), (Object[])new Object[]{"EPE", "BEB", "CCC", Character.valueOf('A'), Items.field_151117_aB, Character.valueOf('B'), Items.field_151102_aT, Character.valueOf('C'), Items.field_151015_O, Character.valueOf('E'), Items.field_151110_aK, Character.valueOf('P'), Items.field_151079_bi});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemFleshArmourHelmet, 1), (Object[])new Object[]{"FFF", "FLF", "   ", Character.valueOf('F'), Items.field_151078_bh, Character.valueOf('L'), Items.field_151024_Q});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemFleshArmourChest, 1), (Object[])new Object[]{"FFF", "FLF", "FFF", Character.valueOf('F'), Items.field_151078_bh, Character.valueOf('L'), Items.field_151024_Q});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemFleshArmourLegs, 1), (Object[])new Object[]{"FFF", "FLF", "F F", Character.valueOf('F'), Items.field_151078_bh, Character.valueOf('L'), Items.field_151024_Q});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemFleshArmourBoots, 1), (Object[])new Object[]{"   ", "F F", "FLF", Character.valueOf('F'), Items.field_151078_bh, Character.valueOf('L'), Items.field_151024_Q});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)itemDiary, 1), (Object[])new Object[]{"BL ", "P  ", "   ", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('P'), Items.field_151121_aF});
    }

    static {
        isCorruptionActiveGlobal = true;
        creativeTab = new CreativeTabCorruption();
        blockEnderCake = new BlockEnderCake();
        itemDiary = new ItemDiary();
        itemFleshArmourHelmet = new ItemFleshArmor(0).func_77655_b("fleshHelmet").func_111206_d("corruption:flesh_helmet");
        itemFleshArmourChest = new ItemFleshArmor(1).func_77655_b("fleshChest").func_111206_d("corruption:flesh_chestplate");
        itemFleshArmourLegs = new ItemFleshArmor(2).func_77655_b("fleshLegs").func_111206_d("corruption:flesh_leggings");
        itemFleshArmourBoots = new ItemFleshArmor(3).func_77655_b("fleshBoots").func_111206_d("corruption:flesh_boots");
        logger = LogManager.getLogger((String)"Corruption");
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CATEGORY_CORRUPTION);
    }
}

