/*
 * Decompiled with CFR 0.152.
 */
package com.kihira.corruption.proxy;

import com.kihira.corruption.Corruption;
import com.kihira.corruption.client.EntityFootstep;
import com.kihira.corruption.client.particle.EntityFXBlood;
import com.kihira.corruption.client.render.EntityFootstepRenderer;
import com.kihira.corruption.common.CorruptionDataHelper;
import com.kihira.corruption.proxy.CommonProxy;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private final ResourceLocation stoneSkinTexture = new ResourceLocation("corruption", "stoneskin.png");
    private final ResourceLocation shader = new ResourceLocation("corruption", "grayscale.json");
    private final HashMap<EntityPlayer, EntityFootstep> footsteps = new HashMap();

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFootstep.class, (Render)new EntityFootstepRenderer());
    }

    @Override
    public void corruptPlayerSkin(AbstractClientPlayer entityPlayer, int oldCorr, int newCorr) {
        ThreadDownloadImageData imageData = entityPlayer.func_110309_l();
        BufferedImage bufferedImage = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imageData, (String[])new String[]{"bufferedImage", "field_110560_d", "bpj.g"});
        if (oldCorr == 0) {
            this.backupPlayerSkin(entityPlayer);
        }
        if (bufferedImage != null) {
            for (int i = oldCorr; i <= newCorr; ++i) {
                Random rand = new Random(entityPlayer.func_70005_c_().hashCode() * i);
                int x = rand.nextInt(bufferedImage.getWidth());
                int y = rand.nextInt(bufferedImage.getHeight());
                Color color = y == 12 && (x == 9 || x == 10 || x == 13 || x == 14 || x == 41 || x == 42 || x == 45 || x == 46) ? new Color(204, 0, 250) : new Color(bufferedImage.getRGB(x, y)).darker();
                bufferedImage.setRGB(x, y, color.getRGB());
            }
            TextureUtil.func_110987_a((int)imageData.func_110552_b(), (BufferedImage)bufferedImage);
        }
    }

    @Override
    public void uncorruptPlayerSkinPartially(AbstractClientPlayer entityPlayer, int oldCorr, int newCorr) {
        oldCorr /= 30;
        newCorr /= 30;
        ThreadDownloadImageData imageData = entityPlayer.func_110309_l();
        BufferedImage bufferedImage = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imageData, (String[])new String[]{"bufferedImage", "field_110560_d", "bpj.g"});
        BufferedImage oldSkin = this.getOriginalPlayerSkin(entityPlayer);
        if (bufferedImage != null && oldSkin != null) {
            for (int i = newCorr; i <= oldCorr; ++i) {
                Random rand = new Random(entityPlayer.func_70005_c_().hashCode() * i);
                int x = rand.nextInt(bufferedImage.getWidth());
                int y = rand.nextInt(bufferedImage.getHeight());
                bufferedImage.setRGB(x, y, oldSkin.getRGB(x, y));
            }
        }
        TextureUtil.func_110987_a((int)imageData.func_110552_b(), (BufferedImage)bufferedImage);
    }

    @Override
    public void uncorruptPlayerSkin(String playerName) {
        AbstractClientPlayer player = (AbstractClientPlayer)Minecraft.func_71410_x().field_71441_e.func_72924_a(playerName);
        if (player == null) {
            player = new EntityOtherPlayerMP((World)Minecraft.func_71410_x().field_71441_e, new GameProfile(playerName, playerName));
        }
        ThreadDownloadImageData imageData = player.func_110309_l();
        BufferedImage bufferedImage = this.getOriginalPlayerSkin(player);
        if (bufferedImage != null) {
            imageData.func_147641_a(bufferedImage);
            TextureUtil.func_110987_a((int)imageData.func_110552_b(), (BufferedImage)bufferedImage);
            System.out.println("Restored " + playerName + " skin");
        }
    }

    @Override
    public void unstonifyPlayerSkin(String playerName) {
        this.uncorruptPlayerSkin(playerName);
        AbstractClientPlayer player = (AbstractClientPlayer)Minecraft.func_71410_x().field_71441_e.func_72924_a(playerName);
        if (player == null) {
            player = new EntityOtherPlayerMP((World)Minecraft.func_71410_x().field_71441_e, new GameProfile(playerName, playerName));
        }
        this.corruptPlayerSkin(player, 0, CorruptionDataHelper.getCorruptionForPlayer((EntityPlayer)player));
    }

    @Override
    public void stonifyPlayerSkin(AbstractClientPlayer entityPlayer, int amount) {
        ThreadDownloadImageData imageData = entityPlayer.func_110309_l();
        BufferedImage bufferedImage = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imageData, (String[])new String[]{"bufferedImage", "field_110560_d", "bpj.g"});
        Random rand = new Random();
        if (bufferedImage != null) {
            try {
                BufferedImage stoneSkin = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(this.stoneSkinTexture).func_110527_b());
                for (int i = 0; i < amount; ++i) {
                    int x = rand.nextInt(bufferedImage.getWidth());
                    int y = rand.nextInt(bufferedImage.getHeight());
                    bufferedImage.setRGB(x, y, stoneSkin.getRGB(x, y));
                }
                TextureUtil.func_110987_a((int)imageData.func_110552_b(), (BufferedImage)bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void spawnFootprint(EntityPlayer player) {
        if (player.field_70143_R == 0.0f && !player.func_70090_H() && !player.field_70170_p.func_147437_c((int)player.field_70165_t, (int)player.field_70121_D.field_72338_b - 1, (int)player.field_70161_v) && (this.footsteps.containsKey(player) && (double)this.footsteps.get(player).func_70032_d((Entity)player) > 1.4 || !this.footsteps.containsKey(player))) {
            EntityFootstep footstep = new EntityFootstep(player);
            player.field_70170_p.func_72838_d((Entity)footstep);
            this.footsteps.put(player, footstep);
        }
    }

    @Override
    public void enableGrayscaleShader() {
        if (OpenGlHelper.field_148824_g) {
            EntityRenderer entityRenderer = Minecraft.func_71410_x().field_71460_t;
            if (entityRenderer.field_147707_d != null) {
                entityRenderer.field_147707_d.func_148021_a();
            }
            try {
                entityRenderer.field_147707_d = new ShaderGroup(Minecraft.func_71410_x().func_110442_L(), Minecraft.func_71410_x().func_147110_a(), this.shader);
                entityRenderer.field_147707_d.func_148026_a(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            }
            catch (IOException ioexception) {
                Corruption.logger.warn("Failed to load shader: ", (Throwable)ioexception);
            }
        }
    }

    @Override
    public void disableGrayscaleShader() {
        if (OpenGlHelper.field_148824_g) {
            EntityRenderer entityRenderer = Minecraft.func_71410_x().field_71460_t;
            if (entityRenderer.func_147706_e() != null) {
                entityRenderer.func_147706_e().func_148021_a();
            }
            entityRenderer.field_147707_d = null;
        }
    }

    @Override
    public void spawnBloodParticle(EntityPlayer player) {
        for (float i = player.func_110143_aJ(); i >= 0.0f; i -= 1.0f) {
            EntityFXBlood blood = new EntityFXBlood(player);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)blood);
        }
    }

    private void backupPlayerSkin(AbstractClientPlayer entityPlayer) {
        ThreadDownloadImageData imageData = entityPlayer.func_110309_l();
        BufferedImage bufferedImage = (BufferedImage)ObfuscationReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)imageData, (String[])new String[]{"bufferedImage", "field_110560_d", "bpj.g"});
        File file = new File("skinbackup");
        file.mkdir();
        File skinFile = new File(file, entityPlayer.func_70005_c_() + ".png");
        try {
            skinFile.createNewFile();
            if (bufferedImage != null) {
                ImageIO.write((RenderedImage)bufferedImage, "PNG", skinFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BufferedImage getOriginalPlayerSkin(AbstractClientPlayer entityPlayer) {
        File file = new File("skinbackup" + File.separator + entityPlayer.func_70005_c_() + ".png");
        BufferedImage bufferedImage = null;
        ThreadDownloadImageData imageData = entityPlayer.func_110309_l();
        try {
            if (file.exists()) {
                bufferedImage = ImageIO.read(file);
            } else {
                ObfuscationReflectionHelper.setPrivateValue(ThreadDownloadImageData.class, (Object)imageData, null, (String[])new String[]{"imageThread", "field_110561_e", "bpj.h"});
                imageData.func_147641_a(null);
                imageData.func_110551_a(Minecraft.func_71410_x().func_110442_L());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bufferedImage;
    }
}

