/*
 * Decompiled with CFR 0.152.
 */
package com.kihira.corruption.common;

import com.kihira.corruption.Corruption;
import com.kihira.corruption.common.CorruptionDataHelper;
import com.kihira.corruption.common.corruption.CorruptionRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class EventHandler {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        if (!e.entityLiving.field_70170_p.field_72995_K) {
            if (Corruption.disableCorrOnDragonDeath && (e.entity instanceof EntityDragon || e.entity instanceof EntityDragonPart)) {
                Corruption.setDiableCorruption();
                for (Object obj : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
                    EntityPlayer player = (EntityPlayer)obj;
                    CorruptionDataHelper.removeAllCorruptionEffectsForPlayer(player);
                }
                FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("The great dragon has been defeated, lifting the evil corruption from the world"));
            } else if (Corruption.disableCorrOnWitherDeath && e.entityLiving instanceof EntityWither && e.source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e.source.func_76346_g();
                if (CorruptionDataHelper.canBeCorrupted(player)) {
                    CorruptionDataHelper.removeAllCorruptionEffectsForPlayer(player);
                    CorruptionDataHelper.setCanBeCorrupted(player, false);
                    CorruptionDataHelper.setCorruptionForPlayer(player, 0);
                    player.func_146105_b((IChatComponent)new ChatComponentText("As the wither screams out its last breath, you feel a weight lifted from your entire body and soul"));
                }
            } else if (e.entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)e.entityLiving;
                CorruptionDataHelper.decreaseCorruptionForPlayer(player, Corruption.corrRemovedOnDeath);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        if (CorruptionDataHelper.hasCorruptionEffectsForPlayer(e.getPlayer(), "blockTeleport") && !e.block.hasTileEntity(e.blockMetadata)) {
            for (int i = 0; i < 5; ++i) {
                int z;
                int y;
                int x = e.world.field_73012_v.nextInt(16) - 8;
                if (!e.world.func_147437_c(x, y = e.world.field_73012_v.nextInt(6) - 3, z = e.world.field_73012_v.nextInt(16) - 8)) continue;
                e.world.func_147465_d(x, y, z, e.block, e.blockMetadata, 2);
                e.setCanceled(true);
                e.world.func_147468_f(e.x, e.y, e.z);
                break;
            }
        } else if (CorruptionDataHelper.getCorruptionForPlayer(e.getPlayer()) > 6000 && e.getPlayer().field_70170_p.field_73012_v.nextInt(23280) < CorruptionDataHelper.getCorruptionForPlayer(e.getPlayer())) {
            CorruptionDataHelper.addCorruptionEffectForPlayer(e.getPlayer(), "blockTeleport");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamage(LivingHurtEvent e) {
        EntityPlayer player;
        if (e.entityLiving instanceof EntityPlayer && e.entityLiving.func_110143_aJ() - e.ammount <= 6.0f && CorruptionDataHelper.canBeCorrupted(player = (EntityPlayer)e.entityLiving) && CorruptionDataHelper.getCorruptionForPlayer(player) > 2000 && !CorruptionDataHelper.hasCorruptionEffectsForPlayer(player, "bloodLoss")) {
            CorruptionDataHelper.addCorruptionEffectForPlayer(player, "bloodLoss");
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            File[] skinFiles;
            File skinBackupFolder = new File("skinbackup");
            if (skinBackupFolder.exists() && (skinFiles = skinBackupFolder.listFiles()) != null) {
                for (File skinFile : skinFiles) {
                    String playerName = skinFile.getName().substring(0, skinFile.getName().length() - 4);
                    Corruption.proxy.uncorruptPlayerSkin(playerName);
                }
            }
            Corruption.proxy.disableGrayscaleShader();
            CorruptionRegistry.currentCorruptionClient.clear();
        }
    }
}

