/*
 * Decompiled with CFR 0.152.
 */
package com.kihira.corruption.common;

import com.kihira.corruption.Corruption;
import com.kihira.corruption.common.corruption.CorruptionRegistry;
import com.kihira.corruption.common.network.PacketEventHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class CorruptionDataHelper {
    public static List<String> getCorruptionEffectsForPlayer(EntityPlayer entityPlayer) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        NBTTagList corrEffects = corruptionData.func_150295_c("CorruptionEffects", 8);
        ArrayList<String> effects = new ArrayList<String>();
        if (corrEffects != null && corrEffects.func_74745_c() > 0) {
            for (int i = 0; i < corrEffects.func_74745_c(); ++i) {
                effects.add(corrEffects.func_150307_f(i));
            }
        }
        return effects;
    }

    public static boolean hasCorruptionEffectsForPlayer(EntityPlayer entityPlayer, String name) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        NBTTagList corrEffects = corruptionData.func_150295_c("CorruptionEffects", 8);
        if (corrEffects != null && corrEffects.func_74745_c() > 0) {
            for (int i = 0; i < corrEffects.func_74745_c(); ++i) {
                if (!name.equals(corrEffects.func_150307_f(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void addCorruptionEffectForPlayer(EntityPlayer entityPlayer, String name) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        NBTTagList corrEffects = corruptionData.func_150295_c("CorruptionEffects", 8);
        corrEffects.func_74742_a((NBTBase)new NBTTagString(name));
        corruptionData.func_74782_a("CorruptionEffects", (NBTBase)corrEffects);
        if (!CorruptionDataHelper.hasPageDataUnlocked(CorruptionRegistry.corruptionHashMap.get(name).getPageDataName(), entityPlayer)) {
            CorruptionDataHelper.unlockPageData(CorruptionRegistry.corruptionHashMap.get(name).getPageDataName(), entityPlayer);
        }
        FMLProxyPacket packet = PacketEventHandler.getCorruptionEffectPacket(entityPlayer.func_70005_c_(), name, true, false);
        Corruption.eventChannel.sendToAll(packet);
    }

    public static void removeCorruptionEffectForPlayer(EntityPlayer entityPlayer, String name) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        NBTTagList corrEffects = corruptionData.func_150295_c("CorruptionEffects", 8);
        if (corrEffects != null && corrEffects.func_74745_c() > 0) {
            NBTTagList copy = (NBTTagList)corrEffects.func_74737_b();
            for (int i = 0; i < copy.func_74745_c(); ++i) {
                if (!name.equals(copy.func_150307_f(i))) continue;
                corrEffects.func_74744_a(i);
                break;
            }
        }
        corruptionData.func_74782_a("CorruptionEffects", (NBTBase)corrEffects);
        FMLProxyPacket packet = PacketEventHandler.getCorruptionEffectPacket(entityPlayer.func_70005_c_(), name, false, false);
        Corruption.eventChannel.sendToAll(packet);
    }

    public static void removeAllCorruptionEffectsForPlayer(EntityPlayer entityPlayer) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        corruptionData.func_74782_a("CorruptionEffects", (NBTBase)new NBTTagList());
        FMLProxyPacket packet = PacketEventHandler.getCorruptionEffectPacket(entityPlayer.func_70005_c_(), "", false, true);
        Corruption.eventChannel.sendToAll(packet);
    }

    public static NBTTagCompound getDiaryDataForPlayer(EntityPlayer entityPlayer) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        NBTTagCompound diaryData = corruptionData.func_74775_l("Diary");
        if (!corruptionData.func_74764_b("Diary")) {
            NBTTagList pageData = new NBTTagList();
            pageData.func_74742_a((NBTBase)new NBTTagString("contents"));
            pageData.func_74742_a((NBTBase)new NBTTagString("enderCake"));
            pageData.func_74742_a((NBTBase)new NBTTagString("fleshArmor"));
            diaryData.func_74782_a("PageData", (NBTBase)pageData);
            corruptionData.func_74782_a("Diary", (NBTBase)diaryData);
        }
        return diaryData;
    }

    public static boolean hasPageDataUnlocked(String pageDataName, EntityPlayer entityPlayer) {
        NBTTagCompound diaryData = CorruptionDataHelper.getDiaryDataForPlayer(entityPlayer);
        NBTTagList pageData = diaryData.func_150295_c("PageData", 8);
        if (pageData != null && pageData.func_74745_c() > 0) {
            for (int i = 0; i < pageData.func_74745_c(); ++i) {
                String pageName = pageData.func_150307_f(i);
                if (!pageName.equals(pageDataName)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setPageData(NBTTagList pageData, EntityPlayer entityPlayer) {
        NBTTagCompound diaryData = CorruptionDataHelper.getDiaryDataForPlayer(entityPlayer);
        if (pageData != null) {
            diaryData.func_74782_a("PageData", (NBTBase)pageData);
            if (Side.SERVER == FMLCommonHandler.instance().getEffectiveSide()) {
                Corruption.eventChannel.sendTo(PacketEventHandler.getDiaryDataPacket(entityPlayer), (EntityPlayerMP)entityPlayer);
            }
        }
    }

    public static void unlockPageData(String pageDataName, EntityPlayer entityPlayer) {
        NBTTagCompound diaryData = CorruptionDataHelper.getDiaryDataForPlayer(entityPlayer);
        if (diaryData.func_74764_b("PageData")) {
            NBTTagList pageData = diaryData.func_150295_c("PageData", 8);
            pageData.func_74742_a((NBTBase)new NBTTagString(pageDataName));
            diaryData.func_74782_a("PageData", (NBTBase)pageData);
            if (Side.SERVER == FMLCommonHandler.instance().getEffectiveSide()) {
                Corruption.eventChannel.sendTo(PacketEventHandler.getDiaryDataPacket(entityPlayer), (EntityPlayerMP)entityPlayer);
            }
        }
    }

    private static NBTTagCompound getCorruptionDataForPlayer(EntityPlayer entityPlayer) {
        NBTTagCompound persistedTag = entityPlayer.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound corruptionData = persistedTag.func_74775_l("Corruption");
        if (!persistedTag.func_74764_b("Corruption")) {
            persistedTag.func_74782_a("Corruption", (NBTBase)corruptionData);
        }
        entityPlayer.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistedTag);
        return corruptionData;
    }

    public static void increaseCorruptionForPlayer(EntityPlayer entityPlayer, int corruptionIncrease) {
        CorruptionDataHelper.setCorruptionForPlayer(entityPlayer, CorruptionDataHelper.getCorruptionForPlayer(entityPlayer) + corruptionIncrease);
    }

    public static void decreaseCorruptionForPlayer(EntityPlayer entityPlayer, int corruptionDecrease) {
        CorruptionDataHelper.setCorruptionForPlayer(entityPlayer, Math.max(0, CorruptionDataHelper.getCorruptionForPlayer(entityPlayer) - corruptionDecrease));
    }

    public static void setCorruptionForPlayer(EntityPlayer entityPlayer, int newCorruption) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        corruptionData.func_74768_a("corruptionLevel", newCorruption);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            FMLProxyPacket packet = PacketEventHandler.getCorruptionUpdatePacket(entityPlayer.func_70005_c_(), newCorruption);
            Corruption.eventChannel.sendToDimension(packet, entityPlayer.field_70170_p.field_73011_w.field_76574_g);
        }
    }

    public static int getCorruptionForPlayer(EntityPlayer entityPlayer) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        return corruptionData.func_74762_e("corruptionLevel");
    }

    public static void setCanBeCorrupted(EntityPlayer entityPlayer, boolean canBeCorrupted) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        corruptionData.func_74757_a("canBeCorrupted", canBeCorrupted);
    }

    public static boolean canBeCorrupted(EntityPlayer entityPlayer) {
        NBTTagCompound corruptionData = CorruptionDataHelper.getCorruptionDataForPlayer(entityPlayer);
        if (!corruptionData.func_74764_b("canBeCorrupted") && Corruption.isCorruptionActiveGlobal) {
            CorruptionDataHelper.setCanBeCorrupted(entityPlayer, true);
        }
        return corruptionData.func_74767_n("canBeCorrupted");
    }
}

