/*
 * Decompiled with CFR 0.152.
 */
package maxpowa.ayriahud.handlers;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import maxpowa.ayriahud.AyriaHUD;
import maxpowa.ayriahud.gui.GuiUtils;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class RenderHandler
extends GuiUtils {
    Minecraft field_73839_d;

    public RenderHandler(Minecraft par1Minecraft) {
        super(par1Minecraft);
        System.out.println("Render handler initialized!");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderGameOverlayEventHandler(RenderGameOverlayEvent event) {
        if (AyriaHUD.isDisabled) {
            return;
        }
        this.field_73839_d = Minecraft.func_71410_x();
        this.field_73839_d.field_71474_y.field_92117_D = false;
        this.field_73735_i = 0.0f;
        if (event.isCancelable() && (event.type == RenderGameOverlayEvent.ElementType.ARMOR || event.type == RenderGameOverlayEvent.ElementType.AIR || event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.type == RenderGameOverlayEvent.ElementType.FOOD || event.type == RenderGameOverlayEvent.ElementType.HEALTH || event.type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT || event.type == RenderGameOverlayEvent.ElementType.HOTBAR || event.type == RenderGameOverlayEvent.ElementType.JUMPBAR || event.type == RenderGameOverlayEvent.ElementType.CHAT)) {
            event.setCanceled(true);
        }
        switch (event.type) {
            case ALL: {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.renderArmor(event);
                this.renderHealth(event);
                this.renderHotbar(event);
                this.renderExperience(event);
                this.renderFood(event);
                this.renderAir(event);
                if (this.field_73839_d.field_71439_g.func_110317_t()) {
                    this.renderHealthMountAndJumpBar(event);
                }
                this.renderToolHighlight(event);
                GL11.glPopMatrix();
                break;
            }
            case CHAT: {
                GL11.glPushMatrix();
                ScaledResolution sr = new ScaledResolution(this.field_73839_d.field_71474_y, this.field_73839_d.field_71443_c, this.field_73839_d.field_71440_d);
                GL11.glTranslatef((float)0.0f, (float)((float)sr.func_78328_b() - 60.0f), (float)0.0f);
                this.field_73839_d.field_71456_v.func_146158_b().func_146230_a(this.field_73839_d.field_71456_v.func_73834_c());
                GL11.glPopMatrix();
            }
        }
    }

    private void renderToolHighlight(RenderGameOverlayEvent event) {
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        this.field_73839_d.field_71424_I.func_76320_a("toolHighlight");
        if (this.field_92017_k > 0 && this.field_92016_l != null) {
            String name = this.field_92016_l.func_82833_r();
            int opacity = (int)((float)this.field_92017_k * 256.0f / 10.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 0) {
                int y = height - 59;
                if (!this.field_73839_d.field_71442_b.func_78755_b()) {
                    y += 14;
                }
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                FontRenderer font = this.field_92016_l.func_77973_b().getFontRenderer(this.field_92016_l);
                if (font != null) {
                    int x = (width - font.func_78256_a(name)) / 2;
                    font.func_78261_a(name, x, y, 0xFFFFFF | opacity << 24);
                } else {
                    int x = (width - this.field_73839_d.field_71466_p.func_78256_a(name)) / 2;
                    this.field_73839_d.field_71466_p.func_78261_a(name, x, y, 0xFFFFFF | opacity << 24);
                }
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
    }

    private void renderHealthMountAndJumpBar(RenderGameOverlayEvent event) {
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        this.drawDoubleOutlinedBox(width / 2 - 60, height - 32, 90, 5, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        EntityHorse horse = null;
        if (this.field_73839_d.field_71439_g.func_110317_t()) {
            horse = (EntityHorse)this.field_73839_d.field_71439_g.field_70154_o;
        }
        double horseHealthRatio = (double)horse.func_110143_aJ() / horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        long boxes = Math.round(20.0 * horseHealthRatio);
        int i = 0;
        while ((long)i < boxes) {
            this.drawSolidRect(width - 120 + i * 9, (height - 32) * 2 + 1, width - 120 + i * 9 + 8, (height - 32) * 2 + 9, 10289407);
            ++i;
        }
        GL11.glPopMatrix();
        this.drawDoubleOutlinedBox(width / 2 - 60, height - 5, 120, 4, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        this.drawDoubleOutlinedBox(width / 2 + 62, height - 5, 40, 4, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        double horseJumpRatio = this.field_73839_d.field_71439_g.func_110319_bJ();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        int i2 = 0;
        while ((double)i2 < horseJumpRatio * 120.0) {
            this.drawSolidRect(width - 120 + i2 * 2, (height - 6) * 2 + 3, width - 120 + i2 * 2 + 1, (height - 6) * 2 + 9, 10289407);
            ++i2;
        }
        String healthString = horse.func_110143_aJ() + "/" + horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() + " HP";
        int healthStringLength = this.field_73839_d.field_71466_p.func_78256_a(healthString);
        this.field_73839_d.field_71466_p.func_78276_b(healthString, (width / 2 + 73) * 2 - 1 - healthStringLength / 8, (height - 6) * 2 + 2, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void renderHotbar(RenderGameOverlayEvent event) {
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        this.drawDoubleOutlinedBox(width / 2 - 60, height - 25, 162, 18, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        InventoryPlayer inv = this.field_73839_d.field_71439_g.field_71071_by;
        for (int i = 0; i < 9; ++i) {
            boolean isHighlight;
            int i1 = width / 2 - 59 + i * 18;
            int i2 = height - 24;
            boolean bl = isHighlight = inv.field_70461_c == i;
            if (!isHighlight) continue;
            this.drawDoubleOutlinedBox(i1 + 1, i2 + 1, 14, 14, BOX_HIGHLIGHT_COLOR, BOX_HIGHLIGHT_COLOR);
        }
        this.drawDoubleOutlinedBox(width / 2 + 32, height - 39, 12, 12, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        this.drawDoubleOutlinedBox(width / 2 + 46, height - 39, 12, 12, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        this.drawDoubleOutlinedBox(width / 2 + 60, height - 39, 12, 12, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        this.drawDoubleOutlinedBox(width / 2 + 74, height - 39, 28, 12, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        SimpleDateFormat sdfDate = new SimpleDateFormat("h:mm a");
        Date now = new Date();
        String strDate = sdfDate.format(now);
        int strDateLength = this.field_73839_d.field_71466_p.func_78256_a(strDate);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        this.field_73839_d.field_71466_p.func_78276_b(strDate, Math.round((float)(width / 2 + 98 - strDateLength / 2) * 2.0f), Math.round((float)(height - 35) * 2.0f), 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        GL11.glDisable((int)3042);
        for (int i = 0; i < 9; ++i) {
            int i1 = width / 2 - 59 + i * 18;
            int i2 = height - 24;
            this.renderSlot(i, i1, i2, width, this.field_73839_d.field_71466_p, this.field_73839_d);
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.8f, (float)0.75f, (float)1.0f);
        RenderItem ir = new RenderItem();
        ir.func_77015_a(this.field_73839_d.field_71466_p, this.field_73839_d.field_71446_o, new ItemStack(Items.field_151111_aL), Math.round(Math.round((double)(width / 2 + 32) * 1.25)), Math.round(Math.round((double)(height - 39) * 1.3333333333333333)));
        ir.func_77015_a(this.field_73839_d.field_71466_p, this.field_73839_d.field_71446_o, new ItemStack(Items.field_151113_aN), Math.round(Math.round((double)(width / 2 + 45) * 1.25)), Math.round(Math.round((double)(height - 39) * 1.3333333333333333)));
        ir.func_77015_a(this.field_73839_d.field_71466_p, this.field_73839_d.field_71446_o, new ItemStack(Items.field_151032_g), Math.round(Math.round((double)(width / 2 + 59) * 1.25)), Math.round(Math.round((double)(height - 39) * 1.3333333333333333)));
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        int allArrows = 0;
        for (ItemStack stack : this.field_73839_d.field_71439_g.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77977_a() != Items.field_151032_g.func_77658_a()) continue;
            allArrows += stack.field_77994_a;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        this.field_73839_d.field_71466_p.func_78276_b(allArrows + "", (width / 2 + 69) * 2 - this.field_73839_d.field_71466_p.func_78256_a(allArrows + "") + 6, (height - 31) * 2, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void renderExperience(RenderGameOverlayEvent event) {
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        this.drawDoubleOutlinedBox(width / 2 - 60, height - 5, 120, 4, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        int xpBoxWidth = 95;
        int xpLevelBoxWidth = this.field_73839_d.field_71466_p.func_78256_a(this.field_73839_d.field_71439_g.field_71068_ca + "");
        this.drawDoubleOutlinedBox(width / 2 + 62, height - 5, xpBoxWidth / 4 + 4, 4, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        this.drawDoubleOutlinedBox(width / 2 + 62 + xpBoxWidth / 4 + 6, height - 5, 34 - xpBoxWidth / 4, 4, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        int i = 0;
        while ((float)i < this.field_73839_d.field_71439_g.field_71106_cc * 120.0f) {
            this.drawSolidRect(width - 120 + i * 2, (height - 6) * 2 + 3, width - 120 + i * 2 + 1, (height - 6) * 2 + 9, 65280);
            ++i;
        }
        this.field_73839_d.field_71466_p.func_78276_b(Math.round(this.field_73839_d.field_71439_g.field_71106_cc * (float)this.field_73839_d.field_71439_g.func_71050_bK()) + "/" + this.field_73839_d.field_71439_g.func_71050_bK(), (width / 2 + 63) * 2 - 1, (height - 6) * 2 + 2, 0xFFFFFF);
        this.field_73839_d.field_71466_p.func_78276_b(this.field_73839_d.field_71439_g.field_71068_ca + "", (width / 2 + 101 - xpLevelBoxWidth / 2) * 2 + 1, (height - 6) * 2 + 2, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void renderFood(RenderGameOverlayEvent event) {
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        this.drawDoubleOutlinedBox(width / 2 - 60, height - 32, 90, 5, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        int color = 6372379;
        if (this.field_73839_d.field_71439_g.func_70644_a(Potion.field_76438_s)) {
            color = 1653267;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < this.field_73839_d.field_71439_g.func_71024_bL().func_75116_a(); ++i) {
            this.drawSolidRect(width - 120 + i * 9, (height - 32) * 2 + 1, width - 120 + i * 9 + 8, (height - 32) * 2 + 9, color);
        }
        GL11.glPopMatrix();
    }

    private void renderHealth(RenderGameOverlayEvent event) {
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        this.drawDoubleOutlinedBox(width / 2 - 60, height - 39, 90, 5, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        double playerHealthRatio = (double)this.field_73839_d.field_71439_g.func_110143_aJ() / this.field_73839_d.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        long boxes = Math.round(20.0 * playerHealthRatio);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        int i = 0;
        while ((long)i < boxes) {
            this.drawSolidRect(width - 120 + i * 9, (height - 39) * 2 + 1, width - 120 + i * 9 + 8, (height - 39) * 2 + 9, 7277323);
            ++i;
        }
        this.field_73839_d.field_71466_p.func_78276_b(this.field_73839_d.field_71439_g.func_110143_aJ() + "", width + 60 - this.field_73839_d.field_71466_p.func_78256_a(this.field_73839_d.field_71439_g.func_110143_aJ() + ""), (height - 39) * 2 + 1, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void renderAir(RenderGameOverlayEvent event) {
        if (!this.field_73839_d.field_71439_g.func_70055_a(Material.field_151586_h)) {
            return;
        }
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        this.drawDoubleOutlinedBox(width / 2 - 60, height - 32, 90, 5, BOX_INNER_COLOR, BOX_OUTLINE_COLOR, true);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < this.field_73839_d.field_71439_g.func_70086_ai() / 15; ++i) {
            this.drawSolidRect(width - 120 + i * 9, (height - 32) * 2 + 1, width - 120 + i * 9 + 8, (height - 32) * 2 + 9, 1527892);
        }
        GL11.glPopMatrix();
    }

    private void renderArmor(RenderGameOverlayEvent event) {
        int shiftedColor;
        int color;
        int dmg;
        FontRenderer fr = this.field_73839_d.field_71466_p;
        RenderItem ir = new RenderItem();
        int width = event.resolution.func_78326_a();
        int height = event.resolution.func_78328_b();
        ItemStack boots = this.field_73839_d.field_71439_g.field_71071_by.field_70460_b[0];
        ItemStack pants = this.field_73839_d.field_71439_g.field_71071_by.field_70460_b[1];
        ItemStack chest = this.field_73839_d.field_71439_g.field_71071_by.field_70460_b[2];
        ItemStack head = this.field_73839_d.field_71439_g.field_71071_by.field_70460_b[3];
        this.drawDoubleOutlinedBox(width / 2 - 100, height - 39, 18, 18, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        this.drawDoubleOutlinedBox(width / 2 - 80, height - 39, 18, 18, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        this.drawDoubleOutlinedBox(width / 2 - 100, height - 19, 18, 18, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        this.drawDoubleOutlinedBox(width / 2 - 80, height - 19, 18, 18, BOX_INNER_COLOR, BOX_OUTLINE_COLOR);
        if (boots != null) {
            RenderHelper.func_74520_c();
            ir.func_82406_b(fr, this.field_73839_d.field_71446_o, boots, width / 2 - 79, height - 18);
            RenderHelper.func_74518_a();
            dmg = boots.func_77952_i();
            color = (int)Math.round(255.0 - (double)dmg * 255.0 / (double)boots.func_77958_k());
            shiftedColor = 255 - color << 16 | color << 8;
            RenderHandler.renderSlots(boots, fr, 0, dmg, width / 2 - 79, height - 18, shiftedColor);
        }
        if (pants != null) {
            RenderHelper.func_74520_c();
            ir.func_82406_b(fr, this.field_73839_d.field_71446_o, pants, width / 2 - 79, height - 38);
            RenderHelper.func_74518_a();
            dmg = pants.func_77952_i();
            color = (int)Math.round(255.0 - (double)dmg * 255.0 / (double)pants.func_77958_k());
            shiftedColor = 255 - color << 16 | color << 8;
            RenderHandler.renderSlots(pants, fr, 0, dmg, width / 2 - 79, height - 38, shiftedColor);
        }
        if (chest != null) {
            RenderHelper.func_74520_c();
            ir.func_82406_b(fr, this.field_73839_d.field_71446_o, chest, width / 2 - 99, height - 18);
            RenderHelper.func_74518_a();
            dmg = chest.func_77952_i();
            color = (int)Math.round(255.0 - (double)dmg * 255.0 / (double)chest.func_77958_k());
            shiftedColor = 255 - color << 16 | color << 8;
            RenderHandler.renderSlots(chest, fr, 0, dmg, width / 2 - 99, height - 18, shiftedColor);
        }
        if (head != null) {
            RenderHelper.func_74520_c();
            ir.func_82406_b(fr, this.field_73839_d.field_71446_o, head, width / 2 - 99, height - 38);
            RenderHelper.func_74518_a();
            dmg = head.func_77952_i();
            color = (int)Math.round(255.0 - (double)dmg * 255.0 / (double)head.func_77958_k());
            shiftedColor = 255 - color << 16 | color << 8;
            RenderHandler.renderSlots(head, fr, 0, dmg, width / 2 - 99, height - 38, shiftedColor);
        }
    }
}

