/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.api.core.NetworkData;
import buildcraft.core.TileBuildCraft;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.tileEntities.Bases.TileCoilBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileHeatedFurnace
extends TileBuildCraft
implements IInventory {
    private final CustomInventory inventory = new CustomInventory("HeatedFurnace", 2, 64, (TileEntity)this);
    @NetworkData
    public int progress = 0;
    @NetworkData
    public boolean isCooking = false;
    public TileCoilBase[] coils = new TileCoilBase[6];
    @NetworkData
    public boolean shouldUpdateCoils;

    public void func_145845_h() {
        if (this.shouldUpdateCoils) {
            this.updateCoils();
            this.shouldUpdateCoils = false;
        }
        if (this.canCook()) {
            if (!this.isCooking) {
                for (TileCoilBase coil : this.coils) {
                    if (coil == null) continue;
                    coil.startHeating();
                    if (!coil.isBurning()) continue;
                    this.isCooking = true;
                    this.doBlockUpdate();
                }
            }
            if (this.progress > 0) {
                this.isCooking = true;
            }
            if (this.progress >= 6500) {
                ItemStack inputStack = this.func_70301_a(0);
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(inputStack);
                if (this.func_70301_a(1) == null) {
                    this.func_70299_a(1, result.func_77946_l());
                } else {
                    this.func_70301_a((int)1).field_77994_a += result.field_77994_a;
                }
                --this.func_70301_a((int)0).field_77994_a;
                if (this.func_70301_a((int)0).field_77994_a == 0) {
                    this.func_70299_a(0, null);
                }
                this.progress = 0;
            } else {
                for (TileCoilBase coil : this.coils) {
                    if (coil == null) continue;
                    this.progress += coil.getIncrement();
                }
            }
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.isCooking = false;
        this.doBlockUpdate();
        this.progress = 0;
        for (TileCoilBase coil : this.coils) {
            if (coil == null) continue;
            coil.stopHeating();
        }
    }

    public void doBlockUpdate() {
        this.sendNetworkUpdate();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canCook() {
        ItemStack stack0 = this.func_70301_a(0);
        ItemStack stack1 = this.func_70301_a(1);
        if (stack0 == null || this.getResult(stack0) == null) {
            return false;
        }
        ItemStack result = this.getResult(stack0);
        return stack1 == null || result.func_77973_b() == stack1.func_77973_b() && result.field_77994_a + stack1.field_77994_a <= result.func_77976_d();
    }

    public ItemStack getResult(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    public void updateCoils() {
        TileEntity entity = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        this.coils[0] = entity instanceof TileCoilBase ? (TileCoilBase)entity : null;
        entity = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        this.coils[1] = entity instanceof TileCoilBase ? (TileCoilBase)entity : null;
        entity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        this.coils[2] = entity instanceof TileCoilBase ? (TileCoilBase)entity : null;
        entity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        this.coils[3] = entity instanceof TileCoilBase ? (TileCoilBase)entity : null;
        entity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        this.coils[4] = entity instanceof TileCoilBase ? (TileCoilBase)entity : null;
        entity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        this.coils[5] = entity instanceof TileCoilBase ? (TileCoilBase)entity : null;
        this.isCooking = false;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory.readNBT(nbtTagCompound);
        this.progress = nbtTagCompound.func_74762_e("progress");
        this.isCooking = nbtTagCompound.func_74767_n("isCooking");
        this.shouldUpdateCoils = true;
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.inventory.writeNBT(nbtTagCompound);
        nbtTagCompound.func_74768_a("progress", this.progress);
        nbtTagCompound.func_74757_a("isCooking", this.isCooking);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.getResult(stack) != null;
    }

    public int getScaledProgress() {
        return this.progress * 23 / 6500 + 1;
    }
}

