/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.mj.MjBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.SimpleInventory;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.api.IKineticCapsule;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileChargingStation
extends TileBuildCraft
implements IInventory,
IOverrideDefaultTriggers {
    @MjBattery(maxCapacity=10000.0, maxReceivedPerCycle=100.0)
    double energy = 0.0;
    private final SimpleInventory inventory = new SimpleInventory(1, "ChargingStation", 1);

    public void func_145845_h() {
        int charge = 100;
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof IKineticCapsule)) {
            return;
        }
        IKineticCapsule battery = (IKineticCapsule)stack.func_77973_b();
        if (battery.getEnergy(stack) + (double)charge > (double)battery.getCapacity()) {
            charge = battery.getCapacity() - (int)battery.getEnergy(stack);
        }
        if (this.energy < (double)charge) {
            charge = (int)this.energy;
        }
        battery.increaseEnergy(stack, charge);
        this.energy -= (double)charge;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory.readFromNBT(nbtTagCompound);
        this.energy = nbtTagCompound.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.inventory.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74780_a("energy", this.energy);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inventory.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory.func_70299_a(var1, var2);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IKineticCapsule;
    }

    public double getProgress() {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof IKineticCapsule) {
            IKineticCapsule battery = (IKineticCapsule)stack.func_77973_b();
            return battery.getEnergy(stack) / (double)battery.getCapacity();
        }
        return 0.0;
    }

    public int getToolEnergy() {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof IKineticCapsule) {
            return (int)stack.field_77990_d.func_74769_h("energy");
        }
        return 0;
    }

    public int getToolMaxEnergy() {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof IKineticCapsule) {
            IKineticCapsule battery = (IKineticCapsule)stack.func_77973_b();
            return battery.getCapacity();
        }
        return 0;
    }

    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> list = new LinkedList<ITrigger>();
        list.add((ITrigger)BuildcraftAdditions.triggerDoneCharging);
        list.add((ITrigger)BuildcraftAdditions.triggerReadyToCharge);
        return list;
    }
}

