/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.BuildCraftEnergy;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.core.IItemPipe;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.energy.TileEngine;
import buildcraftAdditions.client.gui.ContainerAmplifiedEngine;
import buildcraftAdditions.items.ItemCanister;
import buildcraftAdditions.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileAmplifiedEngine
extends TileEngine
implements IInventory {
    public static float HEAT_PER_MJ = 0.0023f;
    public static float COOLDOWN_RATE = 0.05f;
    public static int MAX_COOLANT_PER_TICK = 40;
    private int burnTime = 0;
    private IronEngineFuel.Fuel currentFuel = null;
    private int penaltyCooling = 0;
    private boolean lastPowered = false;
    private BiomeGenBase biomeCache;
    private final SimpleInventory inventory = new SimpleInventory(2, "EngineInventory", 1);

    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)BuildCraftEnergy.instance, 20, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[2];
    }

    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[2];
    }

    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.07f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.04f;
            }
            case GREEN: {
                return 0.05f;
            }
            case YELLOW: {
                return 0.06f;
            }
            case RED: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    private float getBiomeTempScalar() {
        if (this.biomeCache == null) {
            this.biomeCache = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
        }
        float tempScalar = this.biomeCache.field_76750_F - 1.0f;
        tempScalar *= 0.5f;
        return tempScalar += 1.0f;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.biomeCache = null;
    }

    public boolean isBurning() {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof ItemCanister)) {
            return false;
        }
        FluidStack fuel = Utils.getFluidStackFromItemStack(stack);
        return fuel != null && fuel.amount > 0 && this.penaltyCooling == 0 && this.isRedstonePowered;
    }

    public void burn() {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemCanister)) {
            return;
        }
        FluidStack fuel = Utils.getFluidStackFromItemStack(stack);
        if (this.currentFuel == null && fuel != null) {
            this.currentFuel = IronEngineFuel.getFuelForFluid((Fluid)fuel.getFluid());
        }
        if (this.currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0 && this.isRedstonePowered) {
            this.lastPowered = true;
            if (this.burnTime > 0 || fuel != null && fuel.amount > 0) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                }
                if (this.burnTime <= 0) {
                    if (fuel != null) {
                        if (--fuel.amount <= 0) {
                            // empty if block
                        }
                        this.burnTime = this.currentFuel.totalBurningTime / 1000;
                    } else {
                        this.currentFuel = null;
                        return;
                    }
                }
                this.currentOutput = this.currentFuel.powerPerCycle;
                this.addEnergy(this.currentFuel.powerPerCycle);
                this.heat += this.currentFuel.powerPerCycle * HEAT_PER_MJ * this.getBiomeTempScalar();
            }
        } else if (this.penaltyCooling <= 0 && this.lastPowered) {
            this.lastPowered = false;
            this.penaltyCooling = 10;
        }
    }

    public void engineUpdate() {
        if (this.heat > 20.0f && (this.penaltyCooling > 0 || !this.isRedstonePowered)) {
            this.heat -= COOLDOWN_RATE;
            this.coolEngine(20.0f);
            this.getEnergyStage();
        } else if (this.heat > 100.0f) {
            this.coolEngine(100.0f);
        }
        if (this.heat <= 20.0f && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
        if (this.heat <= 20.0f) {
            this.heat = 20.0f;
        }
    }

    private void coolEngine(float idealHeat) {
        float extraHeat = this.heat - idealHeat;
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemCanister)) {
            return;
        }
        ItemCanister canister = (ItemCanister)stack.func_77973_b();
        FluidStack coolant = Utils.getFluidStackFromItemStack(stack);
        if (coolant == null) {
            return;
        }
        int coolantAmount = Math.min(MAX_COOLANT_PER_TICK, coolant.amount);
        IronEngineCoolant.Coolant currentCoolant = IronEngineCoolant.getCoolant((FluidStack)coolant);
        if (currentCoolant != null) {
            float cooling = currentCoolant.getDegreesCoolingPerMB(this.heat);
            if ((float)coolantAmount * (cooling /= this.getBiomeTempScalar()) > extraHeat) {
                canister.drain(stack, Math.round(extraHeat / cooling), true);
                this.heat -= extraHeat;
            } else {
                canister.drain(stack, coolantAmount, true);
                this.heat -= (float)coolantAmount * cooling;
            }
        }
    }

    public int getScaledBurnTime(int i) {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return 0;
        }
        if (!(stack.func_77973_b() instanceof ItemCanister)) {
            return 0;
        }
        ItemCanister canister = (ItemCanister)stack.func_77973_b();
        return canister.getFluid(stack) != null ? (int)((float)canister.getFluid((ItemStack)stack).amount / (float)canister.getCapacity(stack) * (float)i) : 0;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory.readFromNBT(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.penaltyCooling = data.func_74762_e("penaltyCooling");
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.inventory.writeToNBT(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("penaltyCooling", this.penaltyCooling);
    }

    public double maxEnergyReceived() {
        return 2000.0;
    }

    public double maxEnergyExtracted() {
        return 500.0;
    }

    public float explosionRange() {
        return 5.0f;
    }

    public double getMaxEnergy() {
        return 10000.0;
    }

    public double getCurrentOutput() {
        if (this.currentFuel == null) {
            return 0.0;
        }
        return this.currentFuel.powerPerCycle;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemCanister)) {
            return;
        }
        ItemCanister canister = (ItemCanister)stack.func_77973_b();
        ItemStack stack2 = this.func_70301_a(1);
        if (stack2 == null) {
            return;
        }
        if (!(stack2.func_77973_b() instanceof ItemCanister)) {
            return;
        }
        ItemCanister canister2 = (ItemCanister)stack.func_77973_b();
        switch (id) {
            case 15: {
                if (canister.getFluid(stack) == null) {
                    canister.setFluid(stack, new FluidStack(value, 0));
                    break;
                }
                canister.getFluid((ItemStack)stack).fluidID = value;
                break;
            }
            case 16: {
                if (canister2.getFluid(stack2) == null) {
                    canister2.setFluid(stack2, new FluidStack(value, 0));
                    break;
                }
                canister2.getFluid((ItemStack)stack2).fluidID = value;
                break;
            }
            case 17: {
                if (canister.getFluid(stack) == null) {
                    canister.setFluid(stack, new FluidStack(0, value));
                    break;
                }
                canister.getFluid((ItemStack)stack).amount = value;
                break;
            }
            case 18: {
                if (canister2.getFluid(stack2) == null) {
                    canister2.setFluid(stack2, new FluidStack(0, value));
                    break;
                }
                canister2.getFluid((ItemStack)stack2).amount = value;
            }
        }
    }

    public void sendGUINetworkData(ContainerAmplifiedEngine containerEngine, ICrafting iCrafting) {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return;
        }
        if (!(stack.func_77973_b() instanceof ItemCanister)) {
            return;
        }
        ItemCanister canister = (ItemCanister)stack.func_77973_b();
        ItemStack stack2 = this.func_70301_a(1);
        if (stack2 == null) {
            return;
        }
        if (!(stack2.func_77973_b() instanceof ItemCanister)) {
            return;
        }
        ItemCanister canister2 = (ItemCanister)stack.func_77973_b();
        iCrafting.func_71112_a((Container)containerEngine, 15, canister.getFluid(stack) != null ? canister.getFluid((ItemStack)stack).fluidID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 16, canister2.getFluid(stack2) != null ? canister2.getFluid((ItemStack)stack2).fluidID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 17, canister.getFluid(stack) != null ? canister.getFluid((ItemStack)stack).amount : 0);
        iCrafting.func_71112_a((Container)containerEngine, 18, canister2.getFluid(stack2) != null ? canister2.getFluid((ItemStack)stack2).amount : 0);
    }

    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }
}

