/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.core;

import buildcraftAdditions.core.Logger;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

public class VersionCheck {
    public static boolean newerVersionAvailable = false;
    public static String newerVersionNumber = "";
    public static String currentVersion = "1.6.1";
    public static String[] changelog;
    public static int numLines;

    public static void start() {
        VersionCheckThread thread = new VersionCheckThread();
        thread.start();
    }

    static {
        numLines = 0;
    }

    private static class VersionCheckThread
    extends Thread {
        private VersionCheckThread() {
        }

        @Override
        public void run() {
            Logger.info("Buildcraft Additions version check initiated, current version: @VERSION@");
            try {
                URL version = new URL("https://raw.githubusercontent.com/AEnterprise/Buildcraft-Additions/master/src/main/resources/changelogs/version.txt");
                BufferedReader reader = new BufferedReader(new InputStreamReader(version.openStream()));
                newerVersionNumber = reader.readLine();
                if (!currentVersion.equals(newerVersionNumber)) {
                    String line;
                    newerVersionAvailable = true;
                    Logger.info("There is a newer version of Buildcraft Additions available (" + newerVersionNumber + ") please considder updating");
                    URL changelogURL = new URL("https://raw.githubusercontent.com/AEnterprise/Buildcraft-Additions/master/src/main/resources/changelogs/" + newerVersionNumber);
                    BufferedReader changelogReader = new BufferedReader(new InputStreamReader(changelogURL.openStream()));
                    ArrayList<String> changelogList = new ArrayList<String>();
                    while ((line = changelogReader.readLine()) != null) {
                        changelogList.add(line);
                        ++numLines;
                    }
                    changelog = new String[10];
                    changelogList.toArray(changelog);
                    this.pingVersionChecker();
                }
            }
            catch (Throwable e) {
                Logger.error("Builcraft Additions version check failed!");
                e.printStackTrace();
            }
        }

        public void pingVersionChecker() {
            if (Loader.isModLoaded((String)"VersionChecker")) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("modDisplayName", "Buildcraft Additions");
                tag.func_74778_a("oldVersion", currentVersion);
                tag.func_74778_a("newVersion", newerVersionNumber);
                tag.func_74778_a("updateUrl", "http://buildcraftadditions.wordpress.com/downloads/");
                tag.func_74757_a("isDirectLink", false);
                StringBuilder builder = new StringBuilder();
                for (int t = 0; t < numLines; ++t) {
                    builder.append(changelog[t]).append("/n");
                }
                tag.func_74778_a("changeLog", builder.toString());
                FMLInterModComms.sendRuntimeMessage((Object)"bcadditions", (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)tag);
            }
        }
    }
}

