/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.render;

import buildcraftAdditions.items.ItemCanister;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class CanisterItemRender
implements IItemRenderer {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    private static final ResourceLocation ITEM_TEXTURE = TextureMap.field_110576_c;
    private ItemCanister canister;

    public CanisterItemRender(ItemCanister canister) {
        this.canister = canister;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type.equals((Object)IItemRenderer.ItemRenderType.ENTITY);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Fluid fluid;
        IIcon overlay = this.canister.overlay;
        IIcon cannister = this.canister.func_77617_a(0);
        GL11.glPushMatrix();
        if (type.equals((Object)IItemRenderer.ItemRenderType.EQUIPPED)) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)-1.0, (double)-1.0, (double)0.0);
        } else if (type.equals((Object)IItemRenderer.ItemRenderType.ENTITY)) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.9, (double)0.0);
            if (item.func_82839_y()) {
                GL11.glTranslated((double)0.1, (double)0.4, (double)0.0);
                GL11.glScaled((double)0.85, (double)0.85, (double)0.85);
            }
        } else if (type.equals((Object)IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON)) {
            GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        }
        if (item.field_77990_d != null && item.func_77978_p().func_74764_b("Fluid") && (fluid = FluidRegistry.getFluid((String)item.field_77990_d.func_74775_l("Fluid").func_74779_i("FluidName"))) != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ITEM_TEXTURE);
            this.renderMask(overlay, fluid.getIcon(), type);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ITEM_TEXTURE);
        if (!type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)cannister.func_94209_e(), (float)cannister.func_94210_h(), (float)cannister.func_94212_f(), (float)cannister.func_94206_g(), (int)cannister.func_94211_a(), (int)cannister.func_94216_b(), (float)0.0625f);
        } else {
            this.renderIcon(cannister, 0.0);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderMask(IIcon mask, IIcon subIcon, IItemRenderer.ItemRenderType type) {
        if (mask == null || subIcon == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3008);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(mask, 0.001);
        } else {
            this.preRenderWorldIcon(mask, 0.001);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(mask, -0.0635);
        } else {
            this.preRenderWorldIcon(mask, -0.0635);
        }
        tessellator.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(BLOCK_TEXTURE);
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(subIcon, 0.001);
        } else {
            this.preRenderWorldIcon(subIcon, 0.001);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(subIcon, -0.0635);
        } else {
            this.preRenderWorldIcon(subIcon, -0.0635);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void preRenderInvIcon(IIcon icon, double z) {
        Tessellator.field_78398_a.func_78374_a(16.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 16.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 16.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private void preRenderWorldIcon(IIcon icon, double z) {
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 1.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(1.0, 1.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
    }

    private void renderIcon(IIcon icon, double z) {
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78374_a(16.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(0.0, 16.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(16.0, 16.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78381_a();
    }
}

