/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraftAdditions.client.gui.ContainerChargingStation;
import buildcraftAdditions.tileEntities.TileChargingStation;
import buildcraftAdditions.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public class GuiChargingStation
extends GuiBuildCraft {
    TileChargingStation chargingStation;
    public static ResourceLocation texture = new ResourceLocation("bcadditions", "textures/gui/ChargingStation.png");
    public ResourceLocation ITEM_TEXTURE = TextureMap.field_110576_c;

    public GuiChargingStation(InventoryPlayer inventoryPlayer, TileChargingStation tile) {
        super((BuildCraftContainer)new ContainerChargingStation(inventoryPlayer, tile), (IInventory)tile, texture);
        this.chargingStation = tile;
    }

    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.add((GuiBuildCraft.Ledger)new ChargingStationLedger((TileChargingStation)this.tile));
    }

    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String title = Utils.localize("tile.blockChargingStation.name");
        this.field_146289_q.func_78276_b(Utils.localize(title), this.getCenteredOffset(title), 6, 0x404040);
        this.field_146289_q.func_78276_b(Utils.localize("gui.inventory"), 8, this.field_147000_g - 110 + 2, 0x404040);
    }

    protected class ChargingStationLedger
    extends GuiBuildCraft.Ledger {
        TileChargingStation chargingStation;
        int headerColour;
        int subheaderColour;
        int textColour;

        public ChargingStationLedger(TileChargingStation chargingStation) {
            super((GuiBuildCraft)GuiChargingStation.this);
            this.headerColour = 14797103;
            this.subheaderColour = 11186104;
            this.textColour = 0;
            this.chargingStation = chargingStation;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiChargingStation.this.ITEM_TEXTURE);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiChargingStation.this.field_146289_q.func_78261_a(Utils.localize("gui.progress"), x + 22, y + 8, this.headerColour);
            GuiChargingStation.this.field_146289_q.func_78261_a(Utils.localize("gui.progress") + ":", x + 22, y + 20, this.subheaderColour);
            GuiChargingStation.this.field_146289_q.func_78276_b(String.format("%.1f ", this.chargingStation.getProgress() * 100.0) + "%", x + 22, y + 32, this.textColour);
            GuiChargingStation.this.field_146289_q.func_78261_a(Utils.localize("gui.energyInTool") + ":", x + 22, y + 44, this.subheaderColour);
            GuiChargingStation.this.field_146289_q.func_78276_b(Integer.toString(this.chargingStation.getToolEnergy()) + " MJ", x + 22, y + 56, this.textColour);
            GuiChargingStation.this.field_146289_q.func_78261_a(Utils.localize("gui.maxEnergy") + ":", x + 22, y + 68, this.subheaderColour);
            GuiChargingStation.this.field_146289_q.func_78276_b(Integer.toString(this.chargingStation.getToolMaxEnergy()) + " MJ", x + 22, y + 80, this.textColour);
        }

        public String getTooltip() {
            return String.format("%.1f", this.chargingStation.getProgress() * 100.0) + "%";
        }
    }
}

