/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.blocks;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.core.IItemPipe;
import buildcraftAdditions.api.IEurekaBlock;
import buildcraftAdditions.blocks.BlockBase;
import buildcraftAdditions.tileEntities.TileKineticDuster;
import buildcraftAdditions.utils.Eureka;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockKineticDuster
extends BlockBase
implements IEurekaBlock {
    public IIcon bottom;
    public IIcon[] sides;
    public IIcon top;

    public BlockKineticDuster() {
        super(Material.field_151573_f);
    }

    @Override
    public boolean isAllowed(EntityPlayer player) {
        return Eureka.isUnlocked(player, "dusterTier2-2");
    }

    @Override
    public ItemStack[] getComponents() {
        return new ItemStack[]{new ItemStack(Blocks.field_150359_w, 3), new ItemStack(BuildCraftTransport.pipeItemsGold, 2), new ItemStack(BuildCraftCore.goldGearItem, 2), new ItemStack(BuildCraftCore.diamondGearItem)};
    }

    @Override
    public String getMessage() {
        return Utils.localize("eureka.missingKnowledge");
    }

    public TileEntity func_149915_a(World world, int getal) {
        return new TileKineticDuster();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        super.func_149727_a(world, x, y, z, player, par6, par7, par8, par9);
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
            return false;
        }
        TileKineticDuster duster = (TileKineticDuster)world.func_147438_o(x, y, z);
        if (duster != null && duster.func_70301_a(0) == null && player.func_71045_bC() != null) {
            ItemStack stack = player.func_71045_bC().func_77946_l();
            stack.field_77994_a = 1;
            duster.func_70299_a(0, stack);
            --player.func_71045_bC().field_77994_a;
            if (player.func_71045_bC().field_77994_a <= 0) {
                player.func_70062_b(0, null);
            }
        } else if (duster.func_70301_a(0) != null) {
            if (!world.field_72995_K) {
                Utils.dropItemstack(world, x, y, z, duster.func_70301_a(0));
            }
            duster.func_70299_a(0, null);
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, i, j, k, entityliving, stack);
        if (entityliving instanceof EntityPlayer) {
            Eureka.eurekaBlockEvent(world, this, i, j, k, (EntityPlayer)entityliving);
        }
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.func_72921_c(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    public boolean func_149662_c() {
        return false;
    }

    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                return this.bottom;
            }
            case 1: {
                return this.top;
            }
        }
        TileKineticDuster duster = (TileKineticDuster)access.func_147438_o(x, y, z);
        return this.sides[duster.progressStage];
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.bottom;
            }
            case 1: {
                return this.top;
            }
        }
        return this.sides[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.sides = new IIcon[4];
        this.sides[0] = par1IconRegister.func_94245_a("bcadditions:dusterKineticSide0");
        this.sides[1] = par1IconRegister.func_94245_a("bcadditions:dusterKineticSide1");
        this.sides[2] = par1IconRegister.func_94245_a("bcadditions:dusterKineticSide2");
        this.sides[3] = par1IconRegister.func_94245_a("bcadditions:dusterKineticSide3");
        this.bottom = par1IconRegister.func_94245_a("bcadditions:dusterKineticBottom");
        this.top = par1IconRegister.func_94245_a("bcadditions:dusterKineticTop");
    }
}

