/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.blocks;

import buildcraft.core.IItemPipe;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.tileEntities.TileHeatedFurnace;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHeatedFurnace
extends BlockContainer {
    public IIcon front;
    public IIcon back;
    public IIcon sides;
    public IIcon top;
    public IIcon bottom;
    public IIcon frontActivated;
    public boolean isActivated;

    public BlockHeatedFurnace() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.isActivated = false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileHeatedFurnace();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        super.func_149727_a(world, x, y, z, entityplayer, par6, par7, par8, par9);
        if (entityplayer.func_70093_af()) {
            return false;
        }
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof IItemPipe) {
            return false;
        }
        if (!world.field_72995_K) {
            entityplayer.openGui((Object)BuildcraftAdditions.instance, 73, world, x, y, z);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileHeatedFurnace) {
            TileHeatedFurnace furnace = (TileHeatedFurnace)tile;
            furnace.updateCoils();
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileHeatedFurnace) {
            TileHeatedFurnace furnace = (TileHeatedFurnace)tile;
            furnace.updateCoils();
        }
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.func_72921_c(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileHeatedFurnace heatedFurnace = (TileHeatedFurnace)world.func_147438_o(x, y, z);
        for (int t = 0; t < 2; ++t) {
            ItemStack stack = heatedFurnace.func_70301_a(t);
            if (stack == null) continue;
            heatedFurnace.func_70299_a(t, null);
            Utils.dropItemstack(world, x, y, z, stack);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        int meta = access.func_72805_g(x, y, z);
        if (meta == 0 && side == 3) {
            return this.front;
        }
        if (side == meta && meta > 1) {
            TileHeatedFurnace furnace = (TileHeatedFurnace)access.func_147438_o(x, y, z);
            if (furnace.isCooking) {
                return this.frontActivated;
            }
            return this.front;
        }
        switch (side) {
            case 0: {
                return this.bottom;
            }
            case 1: {
                return this.top;
            }
            case 5: {
                return this.back;
            }
        }
        return this.sides;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.front;
        }
        if (side == meta && meta > 1) {
            return this.front;
        }
        if (side == ForgeDirection.getOrientation((int)meta).getOpposite().ordinal()) {
            switch (side) {
                case 0: {
                    return this.bottom;
                }
                case 1: {
                    return this.top;
                }
            }
        }
        return this.sides;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.front = par1IconRegister.func_94245_a("bcadditions:furnaceFront");
        this.frontActivated = par1IconRegister.func_94245_a("bcadditions:furnaceFront_on");
        this.top = par1IconRegister.func_94245_a("bcadditions:furnaceTop");
        this.back = par1IconRegister.func_94245_a("bcadditions:furnaceBack");
        this.bottom = par1IconRegister.func_94245_a("bcadditions:furnaceBottom");
        this.sides = par1IconRegister.func_94245_a("bcadditions:furnaceSide");
    }
}

