/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.blocks;

import buildcraft.core.IItemPipe;
import buildcraftAdditions.blocks.BlockBase;
import buildcraftAdditions.tileEntities.Bases.TileBaseDuster;
import buildcraftAdditions.tileEntities.TileBasicDuster;
import buildcraftAdditions.utils.Utils;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBasicDuster
extends BlockBase {
    public IIcon front;
    public IIcon back;
    public IIcon sides;
    public IIcon top;
    public IIcon bottom;

    public BlockBasicDuster() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.func_72921_c(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    public TileEntity func_149915_a(World world, int variable) {
        return new TileBasicDuster();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        super.func_149727_a(world, x, y, z, player, par6, par7, par8, par9);
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
            return false;
        }
        TileBaseDuster duster = (TileBaseDuster)world.func_147438_o(x, y, z);
        if (duster != null && duster.func_70301_a(0) == null && player.func_71045_bC() != null) {
            ItemStack stack = player.func_71045_bC().func_77946_l();
            stack.field_77994_a = 1;
            duster.func_70299_a(0, stack);
            --player.func_71045_bC().field_77994_a;
            if (player.func_71045_bC().field_77994_a <= 0) {
                player.func_70062_b(0, null);
            }
        } else if (duster.func_70301_a(0) != null) {
            if (!world.field_72995_K) {
                Utils.dropItemstack(world, x, y, z, duster.func_70301_a(0));
            }
            duster.func_70299_a(0, null);
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float hit) {
        TileEntity tileEntity;
        if (entity instanceof EntityPlayer && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileBasicDuster) {
            ((TileBasicDuster)tileEntity).makeProgress((EntityPlayer)entity);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.front;
        }
        if (side == meta && meta > 1) {
            return this.front;
        }
        switch (side) {
            case 0: {
                return this.bottom;
            }
            case 1: {
                return this.top;
            }
        }
        if (side == ForgeDirection.getOrientation((int)meta).getOpposite().ordinal()) {
            return this.back;
        }
        return this.sides;
    }

    public void func_149651_a(IIconRegister register) {
        this.front = register.func_94245_a("bcadditions:dusterFront");
        this.back = register.func_94245_a("bcadditions:dusterBack");
        this.sides = register.func_94245_a("bcadditions:dusterSides");
        this.top = register.func_94245_a("bcadditions:dusterTop");
        this.bottom = register.func_94245_a("bcadditions:dusterBottom");
    }
}

