/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils;

import buildcraftAdditions.api.EurekaRegistry;
import buildcraftAdditions.api.IEurekaBlock;
import buildcraftAdditions.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class Eureka {
    public static void init(EntityPlayer player) {
        if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound tag = Eureka.getTag(player);
        for (String key : EurekaRegistry.getKeys()) {
            Eureka.initKey(tag, key);
        }
    }

    private static NBTTagCompound getTag(EntityPlayer player) {
        return (NBTTagCompound)player.getEntityData().func_74781_a("PlayerPersisted");
    }

    public static int getProgress(EntityPlayer player, String key) {
        Eureka.initKey(Eureka.getTag(player), key);
        return Eureka.getTag(player).func_74762_e(key + "Progress");
    }

    public static boolean isUnlocked(EntityPlayer player, String key) {
        Eureka.initKey(Eureka.getTag(player), key);
        return Eureka.getTag(player).func_74767_n(key + "Finished");
    }

    public static void makeProgress(EntityPlayer player, String key) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        int progress = Eureka.getProgress(player, key);
        NBTTagCompound tag = Eureka.getTag(player);
        if (progress < EurekaRegistry.getMaxValue(key)) {
            Eureka.setKey(tag, key + "Progress", progress + EurekaRegistry.getIncrement(key));
        }
        if (progress >= EurekaRegistry.getMaxValue(key) && !Eureka.isUnlocked(player, key)) {
            Eureka.setKey(tag, key + "Finished", true);
            String message = Utils.localize("eureka." + key + "Finished");
            player.func_145747_a((IChatComponent)new ChatComponentText(Utils.localize("Eureka")));
            player.func_146105_b((IChatComponent)new ChatComponentText(message));
        }
    }

    private static void initKey(NBTTagCompound tag, String key) {
        if (!tag.func_74764_b(key + "Progress")) {
            Eureka.setKey(tag, key + "Progress", 0);
            Eureka.setKey(tag, key + "Finished", false);
        }
    }

    private static void setKey(NBTTagCompound tag, String key, int integer) {
        tag.func_74768_a(key, integer);
    }

    private static void setKey(NBTTagCompound tag, String key, boolean bool) {
        tag.func_74757_a(key, bool);
    }

    public static void eurekaBlockEvent(World world, IEurekaBlock block, int x, int y, int z, EntityPlayer player) {
        if (block == null) {
            return;
        }
        if (!world.field_72995_K && !block.isAllowed(player)) {
            ItemStack[] stackArray;
            for (ItemStack stack : stackArray = block.getComponents()) {
                Utils.dropItemstack(world, x, y, z, stack);
            }
            if (!world.field_72995_K) {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
            world.func_147475_p(x, y, z);
            world.func_147471_g(x, y, z);
            player.func_146105_b((IChatComponent)new ChatComponentText(block.getMessage()));
        }
    }
}

