/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.api.core.NetworkData;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.mj.MjBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.core.network.PacketGuiReturn;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.items.ItemCanister;
import buildcraftAdditions.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidicCompressor
extends TileBuildCraft
implements ISidedInventory,
IFluidHandler,
IGuiReturnHandler,
IOverrideDefaultTriggers {
    private final CustomInventory inventory = new CustomInventory("FluidicCompressor", 2, 1, (TileEntity)this);
    public final int maxLiquid = 10000;
    @MjBattery(maxCapacity=800.0, maxReceivedPerCycle=100.0)
    public double energyStored = 0.0;
    public Tank tank = new Tank("tank", 10000, (TileEntity)this);
    private TankManager tankManager = new TankManager();
    @NetworkData
    public boolean fill;

    public TileFluidicCompressor() {
        this.tankManager.add((Object)this.tank);
    }

    public void func_145845_h() {
        ItemStack itemstack = this.inventory.func_70301_a(0);
        if (itemstack != null) {
            ItemCanister item = null;
            Item itemInSlot = itemstack.func_77973_b();
            if (itemInSlot instanceof ItemCanister) {
                item = (ItemCanister)itemstack.func_77973_b();
            }
            if (item != null) {
                int amount = 100;
                if (this.fill && !this.tank.isEmpty()) {
                    if (this.tank.getFluid().amount < 100) {
                        amount = this.tank.getFluid().amount;
                    }
                    if (this.energyStored >= (double)amount) {
                        this.tank.drain(item.fill(itemstack, new FluidStack(this.tank.getFluid(), amount), true), true);
                        this.energyStored -= (double)amount;
                        FluidStack fluid = Utils.getFluidStackFromItemStack(itemstack);
                        if (fluid != null && this.getProgress() == 16) {
                            if (this.inventory.func_70301_a(1) == null) {
                                this.inventory.func_70299_a(1, itemstack);
                                this.inventory.func_70299_a(0, null);
                            } else if (this.inventory.func_70301_a(1).func_77973_b() == this.inventory.func_70301_a(0).func_77973_b() && this.inventory.func_70301_a((int)1).field_77994_a < 4) {
                                ++this.inventory.func_70301_a((int)1).field_77994_a;
                                this.inventory.func_70299_a(0, null);
                            }
                        }
                    }
                } else {
                    amount = 50;
                    if (!this.fill && !this.tank.isFull() && Utils.getFluidStackFromItemStack(itemstack) != null) {
                        if (!this.tank.isEmpty() && this.tank.getCapacity() - this.tank.getFluid().amount < 1000) {
                            amount = this.tank.getCapacity() - this.tank.getFluid().amount;
                        }
                        if (amount > Utils.getFluidStackFromItemStack((ItemStack)itemstack).amount) {
                            amount = Utils.getFluidStackFromItemStack((ItemStack)itemstack).amount;
                        }
                        this.tank.fill(item.drain(itemstack, amount, true), true);
                        if (this.getProgress() == 16) {
                            itemstack.func_77978_p().func_82580_o("Fluid");
                            if (this.inventory.func_70301_a(1) == null) {
                                this.inventory.func_70299_a(1, itemstack);
                                this.inventory.func_70299_a(0, null);
                            } else if (this.inventory.func_70301_a(1).func_77973_b() == this.inventory.func_70301_a(0).func_77973_b() && this.inventory.func_70301_a((int)1).field_77994_a < 4) {
                                ++this.inventory.func_70301_a((int)1).field_77994_a;
                                this.inventory.func_70299_a(0, null);
                            }
                        }
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory.readNBT(nbtTagCompound);
        this.tankManager.readFromNBT(nbtTagCompound);
        this.fill = nbtTagCompound.func_74767_n("fill");
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.inventory.writeNBT(nbtTagCompound);
        this.tankManager.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74757_a("fill", this.fill);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inventory.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inventory.func_70299_a(slotId, itemstack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70295_k_();
    }

    public boolean func_94041_b(int slotid, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return slotid == 0 && item instanceof ItemCanister;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluidType() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getScaledLiquid(int i) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().amount / 10000.0f * (float)i) : 0;
    }

    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(new PacketPayload.StreamWriter(){

            public void writeData(ByteBuf data) {
                TileFluidicCompressor.this.tankManager.writeData(data);
                data.writeBoolean(TileFluidicCompressor.this.fill);
            }
        });
        return payload;
    }

    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        ByteBuf stream = packet.payload.stream;
        this.tankManager.readData(stream);
        this.fill = stream.readBoolean();
    }

    public void writeGuiData(ByteBuf data) {
    }

    public void readGuiData(ByteBuf data, EntityPlayer player) {
        this.fill = data.readBoolean();
    }

    public void sendModeUpdatePacket() {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeBoolean(this.fill);
            PacketGuiReturn pkt = new PacketGuiReturn((IGuiReturnHandler)this, bytes.toByteArray());
            pkt.sendPacket();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getProgress() {
        ItemStack itemstack = this.inventory.func_70301_a(0);
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (!(item instanceof ItemCanister)) {
            return 0;
        }
        FluidStack fluidstack = Utils.getFluidStackFromItemStack(itemstack);
        ItemCanister canister = (ItemCanister)itemstack.func_77973_b();
        if (fluidstack == null) {
            if (this.fill) {
                return 0;
            }
            return 0;
        }
        int capacity = canister.getCapacity(itemstack);
        if (this.fill) {
            return fluidstack.amount * 16 / capacity;
        }
        return (capacity - fluidstack.amount) * 16 / capacity;
    }

    public int[] func_94128_d(int side) {
        return Utils.createSlotArray(0, 2);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return side != 0 && this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public int getFluidStored() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().amount;
        }
        return 0;
    }

    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> list = new LinkedList<ITrigger>();
        list.add((ITrigger)BuildcraftAdditions.triggerCanAcceptCanister);
        list.add((ITrigger)BuildcraftAdditions.triggerHasEmptyCanister);
        list.add((ITrigger)BuildcraftAdditions.triggerhasFullCanister);
        return list;
    }
}

