/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.core;

import buildcraftAdditions.items.BatteryBase;
import buildcraftAdditions.items.Tools.ItemPoweredBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryTool
extends InventoryBasic {
    EntityPlayer player;
    ItemStack tool;
    boolean reading;

    public InventoryTool(EntityPlayer player, ItemStack stack) {
        super("Tool Inventory", false, 3);
        this.player = player;
        this.tool = stack;
        if (!this.hasInventory()) {
            this.createInventory();
        }
    }

    private boolean hasInventory() {
        return this.tool.field_77990_d != null && this.tool.field_77990_d.func_74781_a("Inventory") != null;
    }

    private void createInventory() {
        this.writeToNBT();
    }

    protected void writeToNBT() {
        NBTTagList itemList = new NBTTagList();
        for (int t = 0; t < this.func_70302_i_(); ++t) {
            if (this.func_70301_a(t) == null) continue;
            NBTTagCompound slotContent = new NBTTagCompound();
            slotContent.func_74774_a("Slot", (byte)t);
            this.func_70301_a(t).func_77955_b(slotContent);
            itemList.func_74742_a((NBTBase)slotContent);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a("Items", (NBTBase)itemList);
        if (this.tool.field_77990_d == null) {
            this.tool.field_77990_d = new NBTTagCompound();
        }
        this.tool.field_77990_d.func_74782_a("Inventory", (NBTBase)inventory);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.saveInventory();
        }
    }

    public static boolean isInventoryEmpty(IInventory inventory) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == null) continue;
            return false;
        }
        return true;
    }

    public void saveInventory() {
        this.writeToNBT();
        this.setNBT();
    }

    protected void setNBT() {
        ItemStack stack = this.player.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemPoweredBase) {
            stack.func_77982_d(this.tool.func_77978_p());
        }
    }

    public void func_70295_k_() {
        this.loadInventory();
    }

    public void loadInventory() {
        this.readFromNBT();
    }

    public void func_70305_f() {
        this.saveInventory();
    }

    protected void readFromNBT() {
        this.reading = true;
        NBTTagList itemList = (NBTTagList)((NBTTagCompound)this.tool.field_77990_d.func_74781_a("Inventory")).func_74781_a("Items");
        for (int t = 0; t < itemList.func_74745_c(); ++t) {
            NBTTagCompound slotEntry = itemList.func_150305_b(t);
            int j = slotEntry.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.func_70302_i_()) continue;
            this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)slotEntry));
        }
        this.reading = false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof BatteryBase;
    }
}

