/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.core;

import buildcraftAdditions.api.IEurekaBlock;
import buildcraftAdditions.api.IEurekaItem;
import buildcraftAdditions.config.ConfigurationHandeler;
import buildcraftAdditions.core.VersionCheck;
import buildcraftAdditions.utils.Eureka;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;

public class EventListener {

    public static class Forge {
        @SubscribeEvent
        public void onPlyerUsesBlock(PlayerInteractEvent event) {
            Block block;
            if (event != null && (block = event.world.func_147439_a(event.x, event.y, event.z)) instanceof IEurekaBlock) {
                Eureka.eurekaBlockEvent(event.world, (IEurekaBlock)block, event.x, event.y, event.z, event.entityPlayer);
            }
        }

        @SubscribeEvent
        public void onItemUse(PlayerUseItemEvent event) {
            IEurekaItem eurekaItem;
            if (event == null) {
                return;
            }
            Item item = event.item.func_77973_b();
            if (item instanceof IEurekaItem && !(eurekaItem = (IEurekaItem)item).isAllowed(event.entityPlayer)) {
                event.setCanceled(true);
                if (event.entityPlayer != null) {
                    event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(eurekaItem.getMessage()));
                }
            }
        }
    }

    public static class FML {
        @SubscribeEvent
        public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (VersionCheck.newerVersionAvailable && event != null) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText("There is a newer version of Buildcraft Additions available (" + VersionCheck.newerVersionNumber + ") Please consider updating"));
                if (!ConfigurationHandeler.shouldPrintChangelog) {
                    return;
                }
                event.player.func_146105_b((IChatComponent)new ChatComponentText("Changelog: "));
                for (int t = 0; t < VersionCheck.numLines; ++t) {
                    event.player.func_146105_b((IChatComponent)new ChatComponentText("- " + VersionCheck.changelog[t]));
                }
            }
            Eureka.init(event.player);
        }

        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.modID.equals("bcadditions")) {
                ConfigurationHandeler.readConfig();
            }
        }
    }
}

