/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemAuraRing;
import vazkii.botania.common.item.equipment.bauble.ItemGreaterAuraRing;
import vazkii.botania.common.item.equipment.tool.ItemManasteelPick;
import vazkii.botania.common.item.equipment.tool.ManasteelToolCommons;

public class ItemTerraPick
extends ItemManasteelPick
implements IManaItem {
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_MANA = "mana";
    private static final int MAX_MANA = 2000000000;
    private static final Material[] MATERIALS = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};
    private static final int[] LEVELS = new int[]{0, 10000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] CREATIVE_MANA = new int[]{9999, 999999, 9999999, 99999999, 999999999, 2000000000};
    IIcon iconTool;
    IIcon iconOverlay;

    public ItemTerraPick() {
        super(BotaniaAPI.terrasteelToolMaterial, "terraPick");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int mana : CREATIVE_MANA) {
            ItemStack stack = new ItemStack(item);
            ItemTerraPick.setMana(stack, mana);
            list.add(stack);
        }
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        String rankFormat = StatCollector.func_74838_a((String)"botaniamisc.toolRank");
        String rank = StatCollector.func_74838_a((String)("botania.rank" + this.getLevel(par1ItemStack)));
        par3List.add(String.format(rankFormat, rank).replaceAll("&", "\u00a7"));
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.getMana(par1ItemStack);
        int level = this.getLevel(par1ItemStack);
        if (level != 0) {
            this.setEnabled(par1ItemStack, !this.isEnabled(par1ItemStack));
            if (!par2World.field_72995_K) {
                par2World.func_72956_a((Entity)par3EntityPlayer, "random.orb", 0.5f, 0.4f);
            }
        }
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (this.isEnabled(par1ItemStack)) {
            int level = this.getLevel(par1ItemStack);
            if (level == 0) {
                this.setEnabled(par1ItemStack, false);
            } else if (par3Entity instanceof EntityPlayer && !((EntityPlayer)par3Entity).field_82175_bq) {
                this.addMana(par1ItemStack, -level);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if (!this.isEnabled(stack)) {
            return false;
        }
        World world = player.field_70170_p;
        Material mat = world.func_147439_a(x, y, z).func_149688_o();
        if (!ManasteelToolCommons.isRightMaterial(mat, MATERIALS)) {
            return false;
        }
        MovingObjectPosition block = ManasteelToolCommons.raytraceFromEntity(world, (Entity)player, true, 4.5);
        if (block == null) {
            return false;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)block.field_72310_e);
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        boolean silk = EnchantmentHelper.func_77502_d((EntityLivingBase)player);
        boolean doX = direction.offsetX == 0;
        boolean doY = direction.offsetY == 0;
        boolean doZ = direction.offsetZ == 0;
        int level = this.getLevel(stack);
        int range = Math.max(0, level - 1);
        int rangeY = Math.max(1, range);
        if (range == 0 && level != 1) {
            return false;
        }
        ManasteelToolCommons.removeBlocksInIteration(player, stack, world, x, y, z, doX ? -range : 0, doY ? -1 : 0, doZ ? -range : 0, doX ? range + 1 : 1, doY ? rangeY * 2 : 1, doZ ? range + 1 : 1, null, MATERIALS, silk, fortune);
        return false;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.iconTool = IconHelper.forItem(par1IconRegister, (Item)this, 0);
        this.iconOverlay = IconHelper.forItem(par1IconRegister, (Item)this, 1);
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return pass == 1 && this.isEnabled(stack) ? this.iconOverlay : this.iconTool;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        if (par2 == 0 || !this.isEnabled(par1ItemStack)) {
            return 0xFFFFFF;
        }
        return Color.HSBtoRGB(0.375f, (float)Math.min(1.0, Math.sin((double)System.currentTimeMillis() / 200.0) * 0.5 + 1.0), 1.0f);
    }

    boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_ENABLED, false);
    }

    void setEnabled(ItemStack stack, boolean enabled) {
        ItemNBTHelper.setBoolean(stack, TAG_ENABLED, enabled);
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public int getLevel(ItemStack stack) {
        int mana = this.getMana(stack);
        for (int i = LEVELS.length - 1; i > 0; --i) {
            if (mana < LEVELS[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return 2000000000;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        ItemTerraPick.setMana(stack, Math.min(this.getMana(stack) + mana, 2000000000));
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !(stack.func_77973_b() instanceof ItemAuraRing) && !(stack.func_77973_b() instanceof ItemGreaterAuraRing);
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return true;
    }
}

