/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class ConfigHandler {
    private static Configuration config;
    public static boolean useShaders;
    public static boolean lexiconRotatingItems;
    public static boolean subtlePowerSystem;
    public static boolean staticWandBeam;
    public static boolean boundBlockWireframe;
    public static boolean lexicon3dModel;
    public static boolean oldPylonModel;
    public static double flowerParticleFrequency;
    public static boolean blockBreakParticles;
    public static boolean blockBreakParticlesTool;
    public static int spreaderPositionShift;
    public static int flowerQuantity;
    public static int flowerDensity;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        String desc = "Set to false to disable the use of shaders for some of the mod's renders.";
        useShaders = ConfigHandler.loadPropBool("shaders.enabled", desc, useShaders);
        desc = "Set to false to disable the rotating items in the petal and rune entries in the Lexica Botania.";
        lexiconRotatingItems = ConfigHandler.loadPropBool("lexicon.enable.rotatingItems", desc, lexiconRotatingItems);
        desc = "Set to true to set the power system's particles to be a lot more subtle. Good for low-end systems, if the particles are causing lag.";
        subtlePowerSystem = ConfigHandler.loadPropBool("powerSystem.subtle", desc, subtlePowerSystem);
        desc = "Set to true to use a static wand beam that shows every single position of the burst, similar to the way it used to work on old botania versions. Warning: Disabled by default because it may be laggy.";
        staticWandBeam = ConfigHandler.loadPropBool("wandBeam.static", desc, staticWandBeam);
        desc = "Set to false to disable the wireframe when looking a block bound to something (spreaders, flowers, etc).";
        boundBlockWireframe = ConfigHandler.loadPropBool("boundBlock.wireframe.enabled", desc, boundBlockWireframe);
        desc = "Set to false to disabled the animated 3D render for the lexica botania";
        lexicon3dModel = ConfigHandler.loadPropBool("lexicon.render.3D", desc, lexicon3dModel);
        desc = "Set to true to use the old (non-.obj, pre beta18) pylon model";
        oldPylonModel = ConfigHandler.loadPropBool("pylonModel.old", desc, oldPylonModel);
        desc = "The frequency in which particles spawn from normal (worldgen) mystical flowers";
        flowerParticleFrequency = ConfigHandler.loadPropDouble("flowerParticles.frequency", desc, flowerParticleFrequency);
        desc = "Set to false to remove the block breaking particles from the flowers and other items in the mod.";
        blockBreakParticles = ConfigHandler.loadPropBool("blockBreakingParticles.enabled", desc, blockBreakParticles);
        desc = "Set to false to remove the block breaking particles from the Mana Shatterer, as there can be a good amount in higher levels.";
        blockBreakParticlesTool = ConfigHandler.loadPropBool("blockBreakingParticlesTool.enabled", desc, blockBreakParticlesTool);
        desc = "Do not ever touch this value if not asked to. Possible symptoms of doing so include your head turning backwards, the appearance of Titans near the walls or you being trapped in a game of Sword Art Online.";
        spreaderPositionShift = ConfigHandler.loadPropInt("spreader.posShift", desc, spreaderPositionShift);
        flowerQuantity = ConfigHandler.loadPropInt("worldgen.flower.quantity", null, 3);
        flowerDensity = ConfigHandler.loadPropInt("worldgen.flower.density", null, 32);
        config.save();
    }

    public static int loadPropInt(String propName, String desc, int default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getInt(default_);
    }

    public static double loadPropDouble(String propName, String desc, double default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getDouble(default_);
    }

    public static boolean loadPropBool(String propName, String desc, boolean default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getBoolean(default_);
    }

    static {
        useShaders = true;
        lexiconRotatingItems = true;
        subtlePowerSystem = false;
        staticWandBeam = false;
        boundBlockWireframe = true;
        lexicon3dModel = true;
        oldPylonModel = false;
        flowerParticleFrequency = 0.75;
        blockBreakParticles = true;
        blockBreakParticlesTool = true;
        spreaderPositionShift = 1;
        flowerQuantity = 3;
        flowerDensity = 32;
    }
}

