/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.util.EnumHelper;
import vazkii.botania.api.internal.DummyMethodHandler;
import vazkii.botania.api.internal.DummySubTile;
import vazkii.botania.api.internal.IInternalMethodHandler;
import vazkii.botania.api.lexicon.LexiconCategory;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.api.subtile.SubTileEntity;

public final class BotaniaAPI {
    private static List<LexiconCategory> categories = new ArrayList<LexiconCategory>();
    private static List<LexiconEntry> allEntries = new ArrayList<LexiconEntry>();
    public static List<RecipePetals> petalRecipes = new ArrayList<RecipePetals>();
    public static List<RecipeRuneAltar> runeAltarRecipes = new ArrayList<RecipeRuneAltar>();
    public static List<RecipeManaInfusion> manaInfusionRecipes = new ArrayList<RecipeManaInfusion>();
    private static BiMap<String, Class<? extends SubTileEntity>> subTiles = HashBiMap.create();
    public static Set<String> subtilesForCreativeMenu = new LinkedHashSet<String>();
    public static Map<String, Integer> oreWeights = new HashMap<String, Integer>();
    public static Map<Item, Block> seeds = new HashMap<Item, Block>();
    public static ItemArmor.ArmorMaterial manasteelArmorMaterial = EnumHelper.addArmorMaterial((String)"MANASTEEL", (int)16, (int[])new int[]{2, 6, 5, 2}, (int)18);
    public static Item.ToolMaterial manasteelToolMaterial = EnumHelper.addToolMaterial((String)"MANASTEEL", (int)3, (int)300, (float)6.2f, (float)2.0f, (int)20);
    public static ItemArmor.ArmorMaterial terrasteelArmorMaterial = EnumHelper.addArmorMaterial((String)"TERRASTEEL", (int)34, (int[])new int[]{3, 8, 6, 3}, (int)26);
    public static Item.ToolMaterial terrasteelToolMaterial = EnumHelper.addToolMaterial((String)"TERRASTEEL", (int)3, (int)2300, (float)9.0f, (float)3.0f, (int)26);
    public static IInternalMethodHandler internalHandler;

    public static RecipePetals registerPetalRecipe(ItemStack output, Object ... inputs) {
        RecipePetals recipe = new RecipePetals(output, inputs);
        petalRecipes.add(recipe);
        return recipe;
    }

    public static RecipeRuneAltar registerRuneAltarRecipe(ItemStack output, int mana, Object ... inputs) {
        RecipeRuneAltar recipe = new RecipeRuneAltar(output, mana, inputs);
        runeAltarRecipes.add(recipe);
        return recipe;
    }

    public static RecipeManaInfusion registerManaInfusionRecipe(ItemStack output, Object input, int mana) {
        RecipeManaInfusion recipe = new RecipeManaInfusion(output, input, mana);
        manaInfusionRecipes.add(recipe);
        return recipe;
    }

    public static RecipeManaInfusion registerManaAlchemyRecipe(ItemStack output, Object input, int mana) {
        RecipeManaInfusion recipe = BotaniaAPI.registerManaInfusionRecipe(output, input, mana);
        recipe.setAlchemy(true);
        return recipe;
    }

    public static void registerSubTile(String key, Class<? extends SubTileEntity> subtileClass) {
        subTiles.put((Object)key, subtileClass);
    }

    public static void addSubTileToCreativeMenu(String key) {
        subtilesForCreativeMenu.add(key);
    }

    public static void addCategory(LexiconCategory category) {
        categories.add(category);
    }

    public static List<LexiconCategory> getAllCategories() {
        return categories;
    }

    public static void addEntry(LexiconEntry entry, LexiconCategory category) {
        allEntries.add(entry);
        category.entries.add(entry);
    }

    public static void addOreWeight(String ore, int weight) {
        oreWeights.put(ore, weight);
    }

    public static int getOreWeight(String ore) {
        return oreWeights.get(ore);
    }

    public static void addSeed(Item item, Block block) {
        seeds.put(item, block);
    }

    public static IRecipe getLatestAddedRecipe() {
        List list = CraftingManager.func_77594_a().func_77592_b();
        return (IRecipe)list.get(list.size() - 1);
    }

    public static List<IRecipe> getLatestAddedRecipes(int x) {
        List list = CraftingManager.func_77594_a().func_77592_b();
        ArrayList<IRecipe> newList = new ArrayList<IRecipe>();
        for (int i = x - 1; i >= 0; --i) {
            newList.add((IRecipe)list.get(list.size() - 1 - i));
        }
        return newList;
    }

    public static Class<? extends SubTileEntity> getSubTileMapping(String key) {
        if (!subTiles.containsKey((Object)key)) {
            key = "";
        }
        return (Class)subTiles.get((Object)key);
    }

    public static String getSubTileStringMapping(Class<? extends SubTileEntity> clazz) {
        return (String)subTiles.inverse().get(clazz);
    }

    static {
        BotaniaAPI.registerSubTile("", DummySubTile.class);
        BotaniaAPI.addOreWeight("oreAluminum", 3940);
        BotaniaAPI.addOreWeight("oreAmber", 2075);
        BotaniaAPI.addOreWeight("oreApatite", 1595);
        BotaniaAPI.addOreWeight("oreBlueTopaz", 3195);
        BotaniaAPI.addOreWeight("oreCassiterite", 1634);
        BotaniaAPI.addOreWeight("oreCertusQuartz", 3975);
        BotaniaAPI.addOreWeight("oreChimerite", 3970);
        BotaniaAPI.addOreWeight("oreCinnabar", 2585);
        BotaniaAPI.addOreWeight("oreCoal", 46525);
        BotaniaAPI.addOreWeight("oreCooperite", 5);
        BotaniaAPI.addOreWeight("oreCopper", 8325);
        BotaniaAPI.addOreWeight("oreDarkIron", 1700);
        BotaniaAPI.addOreWeight("oreDiamond", 1265);
        BotaniaAPI.addOreWeight("oreEmerald", 780);
        BotaniaAPI.addOreWeight("oreEmery", 415);
        BotaniaAPI.addOreWeight("oreGalena", 1000);
        BotaniaAPI.addOreWeight("oreGold", 2970);
        BotaniaAPI.addOreWeight("oreInfusedAir", 925);
        BotaniaAPI.addOreWeight("oreInfusedEarth", 925);
        BotaniaAPI.addOreWeight("oreInfusedEntropy", 925);
        BotaniaAPI.addOreWeight("oreInfusedFire", 925);
        BotaniaAPI.addOreWeight("oreInfusedOrder", 925);
        BotaniaAPI.addOreWeight("oreInfusedWater", 925);
        BotaniaAPI.addOreWeight("oreIridium", 30);
        BotaniaAPI.addOreWeight("oreIron", 20665);
        BotaniaAPI.addOreWeight("oreLapis", 1285);
        BotaniaAPI.addOreWeight("oreLead", 7985);
        BotaniaAPI.addOreWeight("oreMCropsEssence", 3085);
        BotaniaAPI.addOreWeight("oreNickel", 2275);
        BotaniaAPI.addOreWeight("oreOlivine", 1100);
        BotaniaAPI.addOreWeight("oreRedstone", 6885);
        BotaniaAPI.addOreWeight("oreRuby", 1100);
        BotaniaAPI.addOreWeight("oreSapphire", 1100);
        BotaniaAPI.addOreWeight("oreSilver", 6300);
        BotaniaAPI.addOreWeight("oreSphalerite", 25);
        BotaniaAPI.addOreWeight("oreSulfur", 1105);
        BotaniaAPI.addOreWeight("oreTetrahedrite", 4040);
        BotaniaAPI.addOreWeight("oreTin", 9450);
        BotaniaAPI.addOreWeight("oreTungstate", 20);
        BotaniaAPI.addOreWeight("oreUranium", 1337);
        BotaniaAPI.addOreWeight("oreVinteum", 5925);
        BotaniaAPI.addOreWeight("oreYellorite", 3520);
        BotaniaAPI.addSeed(Items.field_151014_N, Blocks.field_150464_aj);
        BotaniaAPI.addSeed(Items.field_151174_bG, Blocks.field_150469_bN);
        BotaniaAPI.addSeed(Items.field_151172_bF, Blocks.field_150459_bM);
        BotaniaAPI.addSeed(Items.field_151075_bm, Blocks.field_150388_bm);
        BotaniaAPI.addSeed(Items.field_151080_bb, Blocks.field_150393_bb);
        BotaniaAPI.addSeed(Items.field_151081_bc, Blocks.field_150394_bc);
        internalHandler = new DummyMethodHandler();
    }
}

