/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ItemMod;

public class ItemTerraformRod
extends ItemMod
implements IManaUsingItem {
    private static final int COST_PER = 55;
    static final List<Block> validBlocks = new ArrayList(){
        private static final long serialVersionUID = 1378413169035169782L;
        {
            this.add(Blocks.field_150348_b);
            this.add(Blocks.field_150346_d);
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150354_m);
            this.add(Blocks.field_150351_n);
            this.add(Blocks.field_150405_ch);
            this.add(Blocks.field_150431_aC);
            this.add(Blocks.field_150391_bh);
            this.add(Blocks.field_150322_A);
        }
    };

    public ItemTerraformRod() {
        this.func_77625_d(1);
        this.func_77655_b("terraformRod");
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count != this.func_77626_a(stack) && count % 10 == 0) {
            this.terraform(stack, player.field_70170_p, player);
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public void terraform(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int range = 16;
        int xCenter = (int)par3EntityPlayer.field_70165_t;
        int yCenter = (int)par3EntityPlayer.field_70163_u - (par2World.field_72995_K ? 2 : 1);
        int zCenter = (int)par3EntityPlayer.field_70161_v;
        int yStart = yCenter + range;
        ArrayList<CoordsWithBlock> blocks = new ArrayList<CoordsWithBlock>();
        for (int i = -range; i < range + 1; ++i) {
            block1: for (int j = -range; j < range + 1; ++j) {
                int k = 0;
                while (yStart + k >= 0) {
                    int x = xCenter + i;
                    int y = yStart + k;
                    int z = zCenter + j;
                    Block block = par2World.func_147439_a(x, y, z);
                    if (validBlocks.contains(block)) {
                        ForgeDirection[] dirs;
                        boolean hasAir = false;
                        ArrayList<ChunkCoordinates> airBlocks = new ArrayList<ChunkCoordinates>();
                        for (ForgeDirection dir : dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
                            int x_ = x + dir.offsetX;
                            int y_ = y + dir.offsetY;
                            int z_ = z + dir.offsetZ;
                            Block block_ = par2World.func_147439_a(x_, y_, z_);
                            if (!block_.isAir((IBlockAccess)par2World, x_, y_, z_) && !block_.isReplaceable((IBlockAccess)par2World, x_, y_, z_) && (!(block_ instanceof BlockFlower) || block_ instanceof ISpecialFlower) && block_ != Blocks.field_150398_cm) continue;
                            airBlocks.add(new ChunkCoordinates(x_, y_, z_));
                            hasAir = true;
                        }
                        if (!hasAir) continue block1;
                        if (y > yCenter) {
                            blocks.add(new CoordsWithBlock(x, y, z, Blocks.field_150350_a));
                            continue block1;
                        }
                        for (ChunkCoordinates coords : airBlocks) {
                            if (par2World.func_147439_a(coords.field_71574_a, coords.field_71572_b - 1, coords.field_71573_c) == Blocks.field_150350_a) continue;
                            blocks.add(new CoordsWithBlock(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Blocks.field_150346_d));
                        }
                        continue block1;
                    }
                    --k;
                }
            }
        }
        int cost = 55 * blocks.size();
        if (par2World.field_72995_K || ManaItemHandler.requestManaExact(par1ItemStack, par3EntityPlayer, cost, true)) {
            if (!par2World.field_72995_K) {
                for (CoordsWithBlock block : blocks) {
                    par2World.func_147449_b(block.field_71574_a, block.field_71572_b, block.field_71573_c, block.block);
                }
            }
            if (!blocks.isEmpty()) {
                int i;
                for (i = 0; i < 10; ++i) {
                    par2World.func_72956_a((Entity)par3EntityPlayer, "step.sand", 1.0f, 0.4f);
                }
                for (i = 0; i < 120; ++i) {
                    Botania.proxy.sparkleFX(par2World, (double)(xCenter - range) + (double)(range * 2) * Math.random(), (double)(yCenter + 2) + (Math.random() - 0.5) * 2.0, (double)(zCenter - range) + (double)(range * 2) * Math.random(), 0.35f, 0.2f, 0.05f, 2.0f, 5);
                }
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    class CoordsWithBlock
    extends ChunkCoordinates {
        final Block block;

        public CoordsWithBlock(int x, int y, int z, Block block) {
            super(x, y, z);
            this.block = block;
        }
    }
}

