/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;

public class TilePool
extends TileMod
implements IManaPool {
    public static final int MAX_MANA = 1000000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_KNOWN_MANA = "knownMana";
    private static final String TAG_OUTPUTTING = "outputting";
    boolean outputting = false;
    public boolean alchemy = false;
    int mana;
    int knownMana = -1;
    int craftCooldown = 20;
    boolean added = false;

    @Override
    public boolean isFull() {
        Block blockBelow = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return blockBelow != ModBlocks.manaVoid && this.getCurrentMana() >= 1000000;
    }

    @Override
    public void recieveMana(int mana) {
        boolean full = this.getCurrentMana() >= 1000000;
        this.mana = Math.min(this.getCurrentMana() + mana, 1000000);
        if (!full) {
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        ManaNetworkEvent.removePool(this);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        ManaNetworkEvent.removePool(this);
    }

    public boolean collideEntityItem(EntityItem item) {
        if (this.craftCooldown > 0) {
            return false;
        }
        boolean didChange = false;
        ItemStack stack = item.func_92059_d();
        if (stack == null) {
            return false;
        }
        for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
            if (!recipe.matches(stack) || recipe.isAlchemy() && !this.alchemy) continue;
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() < mana) break;
            this.recieveMana(-mana);
            if (!this.field_145850_b.field_72995_K) {
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    item.func_70106_y();
                }
                ItemStack output = recipe.getOutput().func_77946_l();
                EntityItem outputItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, output);
                outputItem.field_70292_b = 55;
                this.field_145850_b.func_72838_d((Entity)outputItem);
            }
            this.craftCooldown = 20;
            this.craftingFanciness();
            didChange = true;
            break;
        }
        return didChange;
    }

    public void craftingFanciness() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.levelup", 0.5f, 4.0f);
        for (int i = 0; i < 25; ++i) {
            float red = (float)Math.random();
            float green = (float)Math.random();
            float blue = (float)Math.random();
            Botania.proxy.sparkleFX(this.field_145850_b, (double)this.field_145851_c + 0.5 + Math.random() * 0.4 - 0.2, this.field_145848_d + 1, (double)this.field_145849_e + 0.5 + Math.random() * 0.4 - 0.2, red, green, blue, (float)Math.random(), 10);
        }
    }

    public void func_145845_h() {
        if (!this.added) {
            ManaNetworkEvent.addPool(this);
            this.added = true;
        }
        if (this.field_145850_b.field_72995_K) {
            double particleChance = 1.0 - (double)this.getCurrentMana() / 1000000.0 * 0.1;
            Color color = new Color(50943);
            if (Math.random() > particleChance) {
                Botania.proxy.wispFX(this.field_145850_b, (double)this.field_145851_c + 0.3 + Math.random() * 0.5, (double)this.field_145848_d + 0.6 + Math.random() * 0.25, (double)this.field_145849_e + Math.random(), (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random() / 3.0f, (float)(-Math.random()) / 25.0f);
            }
        }
        boolean bl = this.alchemy = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ModBlocks.alchemyCatalyst;
        if (this.craftCooldown > 0) {
            --this.craftCooldown;
        }
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)));
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (stack == null || !(stack.func_77973_b() instanceof IManaItem)) continue;
            IManaItem mana = (IManaItem)stack.func_77973_b();
            if ((!this.outputting || !mana.canReceiveManaFromPool(stack, this)) && (this.outputting || !mana.canExportManaToPool(stack, this))) continue;
            boolean didSomething = false;
            if (this.outputting) {
                if (this.getCurrentMana() > 0) {
                    didSomething = true;
                }
                if (!this.field_145850_b.field_72995_K) {
                    int manaVal = Math.min(1000, Math.min(this.getCurrentMana(), mana.getMaxMana(stack) - mana.getMana(stack)));
                    mana.addMana(stack, manaVal);
                    this.recieveMana(-manaVal);
                }
            } else {
                if (mana.getMana(stack) > 0) {
                    didSomething = true;
                }
                if (!this.field_145850_b.field_72995_K) {
                    int manaVal = Math.min(1000, Math.min(1000000 - this.getCurrentMana(), mana.getMana(stack)));
                    mana.addMana(stack, -manaVal);
                    this.recieveMana(manaVal);
                }
            }
            if (!didSomething) continue;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.field_145850_b.field_72995_K) continue;
            Color color = new Color(50943);
            Botania.proxy.wispFX(this.field_145850_b, item.field_70165_t + Math.random() * 0.5 - 0.25, item.field_70163_u + Math.random() * 0.5 - (this.outputting ? 0.65 : 0.25), item.field_70161_v + Math.random() * 0.5 - 0.25, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)Math.random() / 15.0f, (this.outputting ? -1.0f : 1.0f) * (float)Math.random() / 25.0f);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74757_a(TAG_OUTPUTTING, this.outputting);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.outputting = cmp.func_74767_n(TAG_OUTPUTTING);
        if (cmp.func_74764_b(TAG_KNOWN_MANA)) {
            this.knownMana = cmp.func_74762_e(TAG_KNOWN_MANA);
        }
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return;
        }
        if (player.func_70093_af()) {
            this.outputting = !this.outputting;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.writeCustomNBT(nbttagcompound);
            nbttagcompound.func_74768_a(TAG_KNOWN_MANA, this.getCurrentMana());
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound));
            }
        }
        this.field_145850_b.func_72956_a((Entity)player, "random.orb", 0.11f, 1.0f);
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        String name = StatCollector.func_74838_a((String)(new ItemStack(ModBlocks.pool, 1, this.func_145832_p()).func_77977_a().replaceAll("tile.", "tile.botania:") + ".name"));
        int color = 0x660000FF;
        HUDHandler.drawSimpleManaHUD(color, this.knownMana, 1000000, name, res);
        String power = StatCollector.func_74838_a((String)("botaniamisc." + (this.outputting ? "outputtingPower" : "inputtingPower")));
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(power) / 2;
        int y = res.func_78328_b() / 2 + 30;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        mc.field_71466_p.func_78261_a(power, x, y, color);
        GL11.glDisable((int)3042);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public int getCurrentMana() {
        return this.field_145850_b != null && this.func_145832_p() == 1 ? 1000000 : this.mana;
    }
}

