/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.common.core.helper.MathHelper;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    public WeakHashMap<World, List<TileEntity>> manaPools = new WeakHashMap();
    public WeakHashMap<World, List<TileEntity>> manaCollectors = new WeakHashMap();

    @SubscribeEvent
    public void onNetworkEvent(ManaNetworkEvent event) {
        WeakHashMap<World, List<TileEntity>> map;
        WeakHashMap<World, List<TileEntity>> weakHashMap = map = event.type == ManaNetworkEvent.ManaBlockType.COLLECTOR ? this.manaCollectors : this.manaPools;
        if (event.action == ManaNetworkEvent.Action.ADD) {
            this.add(map, event.tile);
        } else {
            this.remove(map, event.tile);
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public TileEntity getClosestPool(ChunkCoordinates pos, World world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public TileEntity getClosestCollector(ChunkCoordinates pos, World world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    private synchronized TileEntity getClosest(List<TileEntity> tiles, ChunkCoordinates pos, int limit) {
        float closest = Float.MAX_VALUE;
        TileEntity closestTile = null;
        for (TileEntity tile : tiles) {
            float distance = MathHelper.pointDistanceSpace(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
            if (distance > (float)limit || !(distance < closest)) continue;
            closest = distance;
            closestTile = tile;
        }
        return closestTile;
    }

    private synchronized void remove(Map<World, List<TileEntity>> map, TileEntity tile) {
        World world = tile.func_145831_w();
        if (!map.containsKey(world)) {
            return;
        }
        List<TileEntity> tiles = map.get(world);
        tiles.remove(tile);
    }

    private synchronized void add(Map<World, List<TileEntity>> map, TileEntity tile) {
        List<TileEntity> tiles;
        World world = tile.func_145831_w();
        if (!map.containsKey(world)) {
            map.put(world, new ArrayList());
        }
        if (!(tiles = map.get(world)).contains(tile)) {
            tiles.add(tile);
        }
    }

    @Override
    public List<TileEntity> getAllCollectorsInWorld(World world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public List<TileEntity> getAllPoolsInWorld(World world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    private List<TileEntity> getAllInWorld(Map<World, List<TileEntity>> map, World world) {
        if (!map.containsKey(world)) {
            return new ArrayList<TileEntity>();
        }
        return map.get(world);
    }
}

