/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import vazkii.botania.common.block.ModBlocks;

public class MassiveAssTree
extends WorldGenerator {
    public void generateTrunk(World world, Random rand, int x, int y, int z, int radius, int height) {
        for (int i = x - radius; i < x + radius; ++i) {
            for (int j = y; j <= y + height && y < 256; ++j) {
                for (int k = z - radius; k < z + radius; ++k) {
                    int y1 = height - (j - y) - rand.nextInt(radius / 2);
                    if ((i - x) * (i - x) + (k - z) * (k - z) > radius * radius + y1) continue;
                    world.func_147449_b(i, j, k, ModBlocks.livingwood);
                }
            }
        }
    }

    public void generateCanopy(World world, Random rand, int x, int y, int z, int radius, int height) {
        float uDiv = radius * radius / (height / 2);
        float lDiv = radius * radius / (height / 2);
        for (int i = x - radius; i < x + radius; ++i) {
            for (float k = (float)(z - radius); k < (float)(z + radius); k += 1.0f) {
                for (float j = (float)(y + height); j >= 0.0f && j < 256.0f; j -= 1.0f) {
                    float bx = i - x;
                    float by = j - (float)y;
                    float bz = k - (float)z;
                    if (!this.inCanopy(bx, by, bz, radius, height, lDiv, uDiv)) continue;
                    world.func_147465_d(i, (int)j, (int)k, (Block)Blocks.field_150362_t, 3, 3);
                }
            }
        }
    }

    public boolean inCanopy(float x, float y, float z, float r, float h, float d, float uD) {
        return y <= this.upperCanopyY(x, y, z, r, h, uD) && y >= this.lowerCanopyY(x, y, z, r, h, d);
    }

    public float lowerCanopyY(float x, float y, float z, float r, float h, float div) {
        return (x * x + z * z) / div;
    }

    public float upperCanopyY(float x, float y, float z, float r, float h, float div) {
        return h - (x * x + z * z) / div;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        float scale = rand.nextFloat() * 0.5f + 1.0f;
        int height = (int)((float)(30 + rand.nextInt(10)) * scale);
        this.generateTrunk(world, rand, x, y, z, (int)(3.0f * scale), height);
        this.generateCanopy(world, rand, x, y + height, z, 30 + rand.nextInt(15), 10 + rand.nextInt(5));
        return true;
    }
}

