/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import baubles.common.lib.PlayerHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;

public class EntitySpark
extends Entity
implements ISparkEntity {
    private static final int TRANSFER_RATE = 1000;
    private static final String TAG_UPGRADE = "upgrade";
    int removeTransferants = 2;

    public EntitySpark(World world) {
        super(world);
    }

    protected void func_70088_a() {
        this.func_70105_a(0.5f, 0.5f);
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(29, (Object)"");
        this.field_70180_af.func_82708_h(28);
        this.field_70180_af.func_82708_h(29);
    }

    public void func_70071_h_() {
        int manaTotal;
        int manaForEach;
        super.func_70071_h_();
        ISparkAttachable tile = this.getAttachedTile();
        if (tile == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        Collection<ISparkEntity> transfers = this.getTransfers();
        int upgrade = this.getUpgrade();
        if (upgrade != 0) {
            List<ISparkEntity> sparks = SparkHelper.getSparksAround(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            switch (upgrade) {
                case 1: {
                    EntityPlayer player2;
                    List<EntityPlayer> players = SparkHelper.getEntitiesAround(EntityPlayer.class, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    HashMap receivingPlayers = new HashMap();
                    ItemStack input = new ItemStack(ModItems.spark);
                    for (EntityPlayer player2 : players) {
                        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                        stacks.addAll(Arrays.asList(player2.field_71071_by.field_70462_a));
                        stacks.addAll(Arrays.asList(player2.field_71071_by.field_70460_b));
                        stacks.addAll(Arrays.asList(PlayerHandler.getPlayerBaubles((EntityPlayer)player2).stackList));
                        for (ItemStack stack : stacks) {
                            int recv;
                            HashMap<ItemStack, Integer> receivingStacks;
                            IManaItem manaItem;
                            if (stack == null || !(stack.func_77973_b() instanceof IManaItem) || !(manaItem = (IManaItem)stack.func_77973_b()).canReceiveManaFromItem(stack, input)) continue;
                            boolean add = false;
                            if (!receivingPlayers.containsKey(player2)) {
                                add = true;
                                receivingStacks = new HashMap<ItemStack, Integer>();
                            } else {
                                receivingStacks = (HashMap<ItemStack, Integer>)receivingPlayers.get(player2);
                            }
                            if ((recv = Math.min(this.getAttachedTile().getCurrentMana(), Math.min(1000, manaItem.getMaxMana(stack) - manaItem.getMana(stack)))) <= 0) continue;
                            receivingStacks.put(stack, recv);
                            if (!add) continue;
                            receivingPlayers.put(player2, receivingStacks);
                        }
                    }
                    if (receivingPlayers.isEmpty()) break;
                    ArrayList keys = new ArrayList(receivingPlayers.keySet());
                    Collections.shuffle(keys);
                    player2 = (EntityPlayer)keys.iterator().next();
                    Map items = (Map)receivingPlayers.get(player2);
                    ItemStack stack = (ItemStack)items.keySet().iterator().next();
                    int cost = (Integer)items.get(stack);
                    int manaToPut = Math.min(this.getAttachedTile().getCurrentMana(), cost);
                    ((IManaItem)stack.func_77973_b()).addMana(stack, manaToPut);
                    this.getAttachedTile().recieveMana(-manaToPut);
                    this.particlesTowards((Entity)player2);
                    break;
                }
                case 2: {
                    for (ISparkEntity spark : sparks) {
                        int upgrade_;
                        if (spark == this || (upgrade_ = spark.getUpgrade()) != 0) continue;
                        spark.registerTransfer(this);
                    }
                    break;
                }
                case 3: {
                    for (ISparkEntity spark : sparks) {
                        int upgrade_;
                        if (spark == this || (upgrade_ = spark.getUpgrade()) == 2 || upgrade_ == 3 || upgrade_ == 4) continue;
                        transfers.add(spark);
                    }
                    break;
                }
            }
        }
        if (!transfers.isEmpty() && (manaForEach = (manaTotal = Math.min(1000 * transfers.size(), tile.getCurrentMana())) / transfers.size()) > transfers.size()) {
            for (ISparkEntity spark : transfers) {
                if (spark.getAttachedTile() == null || spark.getAttachedTile().isFull() || spark.areIncomingTransfersDone()) {
                    manaTotal -= manaForEach;
                    continue;
                }
                ISparkAttachable attached = spark.getAttachedTile();
                attached.recieveMana(manaForEach);
                this.particlesTowards((Entity)spark);
            }
            tile.recieveMana(-manaTotal);
        }
        if (this.removeTransferants > 0) {
            --this.removeTransferants;
        }
    }

    void particlesTowards(Entity e) {
        Vector3 thisVec = Vector3.fromEntityCenter(this).add(0.0, 0.0, 0.0);
        Vector3 receiverVec = Vector3.fromEntityCenter(e).add(0.0, 0.0, 0.0);
        double rc = 0.45;
        thisVec.add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
        receiverVec.add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
        Vector3 motion = receiverVec.copy().sub(thisVec);
        motion.multiply(0.04f);
        float r = 0.5f + 0.4f * (float)Math.random();
        float g = 0.5f + 0.4f * (float)Math.random();
        float b = 0.5f + 0.4f * (float)Math.random();
        float size = 0.125f + 0.125f * (float)Math.random();
        Botania.proxy.wispFX(this.field_70170_p, thisVec.x, thisVec.y, thisVec.z, r, g, b, size, (float)motion.x, (float)motion.y, (float)motion.z);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_130002_c(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        if (stack != null) {
            int upgrade = this.getUpgrade();
            if (stack.func_77973_b() == ModItems.twigWand) {
                if (upgrade > 0) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_70099_a(new ItemStack(ModItems.sparkUpgrade, 1, upgrade - 1), 0.0f);
                    }
                    this.setUpgrade(0);
                    this.field_70180_af.func_75692_b(29, (Object)"");
                    this.removeTransferants = 2;
                } else {
                    this.func_70106_y();
                }
                if (player.field_70170_p.field_72995_K) {
                    player.func_71038_i();
                }
                return true;
            }
            if (stack.func_77973_b() == ModItems.sparkUpgrade && upgrade == 0) {
                int newUpgrade = stack.func_77960_j() + 1;
                this.setUpgrade(newUpgrade);
                --stack.field_77994_a;
                if (player.field_70170_p.field_72995_K) {
                    player.func_71038_i();
                }
                return true;
            }
        }
        return false;
    }

    protected void func_70037_a(NBTTagCompound cmp) {
        this.setUpgrade(cmp.func_74762_e(TAG_UPGRADE));
    }

    protected void func_70014_b(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_UPGRADE, this.getUpgrade());
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            int upgrade = this.getUpgrade();
            this.func_70099_a(new ItemStack(ModItems.spark), 0.0f);
            if (upgrade > 0) {
                this.func_70099_a(new ItemStack(ModItems.sparkUpgrade, 1, upgrade - 1), 0.0f);
            }
        }
    }

    @Override
    public ISparkAttachable getAttachedTile() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        TileEntity tile = this.field_70170_p.func_147438_o(x, y = MathHelper.func_76128_c((double)this.field_70163_u) - 1, z = MathHelper.func_76128_c((double)this.field_70161_v));
        if (tile != null && tile instanceof ISparkAttachable) {
            return (ISparkAttachable)tile;
        }
        return null;
    }

    @Override
    public Collection<ISparkEntity> getTransfers() {
        ArrayList<ISparkEntity> entities = new ArrayList<ISparkEntity>();
        String transfers = this.field_70180_af.func_75681_e(29);
        String[] tokens = transfers.split(";");
        ArrayList<String> removals = new ArrayList<String>();
        for (String s : tokens) {
            ISparkEntity spark;
            if (s.isEmpty()) continue;
            int id = Integer.parseInt(s);
            boolean added = false;
            Entity e = this.field_70170_p.func_73045_a(id);
            if (e != null && e instanceof ISparkEntity && (spark = (ISparkEntity)e) != this && !spark.areIncomingTransfersDone() && spark.getAttachedTile() != null && !spark.getAttachedTile().isFull() && (this.getUpgrade() == 0 && spark.getUpgrade() == 2 || this.getUpgrade() == 3 && (spark.getUpgrade() == 0 || spark.getUpgrade() == 1) || !(spark.getAttachedTile() instanceof IManaPool))) {
                entities.add((ISparkEntity)e);
                added = true;
            }
            if (added) continue;
            removals.add(s);
        }
        if (!removals.isEmpty()) {
            String newTranfers = "";
            for (String s : tokens) {
                if (removals.contains(s)) continue;
                newTranfers = newTranfers + (newTranfers.isEmpty() ? "" : ";") + s;
            }
            this.field_70180_af.func_75692_b(29, (Object)newTranfers);
            removals.clear();
        }
        return entities;
    }

    @Override
    public void registerTransfer(ISparkEntity entity) {
        if (this.field_70170_p.field_72995_K || this.getTransfers().contains(entity)) {
            return;
        }
        String transfers = this.field_70180_af.func_75681_e(29);
        this.field_70180_af.func_75692_b(29, (Object)(transfers + (transfers.isEmpty() ? "" : ";") + ((Entity)entity).func_145782_y()));
    }

    @Override
    public int getUpgrade() {
        return this.field_70180_af.func_75679_c(28);
    }

    @Override
    public void setUpgrade(int upgrade) {
        this.field_70180_af.func_75692_b(28, (Object)upgrade);
    }

    @Override
    public boolean areIncomingTransfersDone() {
        ISparkAttachable tile = this.getAttachedTile();
        if (tile instanceof IManaPool) {
            return this.removeTransferants > 0;
        }
        return tile != null && tile.areIncomingTranfersDone();
    }
}

