/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import vazkii.botania.common.core.handler.SheddingHandler;

public final class ConfigHandler {
    public static Configuration config;
    public static boolean useShaders;
    public static boolean lexiconRotatingItems;
    public static boolean subtlePowerSystem;
    public static boolean staticWandBeam;
    public static boolean boundBlockWireframe;
    public static boolean lexicon3dModel;
    public static boolean oldPylonModel;
    public static double flowerParticleFrequency;
    public static boolean blockBreakParticles;
    public static boolean blockBreakParticlesTool;
    public static boolean elfPortalParticlesEnabled;
    public static boolean chargingAnimationEnabled;
    public static boolean useVanillaParticleLimiter;
    public static boolean altFlowerTextures;
    public static boolean matrixMode;
    public static boolean referencesEnabled;
    public static boolean versionCheckEnabled;
    public static int spreaderPositionShift;
    public static boolean flowerForceCheck;
    public static boolean enderPickpocketEnabled;
    public static boolean thermalilyObsidian;
    public static int hardcorePassiveGeneration;
    public static boolean fallenKanadeEnabled;
    public static boolean darkQuartzEnabled;
    public static boolean enchanterEnabled;
    public static int flowerQuantity;
    public static int flowerDensity;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.load();
        FMLCommonHandler.instance().bus().register((Object)new ChangeListener());
    }

    public static void load() {
        String desc = "Set to false to disable the use of shaders for some of the mod's renders.";
        useShaders = ConfigHandler.loadPropBool("shaders.enabled", desc, useShaders);
        desc = "Set to false to disable the rotating items in the petal and rune entries in the Lexica Botania.";
        lexiconRotatingItems = ConfigHandler.loadPropBool("lexicon.enable.rotatingItems", desc, lexiconRotatingItems);
        desc = "Set to true to set the power system's particles to be a lot more subtle. Good for low-end systems, if the particles are causing lag.";
        subtlePowerSystem = ConfigHandler.loadPropBool("powerSystem.subtle", desc, subtlePowerSystem);
        desc = "Set to true to use a static wand beam that shows every single position of the burst, similar to the way it used to work on old botania versions. Warning: Disabled by default because it may be laggy.";
        staticWandBeam = ConfigHandler.loadPropBool("wandBeam.static", desc, staticWandBeam);
        desc = "Set to false to disable the wireframe when looking a block bound to something (spreaders, flowers, etc).";
        boundBlockWireframe = ConfigHandler.loadPropBool("boundBlock.wireframe.enabled", desc, boundBlockWireframe);
        desc = "Set to false to disabled the animated 3D render for the lexica botania";
        lexicon3dModel = ConfigHandler.loadPropBool("lexicon.render.3D", desc, lexicon3dModel);
        desc = "Set to true to use the old (non-.obj, pre beta18) pylon model";
        oldPylonModel = ConfigHandler.loadPropBool("pylonModel.old", desc, oldPylonModel);
        desc = "The frequency in which particles spawn from normal (worldgen) mystical flowers";
        flowerParticleFrequency = ConfigHandler.loadPropDouble("flowerParticles.frequency", desc, flowerParticleFrequency);
        desc = "Set to false to remove the block breaking particles from the flowers and other items in the mod.";
        blockBreakParticles = ConfigHandler.loadPropBool("blockBreakingParticles.enabled", desc, blockBreakParticles);
        desc = "Set to false to remove the block breaking particles from the Mana Shatterer, as there can be a good amount in higher levels.";
        blockBreakParticlesTool = ConfigHandler.loadPropBool("blockBreakingParticlesTool.enabled", desc, blockBreakParticlesTool);
        desc = "Set to false to disable the particles in the elven portal.";
        elfPortalParticlesEnabled = ConfigHandler.loadPropBool("elfPortal.particles.enabled", desc, elfPortalParticlesEnabled);
        desc = "Set to false to disable the animation when an item is charging on top of a mana pool.";
        chargingAnimationEnabled = ConfigHandler.loadPropBool("chargeAnimation.enabled", desc, chargingAnimationEnabled);
        desc = "Set to false to always display all particles regardless of the \"Particles\" setting in the Vanilla options menu.";
        useVanillaParticleLimiter = ConfigHandler.loadPropBool("vanillaParticleConfig.enabled", desc, useVanillaParticleLimiter);
        desc = "Set to true to use alternate flower textures by Futureazoo, not all flowers are textured. http://redd.it/2b3o3f";
        altFlowerTextures = ConfigHandler.loadPropBool("flowerTextures.alt", desc, altFlowerTextures);
        desc = "Set to true if you are the chosen one. For lovers of glitch art and just general mad people.";
        matrixMode = ConfigHandler.loadPropBool("matrixMode.enabled", desc, matrixMode);
        desc = "Set to false to disable the references in flower tooltips. (You monster D:)";
        referencesEnabled = ConfigHandler.loadPropBool("references.enabled", desc, referencesEnabled);
        desc = "Set to false to disable checking and alerting when new Botania versions come out.";
        versionCheckEnabled = ConfigHandler.loadPropBool("versionChecking.enabled", desc, versionCheckEnabled);
        desc = "Do not ever touch this value if not asked to. Possible symptoms of doing so include your head turning backwards, the appearance of Titans near the walls or you being trapped in a game of Sword Art Online.";
        spreaderPositionShift = ConfigHandler.loadPropInt("spreader.posShift", desc, spreaderPositionShift);
        desc = "Turn off ONLY IF you're on an extremely large world with an exhagerated count of Mana Spreaders/Mana Pools and are experiencing TPS lag. This toggles whether flowers are strict with their checking for connecting to pools/spreaders or just check whenever possible.";
        flowerForceCheck = ConfigHandler.loadPropBool("flower.forceCheck", desc, flowerForceCheck);
        desc = "Set to false to disable the ability for the Hand of Ender to pickpocket other players' ender chests.";
        enderPickpocketEnabled = ConfigHandler.loadPropBool("enderPickpocket.enabled", desc, enderPickpocketEnabled);
        desc = "Set to true to only allow the Thermalily to absorb Lava if there's Obsidian below it. Another config option for the Blood Magic balance freaks.";
        thermalilyObsidian = ConfigHandler.loadPropBool("thermalily.obsidian", desc, thermalilyObsidian);
        desc = "Set to anything other than -1 for passive generation flowers (dayblooms, nightshades, hydroangeas) to die after a specific amount of ticks. 24000 is 2 minecraft days, that's a recomended value.";
        hardcorePassiveGeneration = ConfigHandler.loadPropInt("passiveWither.time", desc, hardcorePassiveGeneration);
        desc = "Set to false to disable the Fallen Kanade flower (gives Regeneration). This config option is here for those using Blood Magic. Note: Turning this off will not remove ones already in the world, it'll simply prevent the crafting.";
        fallenKanadeEnabled = ConfigHandler.loadPropBool("fallenKanade.enabled", desc, fallenKanadeEnabled);
        desc = "Set to false to disable the Smokey Quartz blocks. This config option is here for those using Thaumic Tinkerer";
        darkQuartzEnabled = ConfigHandler.loadPropBool("darkQuartz.enabled", desc, darkQuartzEnabled);
        desc = "Set to false to disable the Mana Enchanter. Since some people find it OP or something. This only disables the entry and creation. Old ones that are already in the world will stay.";
        enchanterEnabled = ConfigHandler.loadPropBool("manaEnchanter.enabled", desc, enchanterEnabled);
        desc = "The quanity of flower patches to generate in the world, defaults to 3, the lower the number the less patches geenrate.";
        flowerQuantity = ConfigHandler.loadPropInt("worldgen.flower.quantity", desc, 3);
        desc = "The density of each flower patch generataed, defaults to 32, the lower the number, the less each patch will have.";
        flowerDensity = ConfigHandler.loadPropInt("worldgen.flower.density", desc, 32);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void loadPostInit() {
        SheddingHandler.loadFromConfig(config);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadPropInt(String propName, String desc, int default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getInt(default_);
    }

    public static double loadPropDouble(String propName, String desc, double default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getDouble(default_);
    }

    public static boolean loadPropBool(String propName, String desc, boolean default_) {
        Property prop = config.get("general", propName, default_);
        prop.comment = desc;
        return prop.getBoolean(default_);
    }

    static {
        useShaders = true;
        lexiconRotatingItems = true;
        subtlePowerSystem = false;
        staticWandBeam = false;
        boundBlockWireframe = true;
        lexicon3dModel = true;
        oldPylonModel = false;
        flowerParticleFrequency = 0.75;
        blockBreakParticles = true;
        blockBreakParticlesTool = true;
        elfPortalParticlesEnabled = true;
        chargingAnimationEnabled = true;
        useVanillaParticleLimiter = true;
        altFlowerTextures = false;
        matrixMode = false;
        referencesEnabled = true;
        versionCheckEnabled = true;
        spreaderPositionShift = 1;
        flowerForceCheck = true;
        enderPickpocketEnabled = true;
        thermalilyObsidian = false;
        hardcorePassiveGeneration = -1;
        fallenKanadeEnabled = true;
        darkQuartzEnabled = true;
        enchanterEnabled = true;
        flowerQuantity = 2;
        flowerDensity = 16;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.modID.equals("Botania")) {
                ConfigHandler.load();
            }
        }
    }
}

