/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.lexicon;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.IAddonEntry;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.gui.lexicon.GuiLexicon;
import vazkii.botania.client.gui.lexicon.IParented;
import vazkii.botania.client.gui.lexicon.button.GuiButtonBackWithShift;
import vazkii.botania.client.gui.lexicon.button.GuiButtonPage;

public class GuiLexiconEntry
extends GuiLexicon
implements IGuiLexiconEntry,
IParented {
    public int page = 0;
    LexiconEntry entry;
    GuiScreen parent;
    String title;
    String subtitle;
    GuiButton leftButton;
    GuiButton rightButton;
    GuiButton backButton;
    int fx = 0;
    boolean swiped = false;

    public GuiLexiconEntry(LexiconEntry entry, GuiScreen parent) {
        this.entry = entry;
        this.parent = parent;
        this.title = StatCollector.func_74838_a((String)entry.getUnlocalizedName());
        this.subtitle = entry instanceof IAddonEntry ? StatCollector.func_74838_a((String)((IAddonEntry)((Object)entry)).getSubtitle()) : null;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.backButton = new GuiButtonBackWithShift(0, this.left + this.guiWidth / 2 - 8, this.top + this.guiHeight + 2);
        this.field_146292_n.add(this.backButton);
        this.leftButton = new GuiButtonPage(1, this.left, this.top + this.guiHeight - 10, false);
        this.field_146292_n.add(this.leftButton);
        this.rightButton = new GuiButtonPage(2, this.left + this.guiWidth - 18, this.top + this.guiHeight - 10, true);
        this.field_146292_n.add(this.rightButton);
        this.updatePageButtons();
    }

    @Override
    public LexiconEntry getEntry() {
        return this.entry;
    }

    @Override
    public int getPageOn() {
        return this.page;
    }

    @Override
    boolean isIndex() {
        return false;
    }

    @Override
    void drawHeader() {
    }

    @Override
    String getTitle() {
        return String.format("%s " + EnumChatFormatting.ITALIC + "(%s/%s)", this.title, this.page + 1, this.entry.pages.size());
    }

    @Override
    String getSubtitle() {
        return this.subtitle;
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146127_k >= 1337) {
            this.handleBookmark(par1GuiButton);
        } else {
            switch (par1GuiButton.field_146127_k) {
                case 0: {
                    this.field_146297_k.func_147108_a((GuiScreen)(GuiScreen.func_146272_n() ? new GuiLexicon() : this.parent));
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                case 1: {
                    --this.page;
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                case 2: {
                    ++this.page;
                    ClientTickHandler.notifyPageChange();
                }
            }
        }
        this.updatePageButtons();
    }

    public void updatePageButtons() {
        this.leftButton.field_146124_l = this.page != 0;
        this.rightButton.field_146124_l = this.page + 1 < this.entry.pages.size();
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        LexiconPage page = this.entry.pages.get(this.page);
        page.renderScreen(this, par1, par2);
    }

    public void func_73876_c() {
        LexiconPage page = this.entry.pages.get(this.page);
        page.updateScreen();
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public int getWidth() {
        return this.guiWidth;
    }

    @Override
    public int getHeight() {
        return this.guiHeight;
    }

    @Override
    public float getZLevel() {
        return this.field_73735_i;
    }

    @Override
    public void setParent(GuiLexicon gui) {
        this.parent = gui;
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        if (button == 0 && Math.abs(x - this.fx) > 100 && this.field_146297_k.field_71474_y.field_85185_A && !this.swiped) {
            double swipe = (double)(x - this.fx) / Math.max(1.0, (double)time);
            if (swipe < 0.5) {
                this.nextPage();
                this.swiped = true;
            } else if (swipe > 0.5) {
                this.prevPage();
                this.swiped = true;
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.fx = par1;
        if (par3 == 1) {
            this.back();
        }
    }

    public void func_146274_d() {
        int w;
        super.func_146274_d();
        if (Mouse.getEventButton() == 0) {
            this.swiped = false;
        }
        if ((w = Mouse.getEventDWheel()) < 0) {
            this.nextPage();
        } else if (w > 0) {
            this.prevPage();
        }
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        LexiconPage page = this.entry.pages.get(this.page);
        page.onKeyPressed(par1, par2);
        if (par2 == 203 || par2 == 200 || par2 == 201) {
            this.prevPage();
        } else if (par2 == 205 || par2 == 208 || par2 == 209) {
            this.nextPage();
        } else if (par2 == 14) {
            this.back();
        } else if (par2 == 199) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLexicon());
            ClientTickHandler.notifyPageChange();
        }
        super.func_73869_a(par1, par2);
    }

    void back() {
        if (this.backButton.field_146124_l) {
            this.func_146284_a(this.backButton);
            this.backButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }

    void nextPage() {
        if (this.rightButton.field_146124_l) {
            this.func_146284_a(this.rightButton);
            this.rightButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }

    void prevPage() {
        if (this.leftButton.field_146124_l) {
            this.func_146284_a(this.leftButton);
            this.leftButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }
}

