/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Desktop;
import java.net.URI;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import vazkii.botania.api.item.IExtendedPlayerController;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.wiki.IWikiProvider;
import vazkii.botania.api.wiki.WikiHooks;
import vazkii.botania.client.core.handler.BotaniaPlayerController;
import vazkii.botania.client.core.handler.BoundTileRenderer;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.handler.LightningHandler;
import vazkii.botania.client.core.handler.TiaraWingRenderHandler;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.FXSparkle;
import vazkii.botania.client.fx.FXWisp;
import vazkii.botania.client.gui.lexicon.GuiLexicon;
import vazkii.botania.client.gui.lexicon.GuiLexiconEntry;
import vazkii.botania.client.gui.lexicon.GuiLexiconIndex;
import vazkii.botania.client.lib.LibRenderIDs;
import vazkii.botania.client.render.block.RenderAltar;
import vazkii.botania.client.render.block.RenderMiniIsland;
import vazkii.botania.client.render.block.RenderPool;
import vazkii.botania.client.render.block.RenderPylon;
import vazkii.botania.client.render.block.RenderSpawnerClaw;
import vazkii.botania.client.render.block.RenderSpecialFlower;
import vazkii.botania.client.render.block.RenderSpreader;
import vazkii.botania.client.render.block.RenderTinyPotato;
import vazkii.botania.client.render.entity.RenderDoppleganger;
import vazkii.botania.client.render.entity.RenderPixie;
import vazkii.botania.client.render.entity.RenderSpark;
import vazkii.botania.client.render.item.RenderLens;
import vazkii.botania.client.render.item.RenderLexicon;
import vazkii.botania.client.render.item.RenderTransparentItem;
import vazkii.botania.client.render.tile.RenderTileAlfPortal;
import vazkii.botania.client.render.tile.RenderTileAltar;
import vazkii.botania.client.render.tile.RenderTileEnchanter;
import vazkii.botania.client.render.tile.RenderTileMiniIsland;
import vazkii.botania.client.render.tile.RenderTilePool;
import vazkii.botania.client.render.tile.RenderTilePylon;
import vazkii.botania.client.render.tile.RenderTileRuneAltar;
import vazkii.botania.client.render.tile.RenderTileSkullOverride;
import vazkii.botania.client.render.tile.RenderTileSpawnerClaw;
import vazkii.botania.client.render.tile.RenderTileSpreader;
import vazkii.botania.client.render.tile.RenderTileStarfield;
import vazkii.botania.client.render.tile.RenderTileTinyPotato;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.TileMiniIsland;
import vazkii.botania.common.block.tile.TilePylon;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.TileSpawnerClaw;
import vazkii.botania.common.block.tile.TileStarfield;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.core.proxy.CommonProxy;
import vazkii.botania.common.core.version.VersionChecker;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.entity.EntityVineBall;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibObfuscation;

public class ClientProxy
extends CommonProxy {
    private static boolean noclipEnabled = false;
    private static boolean distanceLimit = true;
    private static boolean depthTest = true;

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        FMLCommonHandler.instance().bus().register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HUDHandler());
        MinecraftForge.EVENT_BUS.register((Object)new LightningHandler());
        if (ConfigHandler.boundBlockWireframe) {
            MinecraftForge.EVENT_BUS.register((Object)new BoundTileRenderer());
        }
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TiaraWingRenderHandler());
        if (ConfigHandler.versionCheckEnabled) {
            new VersionChecker().init();
        }
        this.initRenderers();
    }

    private void initRenderers() {
        LibRenderIDs.idAltar = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idSpecialFlower = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idSpreader = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idPool = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idPylon = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idMiniIsland = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idTinyPotato = RenderingRegistry.getNextAvailableRenderId();
        LibRenderIDs.idSpawnerClaw = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderAltar());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderSpecialFlower(LibRenderIDs.idSpecialFlower));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderSpreader());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderPool());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderPylon());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderMiniIsland());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderTinyPotato());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderSpawnerClaw());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.lens, (IItemRenderer)new RenderLens());
        if (ConfigHandler.lexicon3dModel) {
            MinecraftForgeClient.registerItemRenderer((Item)ModItems.lexicon, (IItemRenderer)new RenderLexicon());
        }
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.glassPick, (IItemRenderer)new RenderTransparentItem());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.spark, (IItemRenderer)new RenderTransparentItem());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAltar.class, (TileEntitySpecialRenderer)new RenderTileAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSpreader.class, (TileEntitySpecialRenderer)new RenderTileSpreader());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePool.class, (TileEntitySpecialRenderer)new RenderTilePool());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRuneAltar.class, (TileEntitySpecialRenderer)new RenderTileRuneAltar());
        ClientRegistry.bindTileEntitySpecialRenderer(TilePylon.class, (TileEntitySpecialRenderer)new RenderTilePylon());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnchanter.class, (TileEntitySpecialRenderer)new RenderTileEnchanter());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAlfPortal.class, (TileEntitySpecialRenderer)new RenderTileAlfPortal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMiniIsland.class, (TileEntitySpecialRenderer)new RenderTileMiniIsland());
        ClientRegistry.bindTileEntitySpecialRenderer(TileTinyPotato.class, (TileEntitySpecialRenderer)new RenderTileTinyPotato());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSpawnerClaw.class, (TileEntitySpecialRenderer)new RenderTileSpawnerClaw());
        ClientRegistry.bindTileEntitySpecialRenderer(TileStarfield.class, (TileEntitySpecialRenderer)new RenderTileStarfield());
        if (Loader.instance().getMCVersionString().equals("Minecraft 1.7.10")) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySkull.class, (TileEntitySpecialRenderer)new RenderTileSkullOverride());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityPixie.class, (Render)new RenderPixie());
        RenderingRegistry.registerEntityRenderingHandler(EntityVineBall.class, (Render)new RenderSnowball(ModItems.vineBall));
        RenderingRegistry.registerEntityRenderingHandler(EntityDoppleganger.class, (Render)new RenderDoppleganger());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpark.class, (Render)new RenderSpark());
        ShaderHelper.initShaders();
    }

    @Override
    public void setEntryToOpen(LexiconEntry entry) {
        GuiLexicon.currentOpenLexicon = new GuiLexiconEntry(entry, new GuiLexiconIndex(entry.category));
    }

    @Override
    public boolean isTheClientPlayer(EntityLivingBase entity) {
        return entity == Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void setExtraReach(EntityLivingBase entity, float reach) {
        super.setExtraReach(entity, reach);
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (entity == player) {
            if (!(mc.field_71442_b instanceof IExtendedPlayerController)) {
                WorldSettings.GameType type = (WorldSettings.GameType)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])LibObfuscation.CURRENT_GAME_TYPE);
                NetHandlerPlayClient net = (NetHandlerPlayClient)ReflectionHelper.getPrivateValue(PlayerControllerMP.class, (Object)mc.field_71442_b, (String[])LibObfuscation.NET_CLIENT_HANDLER);
                BotaniaPlayerController controller = new BotaniaPlayerController(mc, net);
                controller.func_78746_a(type);
                mc.field_71442_b = controller;
            }
            ((IExtendedPlayerController)mc.field_71442_b).setReachDistanceExtension(Math.max(0.0f, ((IExtendedPlayerController)mc.field_71442_b).getReachDistanceExtension() + reach));
        }
    }

    @Override
    public boolean openWikiPage(World world, Block block, MovingObjectPosition pos) {
        IWikiProvider wiki = WikiHooks.getWikiFor(block);
        String url = wiki.getWikiURL(world, pos);
        if (url != null && !url.isEmpty()) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public long getWorldElapsedTicks() {
        return Minecraft.func_71410_x().field_71441_e == null ? 0L : Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    @Override
    public void setSparkleFXNoClip(boolean noclip) {
        noclipEnabled = noclip;
    }

    @Override
    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m, boolean fake) {
        if (!this.doParticle() && !fake) {
            return;
        }
        FXSparkle sparkle = new FXSparkle(world, x, y, z, size, r, g, b, m);
        sparkle.fake = sparkle.field_70145_X = fake;
        if (noclipEnabled) {
            sparkle.field_70145_X = true;
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)sparkle);
    }

    @Override
    public void setWispFXDistanceLimit(boolean limit) {
        distanceLimit = limit;
    }

    @Override
    public void setWispFXDepthTest(boolean test) {
        depthTest = test;
    }

    @Override
    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, float maxAgeMul) {
        if (!this.doParticle()) {
            return;
        }
        FXWisp wisp = new FXWisp(world, x, y, z, size, r, g, b, distanceLimit, depthTest, maxAgeMul);
        wisp.field_70159_w = motionx;
        wisp.field_70181_x = motiony;
        wisp.field_70179_y = motionz;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)wisp);
    }

    private boolean doParticle() {
        if (!ConfigHandler.useVanillaParticleLimiter) {
            return true;
        }
        float chance = 1.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1) {
            chance = 0.6f;
        } else if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
            chance = 0.2f;
        }
        return Math.random() < (double)chance;
    }

    @Override
    public void lightningFX(World world, Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
        LightningHandler.spawnLightningBolt(world, vectorStart, vectorEnd, ticksPerMeter, seed, colorOuter, colorInner);
    }
}

