/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.lexicon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.StatCollector;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.KnowledgeType;
import vazkii.botania.api.lexicon.LexiconCategory;
import vazkii.botania.api.lexicon.LexiconPage;

public class LexiconEntry
implements Comparable<LexiconEntry> {
    public final String unlocalizedName;
    public final LexiconCategory category;
    private KnowledgeType type = BotaniaAPI.basicKnowledge;
    public List<LexiconPage> pages = new ArrayList<LexiconPage>();
    private boolean priority = false;

    public LexiconEntry(String unlocalizedName, LexiconCategory category) {
        this.unlocalizedName = unlocalizedName;
        this.category = category;
    }

    public LexiconEntry setPriority() {
        this.priority = true;
        return this;
    }

    public LexiconEntry setKnowledgeType(KnowledgeType type) {
        this.type = type;
        return this;
    }

    public KnowledgeType getKnowledgeType() {
        return this.type;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public LexiconEntry setLexiconPages(LexiconPage ... pages) {
        this.pages.addAll(Arrays.asList(pages));
        for (int i = 0; i < this.pages.size(); ++i) {
            LexiconPage page = this.pages.get(i);
            if (page.skipRegistry) continue;
            page.onPageAdded(this, i);
        }
        return this;
    }

    public void addPage(LexiconPage page) {
        this.pages.add(page);
    }

    public final String getNameForSorting() {
        return (this.priority ? 0 : 1) + StatCollector.func_74838_a((String)this.getUnlocalizedName());
    }

    @Override
    public int compareTo(LexiconEntry o) {
        return this.getNameForSorting().compareTo(o.getNameForSorting());
    }
}

