/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.ITileBound;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.Item16Colors;
import vazkii.botania.common.item.ModItems;

public class ItemTwigWand
extends Item16Colors
implements ICoordBoundItem {
    IIcon[] icons;
    private static final String TAG_COLOR1 = "color1";
    private static final String TAG_COLOR2 = "color2";
    private static final String TAG_TICKS_SINCE_SPREADER = "ticksSinceSpreader";
    private static final String TAG_SPREADER_X = "spreaderX";
    private static final String TAG_SPREADER_Y = "spreaderY";
    private static final String TAG_SPREADER_Z = "spreaderZ";

    public ItemTwigWand() {
        super("twigWand");
        this.func_77625_d(1);
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        Block block = par3World.func_147439_a(par4, par5, par6);
        ChunkCoordinates boundSpreader = ItemTwigWand.getBoundSpreader(par1ItemStack);
        if (boundSpreader.field_71572_b != -1 && par2EntityPlayer.func_70093_af() && (boundSpreader.field_71574_a != par4 || boundSpreader.field_71572_b != par5 || boundSpreader.field_71573_c != par6)) {
            TileEntity tile = par3World.func_147438_o(boundSpreader.field_71574_a, boundSpreader.field_71572_b, boundSpreader.field_71573_c);
            if (tile instanceof TileSpreader) {
                TileSpreader spreader = (TileSpreader)tile;
                Vector3 spreaderVec = Vector3.fromTileEntityCenter(spreader);
                Vector3 blockVec = new Vector3((double)par4 + 0.5, (double)par5 + 0.5, (double)par6 + 0.5);
                AxisAlignedBB axis = par3World.func_147439_a(par4, par5, par6).func_149668_a(par3World, par4, par5, par6);
                if (axis == null) {
                    axis = AxisAlignedBB.func_72330_a((double)par4, (double)par5, (double)par6, (double)(par4 + 1), (double)(par5 + 1), (double)(par6 + 1));
                }
                if (!blockVec.isInside(axis)) {
                    blockVec = new Vector3(axis.field_72340_a + (axis.field_72336_d - axis.field_72340_a) / 2.0, axis.field_72338_b + (axis.field_72337_e - axis.field_72338_b) / 2.0, axis.field_72339_c + (axis.field_72334_f - axis.field_72339_c) / 2.0);
                }
                Vector3 diffVec = blockVec.copy().sub(spreaderVec);
                Vector3 diffVec2D = new Vector3(diffVec.x, diffVec.z, 0.0);
                Vector3 rotVec = new Vector3(0.0, 1.0, 0.0);
                double angle = rotVec.angle(diffVec2D) / Math.PI * 180.0;
                if (blockVec.x < spreaderVec.x) {
                    angle = -angle;
                }
                spreader.rotationX = (float)angle + 90.0f;
                rotVec = new Vector3(diffVec.x, 0.0, diffVec.z);
                angle = diffVec.angle(rotVec) * 180.0 / Math.PI;
                if (blockVec.y < spreaderVec.y) {
                    angle = -angle;
                }
                spreader.rotationY = (float)angle;
                spreader.checkForReceiver();
                par3World.func_147471_g(boundSpreader.field_71574_a, boundSpreader.field_71572_b, boundSpreader.field_71573_c);
                return true;
            }
            ItemTwigWand.setBoundSpreader(par1ItemStack, 0, -1, 0);
        } else if (par2EntityPlayer.func_70093_af()) {
            block.rotateBlock(par3World, par4, par5, par6, ForgeDirection.getOrientation((int)par7));
            if (par3World.field_72995_K) {
                par2EntityPlayer.func_71038_i();
            }
        }
        if (block == Blocks.field_150368_y && ConfigHandler.enchanterEnabled) {
            int meta = -1;
            if (TileEnchanter.canEnchanterExist(par3World, par4, par5, par6, 0)) {
                meta = 0;
            } else if (TileEnchanter.canEnchanterExist(par3World, par4, par5, par6, 1)) {
                meta = 1;
            }
            if (meta != -1 && !par3World.field_72995_K) {
                par3World.func_147465_d(par4, par5, par6, ModBlocks.enchanter, meta, 3);
                par3World.func_72908_a((double)par4, (double)par5, (double)par6, "botania:enchanterBlock", 0.5f, 0.6f);
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    double x = (Math.random() - 0.5) * 6.0;
                    double y = (Math.random() - 0.5) * 6.0;
                    double z = (Math.random() - 0.5) * 6.0;
                    float velMul = 0.07f;
                    Botania.proxy.wispFX(par3World, (double)par4 + 0.5 + x, (double)par5 + 0.5 + y, (double)par6 + 0.5 + z, red, green, blue, (float)Math.random() * 0.15f + 0.15f, (float)(-x) * velMul, (float)(-y) * velMul, (float)(-z) * velMul);
                }
            }
        } else {
            if (block instanceof IWandable) {
                boolean spreader = par3World.func_147438_o(par4, par5, par6) instanceof TileSpreader;
                int ticks = ItemTwigWand.getTicksSinceSpreaderUse(par1ItemStack);
                boolean wanded = false;
                if (spreader && ticks == 5 && par2EntityPlayer.func_70093_af()) {
                    if (boundSpreader.field_71574_a == par4 && boundSpreader.field_71572_b == par5 && boundSpreader.field_71573_c == par6) {
                        ItemTwigWand.setBoundSpreader(par1ItemStack, 0, -1, 0);
                    } else {
                        ItemTwigWand.setBoundSpreader(par1ItemStack, par4, par5, par6);
                    }
                    if (par3World.field_72995_K) {
                        par2EntityPlayer.func_71038_i();
                    }
                    par3World.func_72956_a((Entity)par2EntityPlayer, "botania:ding", 0.1f, 1.0f);
                    ItemTwigWand.setTicksSinceSpreaderUse(par1ItemStack, 0);
                    wanded = true;
                } else {
                    wanded = ((IWandable)block).onUsedByWand(par2EntityPlayer, par1ItemStack, par3World, par4, par5, par6, par7);
                    if (wanded) {
                        if (par3World.field_72995_K) {
                            par2EntityPlayer.func_71038_i();
                        }
                        if (spreader) {
                            ItemTwigWand.setTicksSinceSpreaderUse(par1ItemStack, 0);
                        }
                    }
                }
                return wanded;
            }
            if (BlockPistonRelay.playerPositions.containsKey(par2EntityPlayer.func_70005_c_())) {
                String bindPos = BlockPistonRelay.playerPositions.get(par2EntityPlayer.func_70005_c_());
                String currentPos = BlockPistonRelay.getCoordsAsString(par3World.field_73011_w.field_76574_g, par4, par5, par6);
                BlockPistonRelay.playerPositions.remove(par2EntityPlayer.func_70005_c_());
                BlockPistonRelay.mappedPositions.put(bindPos, currentPos);
                BlockPistonRelay.WorldData.get(par3World).func_76185_a();
                if (par3World.field_72995_K) {
                    par2EntityPlayer.func_71038_i();
                }
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        int ticks = ItemTwigWand.getTicksSinceSpreaderUse(par1ItemStack);
        if (ticks < 5) {
            ItemTwigWand.setTicksSinceSpreaderUse(par1ItemStack, ticks + 1);
        }
        ChunkCoordinates coords = ItemTwigWand.getBoundSpreader(par1ItemStack);
        TileEntity tile = par2World.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (tile == null || !(tile instanceof TileSpreader)) {
            ItemTwigWand.setBoundSpreader(par1ItemStack, 0, -1, 0);
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[3];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = IconHelper.forItem(par1IconRegister, (Item)this, i);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons[Math.min(2, pass)];
    }

    @Override
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        if (par2 == 0) {
            return 0xFFFFFF;
        }
        float[] color = EntitySheep.field_70898_d[par2 == 1 ? ItemTwigWand.getColor1(par1ItemStack) : ItemTwigWand.getColor2(par1ItemStack)];
        return new Color(color[0], color[1], color[2]).getRGB();
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    @Override
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 16; ++i) {
            par3List.add(ItemTwigWand.forColors(i, i));
        }
    }

    @Override
    public String func_77667_c(ItemStack par1ItemStack) {
        return this.getUnlocalizedNameLazy(par1ItemStack);
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public static ItemStack forColors(int color1, int color2) {
        ItemStack stack = new ItemStack(ModItems.twigWand);
        ItemNBTHelper.setInt(stack, TAG_COLOR1, color1);
        ItemNBTHelper.setInt(stack, TAG_COLOR2, color2);
        return stack;
    }

    public static int getColor1(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
    }

    public static int getColor2(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
    }

    public static void setTicksSinceSpreaderUse(ItemStack stack, int ticks) {
        ItemNBTHelper.setInt(stack, TAG_TICKS_SINCE_SPREADER, ticks);
    }

    public static int getTicksSinceSpreaderUse(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_TICKS_SINCE_SPREADER, 20);
    }

    public static void setBoundSpreader(ItemStack stack, int x, int y, int z) {
        ItemNBTHelper.setInt(stack, TAG_SPREADER_X, x);
        ItemNBTHelper.setInt(stack, TAG_SPREADER_Y, y);
        ItemNBTHelper.setInt(stack, TAG_SPREADER_Z, z);
    }

    public static ChunkCoordinates getBoundSpreader(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_SPREADER_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SPREADER_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_SPREADER_Z, 0);
        return new ChunkCoordinates(x, y, z);
    }

    @Override
    public ChunkCoordinates getBinding(ItemStack stack) {
        TileEntity tile;
        ChunkCoordinates bound = ItemTwigWand.getBoundSpreader(stack);
        if (bound.field_71572_b != -1) {
            return bound;
        }
        MovingObjectPosition pos = Minecraft.func_71410_x().field_71476_x;
        if (pos != null && (tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) != null && tile instanceof ITileBound) {
            ChunkCoordinates coords = ((ITileBound)tile).getBinding();
            return coords;
        }
        return null;
    }
}

