/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaBlock;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.item.ItemMod;
import vazkii.botania.common.lib.LibItemNames;

public class ItemLens
extends ItemMod
implements ILens {
    private static final int NORMAL = 0;
    private static final int SPEED = 1;
    private static final int POWER = 2;
    private static final int TIME = 3;
    private static final int EFFICIENCY = 4;
    private static final int BOUNCE = 5;
    private static final int GRAVITY = 6;
    private static final int MINE = 7;
    private static final int DAMAGE = 8;
    private static final int PHANTOM = 9;
    private static final int MAGNET = 10;
    private static final int EXPLOSIVE = 11;
    private static final int INFLUENCE = 12;
    private static final int WEIGHT = 13;
    private static final int PAINT = 14;
    private static final int FIRE = 15;
    private static final int PISTON = 16;
    private static final int PROP_NONE = 0;
    private static final int PROP_POWER = 1;
    private static final int PROP_ORIENTATION = 2;
    private static final int PROP_TOUCH = 4;
    private static final int PROP_INTERACTION = 8;
    private static final int PROP_DAMAGE = 16;
    private static final Map<Integer, Integer> props = new HashMap<Integer, Integer>();
    static final List<Block> paintableBlocks;
    private static final String TAG_COLOR = "color";
    private static final String TAG_COMPOSITE_LENS = "compositeLens";
    public static IIcon iconGlass;
    public static final int SUBTYPES = 17;
    IIcon[] ringIcons;

    public ItemLens() {
        this.func_77655_b("lens");
        this.func_77625_d(1);
        this.func_77627_a(true);
        GameRegistry.addRecipe((IRecipe)new CompositeLensRecipe());
        RecipeSorter.register((String)"botania:compositeLens", CompositeLensRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
        iconGlass = IconHelper.forName(par1IconRegister, "lensInside");
        this.ringIcons = new IIcon[17];
        for (int i = 0; i < this.ringIcons.length; ++i) {
            this.ringIcons[i] = IconHelper.forName(par1IconRegister, LibItemNames.LENS_NAMES[i]);
        }
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 17; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon func_77618_c(int par1, int par2) {
        return par2 == 1 ? this.ringIcons[Math.min(16, par1)] : iconGlass;
    }

    public IIcon func_77617_a(int par1) {
        return this.func_77618_c(par1, 0);
    }

    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return par2 == 0 ? this.getLensColor(par1ItemStack) : 0xFFFFFF;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return "item." + LibItemNames.LENS_NAMES[Math.min(16, par1ItemStack.func_77960_j())];
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        int storedColor = ItemLens.getStoredColor(par1ItemStack);
        if (storedColor != -1) {
            par3List.add(String.format(StatCollector.func_74838_a((String)"botaniamisc.color"), StatCollector.func_74838_a((String)("botania.color" + storedColor))));
        }
    }

    public String getItemShortTermName(ItemStack stack) {
        return StatCollector.func_74838_a((String)(stack.func_77977_a().replaceAll("item.", "item.botania:") + ".short"));
    }

    public String func_77653_i(ItemStack stack) {
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens == null) {
            return super.func_77653_i(stack);
        }
        return String.format(StatCollector.func_74838_a((String)"item.botania:compositeLens.name"), this.getItemShortTermName(stack), this.getItemShortTermName(compositeLens));
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor != -1) {
            props.color = this.getLensColor(stack);
        }
        switch (stack.func_77960_j()) {
            case 1: {
                props.motionModifier *= 2.0f;
                props.maxMana = (int)((float)props.maxMana * 0.75f);
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss / 3.0f);
                props.manaLossPerTick *= 2.0f;
                break;
            }
            case 2: {
                props.maxMana *= 2;
                props.motionModifier *= 0.85f;
                props.manaLossPerTick *= 2.0f;
                break;
            }
            case 3: {
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss * 2.25f);
                props.motionModifier *= 0.8f;
                break;
            }
            case 4: {
                props.manaLossPerTick /= 5.0f;
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss * 1.1f);
                break;
            }
            case 6: {
                props.gravity = 0.0015f;
                props.ticksBeforeManaLoss = (int)((float)props.ticksBeforeManaLoss * 1.2f);
            }
        }
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens != null && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).apply(compositeLens, props);
        }
    }

    @Override
    public boolean collideBurst(IManaBurst burst, MovingObjectPosition pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        EntityThrowable entity = (EntityThrowable)burst;
        switch (stack.func_77960_j()) {
            case 5: {
                if (isManaBlock || pos.field_72308_g != null) break;
                ChunkCoordinates coords = burst.getBurstSourceChunkCoordinates();
                if (coords.field_71574_a == pos.field_72311_b && coords.field_71572_b == pos.field_72312_c && coords.field_71573_c == pos.field_72309_d) break;
                Vector3 currentMovementVec = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                ForgeDirection dir = ForgeDirection.getOrientation((int)pos.field_72310_e);
                Vector3 normalVector = new Vector3(dir.offsetX, dir.offsetY, dir.offsetZ).normalize();
                Vector3 movementVec = normalVector.multiply(-2.0 * currentMovementVec.dotProduct(normalVector)).add(currentMovementVec);
                burst.setMotion(movementVec.x, movementVec.y, movementVec.z);
                dead = false;
                break;
            }
            case 7: {
                World world = entity.field_70170_p;
                int x = pos.field_72311_b;
                int y = pos.field_72312_c;
                int z = pos.field_72309_d;
                Block block = world.func_147439_a(x, y, z);
                TileEntity tile = world.func_147438_o(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                float hardness = block.func_149712_f(world, x, y, z);
                int mana = burst.getMana();
                ChunkCoordinates coords = burst.getBurstSourceChunkCoordinates();
                if (coords.field_71574_a == x && coords.field_71572_b == y && coords.field_71573_c == z || tile instanceof IManaBlock || block == null || hardness == -1.0f || !(hardness < 50.0f) || !burst.isFake() && mana < 24) break;
                ArrayList items = new ArrayList();
                items.addAll(block.getDrops(world, x, y, z, meta, 0));
                if (!(burst.hasAlreadyCollidedAt(x, y, z) || burst.isFake() || entity.field_70170_p.field_72995_K)) {
                    world.func_147468_f(x, y, z);
                    if (ConfigHandler.blockBreakParticles) {
                        entity.field_70170_p.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
                    }
                    for (ItemStack stack_ : items) {
                        world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack_));
                    }
                    burst.setMana(mana - 24);
                }
                dead = false;
                break;
            }
            case 9: {
                if (isManaBlock) break;
                dead = false;
                burst.setMinManaLoss(Math.max(0, burst.getMinManaLoss() - 4));
                break;
            }
            case 11: {
                if (!burst.isFake()) {
                    ChunkCoordinates coords = burst.getBurstSourceChunkCoordinates();
                    if (entity.field_70170_p.field_72995_K || pos.field_72308_g != null || isManaBlock || pos.field_72311_b == coords.field_71574_a && pos.field_72312_c == coords.field_71572_b && pos.field_72309_d == coords.field_71573_c) break;
                    entity.field_70170_p.func_72876_a((Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (float)burst.getMana() / 50.0f, true);
                    break;
                }
                dead = false;
                break;
            }
            case 13: {
                if (burst.isFake()) break;
                int x = pos.field_72311_b;
                int y = pos.field_72312_c;
                int z = pos.field_72309_d;
                Block block = entity.field_70170_p.func_147439_a(x, y, z);
                Block blockBelow = entity.field_70170_p.func_147439_a(x, y - 1, z);
                if (!blockBelow.isAir((IBlockAccess)entity.field_70170_p, x, y - 1, z) || block.func_149712_f(entity.field_70170_p, x, y, z) == -1.0f || entity.field_70170_p.func_147438_o(x, y, z) != null) break;
                EntityFallingBlock falling = new EntityFallingBlock(entity.field_70170_p, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, block, entity.field_70170_p.func_72805_g(x, y, z));
                if (entity.field_70170_p.field_72995_K) break;
                entity.field_70170_p.func_72838_d((Entity)falling);
                break;
            }
            case 14: {
                int storedColor = ItemLens.getStoredColor(stack);
                if (burst.isFake() || storedColor <= -1 || storedColor >= 17) break;
                if (pos.field_72308_g != null && pos.field_72308_g instanceof EntitySheep) {
                    int r = 20;
                    int sheepColor = ((EntitySheep)pos.field_72308_g).func_70896_n();
                    List sheepList = entity.field_70170_p.func_72872_a(EntitySheep.class, AxisAlignedBB.func_72330_a((double)(pos.field_72308_g.field_70165_t - (double)r), (double)(pos.field_72308_g.field_70163_u - (double)r), (double)(pos.field_72308_g.field_70161_v - (double)r), (double)(pos.field_72308_g.field_70165_t + (double)r), (double)(pos.field_72308_g.field_70163_u + (double)r), (double)(pos.field_72308_g.field_70161_v + (double)r)));
                    for (EntitySheep sheep : sheepList) {
                        if (sheep.func_70896_n() != sheepColor) continue;
                        sheep.func_70891_b(storedColor == 16 ? sheep.field_70170_p.field_73012_v.nextInt(16) : storedColor);
                    }
                    dead = true;
                    break;
                }
                Block block = entity.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                if (!paintableBlocks.contains(block)) break;
                int meta = entity.field_70170_p.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                ArrayList<ChunkCoordinates> coordsToPaint = new ArrayList<ChunkCoordinates>();
                ArrayList<ChunkCoordinates> coordsFound = new ArrayList<ChunkCoordinates>();
                ChunkCoordinates theseCoords = new ChunkCoordinates(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                coordsFound.add(theseCoords);
                do {
                    ArrayList iterCoords = new ArrayList(coordsFound);
                    for (ChunkCoordinates coords : iterCoords) {
                        coordsFound.remove(coords);
                        coordsToPaint.add(coords);
                        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                            Block block_ = entity.field_70170_p.func_147439_a(coords.field_71574_a + dir.offsetX, coords.field_71572_b + dir.offsetY, coords.field_71573_c + dir.offsetZ);
                            int meta_ = entity.field_70170_p.func_72805_g(coords.field_71574_a + dir.offsetX, coords.field_71572_b + dir.offsetY, coords.field_71573_c + dir.offsetZ);
                            ChunkCoordinates coords_ = new ChunkCoordinates(coords.field_71574_a + dir.offsetX, coords.field_71572_b + dir.offsetY, coords.field_71573_c + dir.offsetZ);
                            if (block_ != block || meta_ != meta || coordsFound.contains(coords_) || coordsToPaint.contains(coords_)) continue;
                            coordsFound.add(coords_);
                        }
                    }
                } while (!coordsFound.isEmpty() && coordsToPaint.size() < 1000);
                for (ChunkCoordinates coords : coordsToPaint) {
                    int placeColor;
                    int n = placeColor = storedColor == 16 ? entity.field_70170_p.field_73012_v.nextInt(16) : storedColor;
                    int metaThere = entity.field_70170_p.func_72805_g(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                    if (metaThere == placeColor) continue;
                    if (!entity.field_70170_p.field_72995_K) {
                        entity.field_70170_p.func_72921_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, placeColor, 2);
                    }
                    float[] color = EntitySheep.field_70898_d[placeColor];
                    float r = color[0];
                    float g = color[1];
                    float b = color[2];
                    for (int i = 0; i < 4; ++i) {
                        Botania.proxy.sparkleFX(entity.field_70170_p, (float)coords.field_71574_a + (float)Math.random(), (float)coords.field_71572_b + (float)Math.random(), (float)coords.field_71573_c + (float)Math.random(), r, g, b, 0.6f + (float)Math.random() * 0.3f, 5);
                    }
                }
                break;
            }
            case 15: {
                ChunkCoordinates coords = burst.getBurstSourceChunkCoordinates();
                if (coords.field_71574_a == pos.field_72311_b && coords.field_71572_b == pos.field_72312_c && coords.field_71573_c == pos.field_72309_d || burst.isFake() || isManaBlock) break;
                ForgeDirection dir = ForgeDirection.getOrientation((int)pos.field_72310_e);
                int x = pos.field_72311_b + dir.offsetX;
                int y = pos.field_72312_c + dir.offsetY;
                int z = pos.field_72309_d + dir.offsetZ;
                Block blockAt = entity.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                Block blockAt_ = entity.field_70170_p.func_147439_a(x, y, z);
                if (blockAt == Blocks.field_150427_aO) {
                    entity.field_70170_p.func_147449_b(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, Blocks.field_150350_a);
                    break;
                }
                if (!blockAt_.isAir((IBlockAccess)entity.field_70170_p, x, y, z)) break;
                entity.field_70170_p.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                break;
            }
            case 16: {
                ChunkCoordinates coords = burst.getBurstSourceChunkCoordinates();
                if (coords.field_71574_a == pos.field_72311_b && coords.field_71572_b == pos.field_72312_c && coords.field_71573_c == pos.field_72309_d || burst.isFake() || isManaBlock || entity.field_70170_p.field_72995_K) break;
                ForgeDirection dir = ForgeDirection.getOrientation((int)pos.field_72310_e).getOpposite();
                int x = pos.field_72311_b + dir.offsetX;
                int y = pos.field_72312_c + dir.offsetY;
                int z = pos.field_72309_d + dir.offsetZ;
                if (!entity.field_70170_p.func_147437_c(x, y, z) && !entity.field_70170_p.func_147439_a(x, y, z).isReplaceable((IBlockAccess)entity.field_70170_p, x, y, z)) break;
                Block block = entity.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                int meta = entity.field_70170_p.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                TileEntity tile = entity.field_70170_p.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                if (block.func_149656_h() != 0 || block == Blocks.field_150343_Z || tile != null) break;
                entity.field_70170_p.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                entity.field_70170_p.func_147465_d(x, y, z, block, meta, 3);
                entity.field_70170_p.func_72926_e(2001, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, Block.func_149682_b((Block)block) + (meta << 12));
                break;
            }
        }
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens != null && compositeLens.func_77973_b() instanceof ILens) {
            dead = ((ILens)compositeLens.func_77973_b()).collideBurst(burst, pos, isManaBlock, dead, compositeLens);
        }
        return dead;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        EntityThrowable entity = (EntityThrowable)burst;
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == 16 && entity.field_70170_p.field_72995_K) {
            burst.setColor(this.getLensColor(stack));
        }
        boolean magnetized = entity.getEntityData().func_74764_b("Botania:Magnetized");
        block0 : switch (stack.func_77960_j()) {
            case 8: {
                AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)entity.field_70142_S, (double)entity.field_70137_T, (double)entity.field_70136_U).func_72314_b(1.0, 1.0, 1.0);
                List entities = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
                for (EntityLivingBase living : entities) {
                    int mana;
                    if (living instanceof EntityPlayer || living.field_70737_aN != 0 || (mana = burst.getMana()) < 16) continue;
                    burst.setMana(mana - 16);
                    if (burst.isFake() || entity.field_70170_p.field_72995_K) break block0;
                    living.func_70097_a(DamageSource.field_76376_m, 4.0f);
                    break block0;
                }
                break;
            }
            case 10: {
                int x = (int)entity.field_70165_t;
                int y = (int)entity.field_70163_u;
                int z = (int)entity.field_70161_v;
                int range = 3;
                for (int i = -range; i < range; ++i) {
                    for (int j = -range; j < range; ++j) {
                        for (int k = -range; k < range; ++k) {
                            if (!(entity.field_70170_p.func_147438_o(i + x, j + y, k + z) instanceof IManaReceiver)) continue;
                            TileEntity tile = entity.field_70170_p.func_147438_o(i + x, j + y, k + z);
                            if (magnetized) {
                                int magX = entity.getEntityData().func_74762_e("Botania:MagnetizedX");
                                int magY = entity.getEntityData().func_74762_e("Botania:MagnetizedY");
                                int magZ = entity.getEntityData().func_74762_e("Botania:MagnetizedZ");
                                if (tile.field_145851_c != magX || tile.field_145848_d != magY || tile.field_145849_e != magZ) continue;
                            }
                            IManaReceiver receiver = (IManaReceiver)tile;
                            ChunkCoordinates srcCoords = burst.getBurstSourceChunkCoordinates();
                            if (!(MathHelper.pointDistanceSpace(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, srcCoords.field_71574_a, srcCoords.field_71572_b, srcCoords.field_71573_c) > 3.0f) || !receiver.canRecieveManaFromBursts() || receiver.isFull()) continue;
                            Vector3 burstVec = Vector3.fromEntity((Entity)entity);
                            Vector3 tileVec = Vector3.fromTileEntityCenter(tile).add(0.0, -0.1, 0.0);
                            Vector3 motionVec = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                            Vector3 normalMotionVec = motionVec.copy().normalize();
                            Vector3 magnetVec = tileVec.sub(burstVec).normalize();
                            Vector3 differenceVec = normalMotionVec.sub(magnetVec).multiply(motionVec.mag() * 0.1);
                            Vector3 finalMotionVec = motionVec.sub(differenceVec);
                            if (!magnetized) {
                                finalMotionVec.multiply(0.75);
                                entity.getEntityData().func_74757_a("Botania:Magnetized", true);
                                entity.getEntityData().func_74768_a("Botania:MagnetizedX", tile.field_145851_c);
                                entity.getEntityData().func_74768_a("Botania:MagnetizedY", tile.field_145848_d);
                                entity.getEntityData().func_74768_a("Botania:MagnetizedZ", tile.field_145849_e);
                            }
                            burst.setMotion(finalMotionVec.x, finalMotionVec.y, finalMotionVec.z);
                            break block0;
                        }
                    }
                }
                break;
            }
            case 12: {
                if (burst.isFake()) break;
                double range = 3.5;
                List movables = entity.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - range), (double)(entity.field_70163_u - range), (double)(entity.field_70161_v - range), (double)(entity.field_70165_t + range), (double)(entity.field_70163_u + range), (double)(entity.field_70161_v + range)));
                movables.addAll(entity.field_70170_p.func_72872_a(EntityXPOrb.class, AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - range), (double)(entity.field_70163_u - range), (double)(entity.field_70161_v - range), (double)(entity.field_70165_t + range), (double)(entity.field_70163_u + range), (double)(entity.field_70161_v + range))));
                movables.addAll(entity.field_70170_p.func_72872_a(EntityArrow.class, AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - range), (double)(entity.field_70163_u - range), (double)(entity.field_70161_v - range), (double)(entity.field_70165_t + range), (double)(entity.field_70163_u + range), (double)(entity.field_70161_v + range))));
                movables.addAll(entity.field_70170_p.func_72872_a(EntityFallingBlock.class, AxisAlignedBB.func_72330_a((double)(entity.field_70165_t - range), (double)(entity.field_70163_u - range), (double)(entity.field_70161_v - range), (double)(entity.field_70165_t + range), (double)(entity.field_70163_u + range), (double)(entity.field_70161_v + range))));
                for (Entity movable : movables) {
                    movable.field_70159_w = entity.field_70159_w;
                    movable.field_70181_x = entity.field_70181_x;
                    movable.field_70179_y = entity.field_70179_y;
                }
                break;
            }
        }
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens != null && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).updateBurst(burst, compositeLens);
        }
    }

    @Override
    public int getLensColor(ItemStack stack) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == -1) {
            return 0xFFFFFF;
        }
        if (storedColor == 16) {
            return Color.HSBtoRGB((float)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L) / 360.0f, 1.0f, 1.0f);
        }
        float[] color = EntitySheep.field_70898_d[storedColor];
        return new Color(color[0], color[1], color[2]).getRGB();
    }

    public static int getStoredColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR, -1);
    }

    public static ItemStack setLensColor(ItemStack stack, int color) {
        ItemNBTHelper.setInt(stack, TAG_COLOR, color);
        return stack;
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    public static void setProps(int lens, int props_) {
        props.put(lens, props_);
    }

    public static boolean isBlacklisted(int lens1, int lens2) {
        return (props.get(lens1) & props.get(lens2)) != 0;
    }

    @Override
    public boolean canCombineLenses(ItemStack sourceLens, ItemStack compositeLens) {
        if (sourceLens.func_77960_j() == compositeLens.func_77960_j()) {
            return false;
        }
        if (sourceLens.func_77960_j() == 0 || compositeLens.func_77960_j() == 0) {
            return false;
        }
        return !ItemLens.isBlacklisted(sourceLens.func_77960_j(), compositeLens.func_77960_j());
    }

    @Override
    public ItemStack getCompositeLens(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_COMPOSITE_LENS, false);
        ItemStack lens = ItemStack.func_77949_a((NBTTagCompound)cmp);
        return lens;
    }

    @Override
    public ItemStack setCompositeLens(ItemStack sourceLens, ItemStack compositeLens) {
        NBTTagCompound cmp = new NBTTagCompound();
        compositeLens.func_77955_b(cmp);
        ItemNBTHelper.setCompound(sourceLens, TAG_COMPOSITE_LENS, cmp);
        return sourceLens;
    }

    static {
        ItemLens.setProps(0, 0);
        ItemLens.setProps(1, 0);
        ItemLens.setProps(2, 1);
        ItemLens.setProps(3, 0);
        ItemLens.setProps(4, 0);
        ItemLens.setProps(5, 4);
        ItemLens.setProps(6, 2);
        ItemLens.setProps(7, 12);
        ItemLens.setProps(8, 16);
        ItemLens.setProps(9, 4);
        ItemLens.setProps(10, 2);
        ItemLens.setProps(11, 28);
        ItemLens.setProps(12, 0);
        ItemLens.setProps(13, 12);
        ItemLens.setProps(14, 12);
        ItemLens.setProps(15, 28);
        ItemLens.setProps(16, 12);
        paintableBlocks = new ArrayList(){
            {
                this.add(Blocks.field_150399_cn);
                this.add(Blocks.field_150397_co);
                this.add(Blocks.field_150406_ce);
                this.add(Blocks.field_150325_L);
                this.add(Blocks.field_150404_cg);
                this.add(ModBlocks.unstableBlock);
                this.add(ModBlocks.manaBeacon);
            }
        };
    }
}

