/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.BiomeDecorationHandler;
import vazkii.botania.common.core.handler.ChestGenHandler;
import vazkii.botania.common.core.handler.CommonTickHandler;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.InternalMethodHandler;
import vazkii.botania.common.core.handler.ManaNetworkHandler;
import vazkii.botania.common.core.handler.PixieHandler;
import vazkii.botania.common.core.handler.SheddingHandler;
import vazkii.botania.common.core.handler.SpawnerChangingHandler;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.core.version.CommandDownloadLatest;
import vazkii.botania.common.crafting.ModCrafingRecipes;
import vazkii.botania.common.crafting.ModElvenTradeRecipes;
import vazkii.botania.common.crafting.ModManaAlchemyRecipes;
import vazkii.botania.common.crafting.ModManaConjurationRecipes;
import vazkii.botania.common.crafting.ModManaInfusionRecipes;
import vazkii.botania.common.crafting.ModPetalRecipes;
import vazkii.botania.common.crafting.ModRuneRecipes;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.network.GuiHandler;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        BotaniaAPI.internalHandler = new InternalMethodHandler();
        ConfigHandler.loadConfig(event.getSuggestedConfigurationFile());
        ModBlocks.init();
        ModItems.init();
        ModEntities.init();
        ModCrafingRecipes.init();
        ModPetalRecipes.init();
        ModRuneRecipes.init();
        ModManaAlchemyRecipes.init();
        ModManaConjurationRecipes.init();
        ModManaInfusionRecipes.init();
        ModElvenTradeRecipes.init();
        ChestGenHandler.init();
        LexiconData.init();
    }

    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Botania.instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BiomeDecorationHandler());
        MinecraftForge.EVENT_BUS.register((Object)ManaNetworkHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)new PixieHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SheddingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpawnerChangingHandler());
        FMLCommonHandler.instance().bus().register((Object)new CommonTickHandler());
    }

    public void postInit(FMLPostInitializationEvent event) {
        ModBlocks.addDispenserBehaviours();
        ConfigHandler.loadPostInit();
        LexiconData.postInit();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDownloadLatest());
    }

    public void setEntryToOpen(LexiconEntry entry) {
    }

    public boolean isTheClientPlayer(EntityLivingBase entity) {
        return false;
    }

    public void setExtraReach(EntityLivingBase entity, float reach) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71134_c.setBlockReachDistance(Math.max(5.0, ((EntityPlayerMP)entity).field_71134_c.getBlockReachDistance() + (double)reach));
        }
    }

    public boolean openWikiPage(World world, Block block, MovingObjectPosition pos) {
        return false;
    }

    public long getWorldElapsedTicks() {
        return MinecraftServer.func_71276_C().field_71305_c[0].func_82737_E();
    }

    public void setSparkleFXNoClip(boolean noclip) {
    }

    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m) {
        this.sparkleFX(world, x, y, z, r, g, b, size, m, false);
    }

    public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m, boolean fake) {
    }

    public void setWispFXDistanceLimit(boolean limit) {
    }

    public void setWispFXDepthTest(boolean depth) {
    }

    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size) {
        this.wispFX(world, x, y, z, r, g, b, size, 0.0f);
    }

    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float gravity) {
        this.wispFX(world, x, y, z, r, g, b, size, gravity, 1.0f);
    }

    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float gravity, float maxAgeMul) {
        this.wispFX(world, x, y, z, r, g, b, size, 0.0f, -gravity, 0.0f, maxAgeMul);
    }

    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz) {
        this.wispFX(world, x, y, z, r, g, b, size, motionx, motiony, motionz, 1.0f);
    }

    public void wispFX(World world, double x, double y, double z, float r, float g, float b, float size, float motionx, float motiony, float motionz, float maxAgeMul) {
    }

    public void lightningFX(World world, Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, int colorOuter, int colorInner) {
        this.lightningFX(world, vectorStart, vectorEnd, ticksPerMeter, System.nanoTime(), colorOuter, colorInner);
    }

    public void lightningFX(World world, Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
    }
}

