/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.ICreativeManaProvider;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wiki.IWikiProvider;
import vazkii.botania.api.wiki.WikiHooks;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.ModItems;

public final class HUDHandler {
    private static final ResourceLocation manaBar = new ResourceLocation("botania:textures/gui/manaHud.png");

    @SubscribeEvent
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            MovingObjectPosition pos = mc.field_71476_x;
            if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().func_77973_b() == ModItems.twigWand) {
                Block block = mc.field_71441_e.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                if (block instanceof IWandHUD) {
                    ((IWandHUD)block).renderHUD(mc, event.resolution, (World)mc.field_71441_e, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                }
            } else if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().func_77973_b() == ModItems.lexicon) {
                Block block = mc.field_71441_e.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                this.drawLexiconGUI(block, pos, event.resolution);
            }
        } else if (event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            int invSize;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            int totalMana = 0;
            int totalMaxMana = 0;
            boolean anyRequest = false;
            boolean creative = false;
            InventoryPlayer mainInv = player.field_71071_by;
            InventoryBaubles baublesInv = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            int size = invSize = mainInv.func_70302_i_();
            if (baublesInv != null) {
                size += baublesInv.func_70302_i_();
            }
            for (int i = 0; i < size; ++i) {
                boolean useBaubles = i >= invSize;
                Object inv = useBaubles ? baublesInv : mainInv;
                ItemStack stack = inv.func_70301_a(i - (useBaubles ? invSize : 0));
                if (stack == null) continue;
                Item item = stack.func_77973_b();
                if (item instanceof IManaUsingItem) {
                    boolean bl = anyRequest = anyRequest || ((IManaUsingItem)item).usesMana(stack);
                }
                if (item instanceof IManaItem && !((IManaItem)item).isNoExport(stack)) {
                    totalMana += ((IManaItem)item).getMana(stack);
                    totalMaxMana += ((IManaItem)item).getMaxMana(stack);
                }
                if (!(item instanceof ICreativeManaProvider) || !((ICreativeManaProvider)item).isCreative(stack)) continue;
                creative = true;
            }
            if (anyRequest) {
                this.renderManaInvBar(event.resolution, creative, totalMana, totalMaxMana);
            }
        }
    }

    private void renderManaInvBar(ScaledResolution res, boolean hasCreative, int totalMana, int totalMaxMana) {
        int width = 182;
        int x = res.func_78326_a() / 2 - width / 2;
        int y = res.func_78328_b() - 29;
        if (!hasCreative) {
            width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        }
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        Color color = new Color(Color.HSBtoRGB(0.55f, (float)Math.min(1.0, Math.sin((double)System.currentTimeMillis() / 200.0) * 0.5 + 1.0), 1.0f));
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)(255 - color.getRed())));
        mc.field_71446_o.func_110577_a(manaBar);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, 0, 251, width, 5);
        GL11.glDisable((int)3042);
    }

    private void drawLexiconGUI(Block block, MovingObjectPosition pos, ScaledResolution res) {
        IWikiProvider provider;
        String url;
        LexiconEntry entry;
        Minecraft mc = Minecraft.func_71410_x();
        boolean draw = false;
        String drawStr = "";
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int sx = res.func_78326_a() / 2 - 17;
        int sy = res.func_78328_b() / 2 + 2;
        if (block instanceof ILexiconable && (entry = ((ILexiconable)block).getEntry((World)mc.field_71441_e, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, (EntityPlayer)mc.field_71439_g, mc.field_71439_g.func_71045_bC())) != null) {
            drawStr = StatCollector.func_74838_a((String)entry.getUnlocalizedName());
            draw = true;
        }
        if (!draw && pos.field_72308_g == null && (url = (provider = WikiHooks.getWikiFor(block)).getWikiURL((World)mc.field_71441_e, pos)) != null && !url.isEmpty()) {
            String name = provider.getBlockName((World)mc.field_71441_e, pos);
            String wikiName = provider.getWikiName((World)mc.field_71441_e, pos);
            drawStr = name + "  @ " + EnumChatFormatting.AQUA + wikiName;
            draw = true;
        }
        if (draw) {
            if (!mc.field_71439_g.func_70093_af()) {
                drawStr = "?";
            }
            RenderItem.getInstance().func_77015_a(mc.field_71466_p, mc.field_71446_o, new ItemStack(ModItems.lexicon), sx, sy);
            GL11.glDisable((int)2896);
            mc.field_71466_p.func_78261_a(drawStr, sx + 10, sy + 8, -1);
        }
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawSimpleManaHUD(int color, int mana, int maxMana, String name, ScaledResolution res) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft mc = Minecraft.func_71410_x();
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(name) / 2;
        int y = res.func_78328_b() / 2 + 10;
        mc.field_71466_p.func_78261_a(name, x, y, color);
        x = res.func_78326_a() / 2 - 51;
        HUDHandler.renderManaBar(x, y += 10, color, 0.5f, mana, maxMana);
        if (mana < 0) {
            String text = StatCollector.func_74838_a((String)"botaniamisc.statusUnknown");
            x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(text) / 2;
            mc.field_71466_p.func_78261_a(text, x, --y, color);
        }
        GL11.glDisable((int)3042);
    }

    public static void renderManaBar(int x, int y, int color, float alpha, int mana, int maxMana) {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.field_71446_o.func_110577_a(manaBar);
        RenderHelper.drawTexturedModalRect(x, y, 0.0f, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(x + 1 + manaPercentage, y + 1, 0.0f, 0, 5, 100 - manaPercentage, 3);
        Color color_ = new Color(color);
        GL11.glColor4ub((byte)((byte)color_.getRed()), (byte)((byte)color_.getGreen()), (byte)((byte)color_.getBlue()), (byte)((byte)(255.0f * alpha)));
        RenderHelper.drawTexturedModalRect(x + 1, y + 1, 0.0f, 0, 5, manaPercentage, 3);
    }
}

