/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.wiki;

import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import vazkii.botania.api.wiki.IWikiProvider;

public class SimpleWikiProvider
implements IWikiProvider {
    final String name;
    final String urlBase;
    final String replacement;

    public SimpleWikiProvider(String name, String urlBase) {
        this(name, urlBase, "%20");
    }

    public SimpleWikiProvider(String name, String urlBase, String replacement) {
        this.name = name;
        this.urlBase = urlBase;
        this.replacement = replacement;
    }

    @Override
    public String getBlockName(World world, MovingObjectPosition pos) {
        int x = pos.field_72311_b;
        int y = pos.field_72312_c;
        int z = pos.field_72309_d;
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return null;
        }
        ItemStack stack = block.getPickBlock(pos, world, x, y, z);
        if (stack == null || stack.func_77973_b() == null) {
            stack = new ItemStack(block, 1, world.func_72805_g(x, y, z));
        }
        if (stack.func_77973_b() == null) {
            return null;
        }
        String name = stack.func_82833_r();
        if (name == null || name.isEmpty()) {
            return null;
        }
        return name;
    }

    @Override
    public String getWikiURL(World world, MovingObjectPosition pos) {
        String name = this.getBlockName(world, pos);
        if (name == null) {
            return null;
        }
        return String.format(this.urlBase, name.replaceAll(" ", this.replacement).toLowerCase());
    }

    @Override
    public String getWikiName(World world, MovingObjectPosition pos) {
        return this.name;
    }
}

