/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorParadigmComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MeteorParadigm {
    public List<MeteorParadigmComponent> componentList = new ArrayList<MeteorParadigmComponent>();
    public ItemStack focusStack;
    public int radius;
    public static int maxChance = 1000;

    public MeteorParadigm(ItemStack focusStack, int radius) {
        this.focusStack = focusStack;
        this.radius = radius;
    }

    public void parseStringArray(String[] oreArray) {
        int i = 0;
        while (i + 1 < oreArray.length) {
            String oreName = oreArray[i];
            int oreChance = Integer.parseInt(oreArray[i + 1]);
            MeteorParadigmComponent mpc = new MeteorParadigmComponent(oreName, oreChance);
            this.componentList.add(mpc);
            i += 2;
        }
    }

    public void createMeteorImpact(World world, int x, int y, int z) {
        world.func_72876_a(null, (double)x, (double)y, (double)z, (float)(this.radius * 4), AlchemicalWizardry.doMeteorsDestroyBlocks);
        for (int i = -this.radius; i <= this.radius; ++i) {
            for (int j = -this.radius; j <= this.radius; ++j) {
                for (int k = -this.radius; k <= this.radius; ++k) {
                    if ((float)(i * i + j * j + k * k) >= ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f) || !world.func_147437_c(x + i, y + j, z + k)) continue;
                    int randNum = world.field_73012_v.nextInt(maxChance);
                    boolean hasPlacedBlock = false;
                    for (MeteorParadigmComponent mpc : this.componentList) {
                        if (mpc == null || !mpc.isValidBlockParadigm() || (randNum -= mpc.getChance()) >= 0) continue;
                        ItemStack blockStack = mpc.getValidBlockParadigm();
                        world.func_147465_d(x + i, y + j, z + k, Block.func_149729_e((int)Item.func_150891_b((Item)blockStack.func_77973_b())), blockStack.func_77960_j(), 3);
                        hasPlacedBlock = true;
                        break;
                    }
                    if (hasPlacedBlock) continue;
                    world.func_147465_d(x + i, y + j, z + k, Blocks.field_150348_b, 0, 3);
                }
            }
        }
    }
}

