/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class SpellHelper {
    public static Random rand = new Random();
    public static final double root2 = Math.sqrt(2.0);

    public static void smeltBlockInWorld(World world, int posX, int posY, int posZ) {
        FurnaceRecipes recipes = FurnaceRecipes.func_77602_a();
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == null) {
            return;
        }
        int meta = world.func_72805_g(posX, posY, posZ);
        ItemStack smeltedStack = recipes.func_151395_a(new ItemStack(block, 1, meta));
        if (smeltedStack != null && smeltedStack.func_77973_b() instanceof ItemBlock) {
            world.func_147465_d(posX, posY, posZ, ((ItemBlock)smeltedStack.func_77973_b()).field_150939_a, smeltedStack.func_77960_j(), 3);
        }
    }

    public static List<Entity> getEntitiesInRange(World world, double posX, double posY, double posZ, double horizontalRadius, double verticalRadius) {
        return world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(posX - 0.5), (double)(posY - 0.5), (double)(posZ - 0.5), (double)(posX + 0.5), (double)(posY + 0.5), (double)(posZ + 0.5)).func_72314_b(horizontalRadius, verticalRadius, horizontalRadius));
    }

    public static List<EntityPlayer> getPlayersInRange(World world, double posX, double posY, double posZ, double horizontalRadius, double verticalRadius) {
        return world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(posX - 0.5), (double)(posY - 0.5), (double)(posZ - 0.5), (double)(posX + 0.5), (double)(posY + 0.5), (double)(posZ + 0.5)).func_72314_b(horizontalRadius, verticalRadius, horizontalRadius));
    }

    public static double gaussian(double d) {
        return d * ((double)rand.nextFloat() - 0.5);
    }

    public static Vec3 getEntityBlockVector(Entity entity) {
        int posX = (int)Math.round(entity.field_70165_t - 0.5);
        int posY = (int)entity.field_70163_u;
        int posZ = (int)Math.round(entity.field_70161_v - 0.5);
        entity.func_70040_Z();
        return Vec3.func_72443_a((double)posX, (double)posY, (double)posZ);
    }

    public static ForgeDirection getDirectionForLookVector(Vec3 lookVec) {
        double distance = lookVec.func_72433_c();
        if (lookVec.field_72448_b > distance * 0.9) {
            return ForgeDirection.UP;
        }
        if (lookVec.field_72448_b < distance * -0.9) {
            return ForgeDirection.DOWN;
        }
        return SpellHelper.getCompassDirectionForLookVector(lookVec);
    }

    public static ForgeDirection getCompassDirectionForLookVector(Vec3 lookVec) {
        double radius = Math.sqrt(Math.pow(lookVec.field_72450_a, 2.0) + Math.pow(lookVec.field_72449_c, 2.0));
        if (lookVec.field_72449_c > radius * 1.0 / root2) {
            return ForgeDirection.SOUTH;
        }
        if (lookVec.field_72449_c < -radius * 1.0 / root2) {
            return ForgeDirection.NORTH;
        }
        if (lookVec.field_72450_a > radius * 1.0 / root2) {
            return ForgeDirection.EAST;
        }
        if (lookVec.field_72450_a < -radius * 1.0 / root2) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.EAST;
    }

    public static void freezeWaterBlock(World world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_147449_b(posX, posY, posZ, Blocks.field_150432_aD);
        }
    }

    public static String getUsername(EntityPlayer player) {
        return player.getDisplayName();
    }

    public static void sendParticleToPlayer(EntityPlayer player, String str, double xCoord, double yCoord, double zCoord, double xVel, double yVel, double zVel) {
        if (player instanceof EntityPlayerMP) {
            NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getParticlePacket(str, xCoord, yCoord, zCoord, xVel, yVel, zVel), (EntityPlayerMP)player);
        }
    }

    public static void sendIndexedParticleToPlayer(EntityPlayer player, int index, double xCoord, double yCoord, double zCoord) {
        switch (index) {
            case 1: {
                SpellHelper.sendParticleToPlayer(player, "mobSpell", xCoord + 0.5 + rand.nextGaussian() / 8.0, yCoord + 1.1, zCoord + 0.5 + rand.nextGaussian() / 8.0, 0.5117, 0.0117, 0.0117);
                break;
            }
            case 2: {
                SpellHelper.sendParticleToPlayer(player, "reddust", xCoord + 0.5 + rand.nextGaussian() / 8.0, yCoord + 1.1, zCoord + 0.5 + rand.nextGaussian() / 8.0, 0.82, 0.941, 0.91);
                break;
            }
            case 3: {
                SpellHelper.sendParticleToPlayer(player, "mobSpell", xCoord + 0.5 + rand.nextGaussian() / 8.0, yCoord + 1.1, zCoord + 0.5 + rand.nextGaussian() / 8.0, 1.0, 0.371, 0.371);
                break;
            }
            case 4: {
                float f = 1.0f;
                float f1 = f * 0.6f + 0.4f;
                float f2 = f * f * 0.7f - 0.5f;
                float f3 = f * f * 0.6f - 0.7f;
                for (int l = 0; l < 8; ++l) {
                    SpellHelper.sendParticleToPlayer(player, "reddust", xCoord + Math.random() - Math.random(), yCoord + Math.random() - Math.random(), zCoord + Math.random() - Math.random(), f1, f2, f3);
                }
                break;
            }
        }
    }

    public static void sendParticleToAllAround(World world, double xPos, double yPos, double zPos, int radius, int dimension, String str, double xCoord, double yCoord, double zCoord, double xVel, double yVel, double zVel) {
        List<EntityPlayer> entities = SpellHelper.getPlayersInRange(world, xPos, yPos, zPos, radius, radius);
        if (entities == null) {
            return;
        }
        for (EntityPlayer player : entities) {
            SpellHelper.sendParticleToPlayer(player, str, xCoord, yCoord, zCoord, xVel, yVel, zVel);
        }
    }

    public static void sendIndexedParticleToAllAround(World world, double xPos, double yPos, double zPos, int radius, int dimension, int index, double xCoord, double yCoord, double zCoord) {
        List<EntityPlayer> entities = SpellHelper.getPlayersInRange(world, xPos, yPos, zPos, radius, radius);
        if (entities == null) {
            return;
        }
        for (EntityPlayer player : entities) {
            SpellHelper.sendIndexedParticleToPlayer(player, index, xCoord, yCoord, zCoord);
        }
    }

    public static void setPlayerSpeedFromServer(EntityPlayer player, double motionX, double motionY, double motionZ) {
        if (player instanceof EntityPlayerMP) {
            NewPacketHandler.INSTANCE.sendTo(NewPacketHandler.getVelSettingPacket(motionX, motionY, motionZ), (EntityPlayerMP)player);
        }
    }

    public static void smashBlock(World world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == Blocks.field_150348_b) {
            world.func_147449_b(posX, posY, posZ, Blocks.field_150347_e);
            return;
        }
        if (block == Blocks.field_150347_e) {
            world.func_147449_b(posX, posY, posZ, Blocks.field_150351_n);
            return;
        }
        if (block == Blocks.field_150351_n) {
            world.func_147449_b(posX, posY, posZ, Blocks.field_150354_m);
            return;
        }
    }

    public static boolean isBlockFluid(Block block) {
        return block instanceof BlockLiquid;
    }

    public static void evaporateWaterBlock(World world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            world.func_147468_f(posX, posY, posZ);
        }
    }

    public static ItemStack getDustForOre(ItemStack item) {
        String oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)item));
        if (oreName.contains("ore")) {
            String lowercaseOre = oreName.toLowerCase();
            boolean isAllowed = false;
            for (String str : AlchemicalWizardry.allowedCrushedOresArray) {
                String testStr = str.toLowerCase();
                if (!lowercaseOre.contains(testStr)) continue;
                isAllowed = true;
                break;
            }
            if (!isAllowed) {
                return null;
            }
            String dustName = oreName.replace("ore", "dust");
            ArrayList items = OreDictionary.getOres((String)dustName);
            if (items != null && items.size() >= 1) {
                return ((ItemStack)items.get(0)).func_77946_l();
            }
        }
        return null;
    }
}

