/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.common.block.RitualStone;
import WayofTime.alchemicalWizardry.common.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectAnimalGrowth;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectApiaryOverclock;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectBiomeChanger;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectContainment;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectCrushing;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectFeatheredEarth;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectFeatheredKnife;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectFlight;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectGrowth;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectHealing;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectInterdiction;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectJumping;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectLava;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectLeap;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectMagnetic;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectSoulBound;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectSummonMeteor;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectUnbinding;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectWater;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffectWellOfSuffering;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class Rituals {
    private List<RitualComponent> components;
    private int crystalLevel;
    private int actCost;
    private RitualEffect effect;
    private String name;
    public static List<Rituals> ritualList = new ArrayList<Rituals>();

    public Rituals(List<RitualComponent> components, int crystalLevel, int actCost, RitualEffect effect, String name) {
        this.components = components;
        this.crystalLevel = crystalLevel;
        this.actCost = actCost;
        this.effect = effect;
        this.name = name;
    }

    public Rituals(List<RitualComponent> components, int crystalLevel, int actCost, RitualEffect effect) {
        this.components = components;
        this.crystalLevel = crystalLevel;
        this.actCost = actCost;
        this.effect = effect;
        this.name = "";
    }

    public static int checkValidRitual(World world, int x, int y, int z) {
        for (int i = 1; i <= ritualList.size(); ++i) {
            if (!Rituals.checkRitualIsValid(world, x, y, z, i)) continue;
            return i;
        }
        return 0;
    }

    public static boolean canCrystalActivate(int ritual, int crystalLevel) {
        if (ritual <= ritualList.size()) {
            return Rituals.ritualList.get((int)(ritual - 1)).crystalLevel <= crystalLevel;
        }
        return false;
    }

    public static boolean checkRitualIsValid(World world, int x, int y, int z, int ritualID) {
        int direction = Rituals.getDirectionOfRitual(world, x, y, z, ritualID);
        return direction != -1;
    }

    public static boolean checkDirectionOfRitualValid(World world, int x, int y, int z, int ritualID, int direction) {
        List<RitualComponent> ritual = Rituals.getRitualList(ritualID);
        if (ritual == null) {
            return false;
        }
        Block test = null;
        switch (direction) {
            case 1: {
                for (RitualComponent rc : ritual) {
                    test = world.func_147439_a(x + rc.getX(), y + rc.getY(), z + rc.getZ());
                    if (!(test instanceof RitualStone)) {
                        return false;
                    }
                    if (world.func_72805_g(x + rc.getX(), y + rc.getY(), z + rc.getZ()) == rc.getStoneType()) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                for (RitualComponent rc : ritual) {
                    test = world.func_147439_a(x - rc.getZ(), y + rc.getY(), z + rc.getX());
                    if (!(test instanceof RitualStone)) {
                        return false;
                    }
                    if (world.func_72805_g(x - rc.getZ(), y + rc.getY(), z + rc.getX()) == rc.getStoneType()) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                for (RitualComponent rc : ritual) {
                    test = world.func_147439_a(x - rc.getX(), y + rc.getY(), z - rc.getZ());
                    if (!(test instanceof RitualStone)) {
                        return false;
                    }
                    if (world.func_72805_g(x - rc.getX(), y + rc.getY(), z - rc.getZ()) == rc.getStoneType()) continue;
                    return false;
                }
                return true;
            }
            case 4: {
                for (RitualComponent rc : ritual) {
                    test = world.func_147439_a(x + rc.getZ(), y + rc.getY(), z - rc.getX());
                    if (!(test instanceof RitualStone)) {
                        return false;
                    }
                    if (world.func_72805_g(x + rc.getZ(), y + rc.getY(), z - rc.getX()) == rc.getStoneType()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static int getDirectionOfRitual(World world, int x, int y, int z, int ritualID) {
        for (int i = 1; i <= 4; ++i) {
            if (!Rituals.checkDirectionOfRitualValid(world, x, y, z, ritualID, i)) continue;
            return i;
        }
        return -1;
    }

    public static void loadRituals() {
        int i;
        int i2;
        ArrayList<RitualComponent> waterRitual = new ArrayList<RitualComponent>();
        waterRitual.add(new RitualComponent(-1, 0, 1, 1));
        waterRitual.add(new RitualComponent(-1, 0, -1, 1));
        waterRitual.add(new RitualComponent(1, 0, -1, 1));
        waterRitual.add(new RitualComponent(1, 0, 1, 1));
        ArrayList<RitualComponent> lavaRitual = new ArrayList<RitualComponent>();
        lavaRitual.add(new RitualComponent(1, 0, 0, 2));
        lavaRitual.add(new RitualComponent(-1, 0, 0, 2));
        lavaRitual.add(new RitualComponent(0, 0, 1, 2));
        lavaRitual.add(new RitualComponent(0, 0, -1, 2));
        ArrayList<RitualComponent> growthRitual = new ArrayList<RitualComponent>();
        growthRitual.add(new RitualComponent(1, 0, 0, 1));
        growthRitual.add(new RitualComponent(-1, 0, 0, 1));
        growthRitual.add(new RitualComponent(0, 0, 1, 1));
        growthRitual.add(new RitualComponent(0, 0, -1, 1));
        growthRitual.add(new RitualComponent(-1, 0, 1, 3));
        growthRitual.add(new RitualComponent(1, 0, 1, 3));
        growthRitual.add(new RitualComponent(-1, 0, -1, 3));
        growthRitual.add(new RitualComponent(1, 0, -1, 3));
        ArrayList<RitualComponent> interdictionRitual = new ArrayList<RitualComponent>();
        interdictionRitual.add(new RitualComponent(1, 0, 0, 4));
        interdictionRitual.add(new RitualComponent(-1, 0, 0, 4));
        interdictionRitual.add(new RitualComponent(0, 0, 1, 4));
        interdictionRitual.add(new RitualComponent(0, 0, -1, 4));
        interdictionRitual.add(new RitualComponent(-1, 0, 1, 4));
        interdictionRitual.add(new RitualComponent(1, 0, 1, 4));
        interdictionRitual.add(new RitualComponent(-1, 0, -1, 4));
        interdictionRitual.add(new RitualComponent(1, 0, -1, 4));
        ArrayList<RitualComponent> containmentRitual = new ArrayList<RitualComponent>();
        containmentRitual.add(new RitualComponent(1, 0, 0, 3));
        containmentRitual.add(new RitualComponent(-1, 0, 0, 3));
        containmentRitual.add(new RitualComponent(0, 0, 1, 3));
        containmentRitual.add(new RitualComponent(0, 0, -1, 3));
        containmentRitual.add(new RitualComponent(2, 0, 2, 3));
        containmentRitual.add(new RitualComponent(2, 0, -2, 3));
        containmentRitual.add(new RitualComponent(-2, 0, 2, 3));
        containmentRitual.add(new RitualComponent(-2, 0, -2, 3));
        containmentRitual.add(new RitualComponent(1, 5, 0, 3));
        containmentRitual.add(new RitualComponent(-1, 5, 0, 3));
        containmentRitual.add(new RitualComponent(0, 5, 1, 3));
        containmentRitual.add(new RitualComponent(0, 5, -1, 3));
        containmentRitual.add(new RitualComponent(2, 5, 2, 3));
        containmentRitual.add(new RitualComponent(2, 5, -2, 3));
        containmentRitual.add(new RitualComponent(-2, 5, 2, 3));
        containmentRitual.add(new RitualComponent(-2, 5, -2, 3));
        ArrayList<RitualComponent> boundSoulRitual = new ArrayList<RitualComponent>();
        boundSoulRitual.add(new RitualComponent(3, 0, 0, 2));
        boundSoulRitual.add(new RitualComponent(-3, 0, 0, 2));
        boundSoulRitual.add(new RitualComponent(0, 0, 3, 2));
        boundSoulRitual.add(new RitualComponent(0, 0, -3, 2));
        boundSoulRitual.add(new RitualComponent(2, 0, 2, 4));
        boundSoulRitual.add(new RitualComponent(-2, 0, 2, 4));
        boundSoulRitual.add(new RitualComponent(2, 0, -2, 4));
        boundSoulRitual.add(new RitualComponent(-2, 0, -2, 4));
        boundSoulRitual.add(new RitualComponent(4, 2, 0, 1));
        boundSoulRitual.add(new RitualComponent(-4, 2, 0, 1));
        boundSoulRitual.add(new RitualComponent(0, 2, 4, 1));
        boundSoulRitual.add(new RitualComponent(0, 2, -4, 1));
        boundSoulRitual.add(new RitualComponent(3, 2, 3, 3));
        boundSoulRitual.add(new RitualComponent(3, 2, -3, 3));
        boundSoulRitual.add(new RitualComponent(-3, 2, 3, 3));
        boundSoulRitual.add(new RitualComponent(-3, 2, -3, 3));
        boundSoulRitual.add(new RitualComponent(4, 1, 0, 0));
        boundSoulRitual.add(new RitualComponent(-4, 1, 0, 0));
        boundSoulRitual.add(new RitualComponent(0, 1, 4, 0));
        boundSoulRitual.add(new RitualComponent(0, 1, -4, 0));
        boundSoulRitual.add(new RitualComponent(3, 1, 3, 0));
        boundSoulRitual.add(new RitualComponent(3, 1, -3, 0));
        boundSoulRitual.add(new RitualComponent(-3, 1, 3, 0));
        boundSoulRitual.add(new RitualComponent(-3, 1, -3, 0));
        ArrayList<RitualComponent> unbindingRitual = new ArrayList<RitualComponent>();
        unbindingRitual.add(new RitualComponent(-2, 0, 0, 4));
        unbindingRitual.add(new RitualComponent(2, 0, 0, 4));
        unbindingRitual.add(new RitualComponent(0, 0, 2, 4));
        unbindingRitual.add(new RitualComponent(0, 0, -2, 4));
        unbindingRitual.add(new RitualComponent(-2, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(-2, 0, -3, 3));
        unbindingRitual.add(new RitualComponent(-3, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, -3, 3));
        unbindingRitual.add(new RitualComponent(3, 0, -2, 3));
        unbindingRitual.add(new RitualComponent(-2, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(-2, 0, 3, 3));
        unbindingRitual.add(new RitualComponent(-3, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(2, 0, 3, 3));
        unbindingRitual.add(new RitualComponent(3, 0, 2, 3));
        unbindingRitual.add(new RitualComponent(3, 1, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 1, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 1, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 1, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 2, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 2, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 2, -3, 0));
        unbindingRitual.add(new RitualComponent(-3, 2, 3, 0));
        unbindingRitual.add(new RitualComponent(3, 3, 3, 2));
        unbindingRitual.add(new RitualComponent(3, 3, -3, 2));
        unbindingRitual.add(new RitualComponent(-3, 3, -3, 2));
        unbindingRitual.add(new RitualComponent(-3, 3, 3, 2));
        unbindingRitual.add(new RitualComponent(-5, 0, 0, 2));
        unbindingRitual.add(new RitualComponent(5, 0, 0, 2));
        unbindingRitual.add(new RitualComponent(0, 0, 5, 2));
        unbindingRitual.add(new RitualComponent(0, 0, -5, 2));
        ArrayList<RitualComponent> jumpingRitual = new ArrayList<RitualComponent>();
        for (int i3 = -1; i3 <= 1; ++i3) {
            jumpingRitual.add(new RitualComponent(1, i3, 1, 4));
            jumpingRitual.add(new RitualComponent(-1, i3, 1, 4));
            jumpingRitual.add(new RitualComponent(-1, i3, -1, 4));
            jumpingRitual.add(new RitualComponent(1, i3, -1, 4));
        }
        ArrayList<RitualComponent> magneticRitual = new ArrayList<RitualComponent>();
        magneticRitual.add(new RitualComponent(1, 0, 1, 3));
        magneticRitual.add(new RitualComponent(1, 0, -1, 3));
        magneticRitual.add(new RitualComponent(-1, 0, 1, 3));
        magneticRitual.add(new RitualComponent(-1, 0, -1, 3));
        magneticRitual.add(new RitualComponent(2, 1, 0, 3));
        magneticRitual.add(new RitualComponent(0, 1, 2, 3));
        magneticRitual.add(new RitualComponent(-2, 1, 0, 3));
        magneticRitual.add(new RitualComponent(0, 1, -2, 3));
        magneticRitual.add(new RitualComponent(2, 1, 2, 4));
        magneticRitual.add(new RitualComponent(2, 1, -2, 4));
        magneticRitual.add(new RitualComponent(-2, 1, 2, 4));
        magneticRitual.add(new RitualComponent(-2, 1, -2, 4));
        magneticRitual.add(new RitualComponent(2, 2, 0, 2));
        magneticRitual.add(new RitualComponent(0, 2, 2, 2));
        magneticRitual.add(new RitualComponent(-2, 2, 0, 2));
        magneticRitual.add(new RitualComponent(0, 2, -2, 2));
        ArrayList<RitualComponent> crushingRitual = new ArrayList<RitualComponent>();
        crushingRitual.add(new RitualComponent(0, 0, 1, 3));
        crushingRitual.add(new RitualComponent(1, 0, 0, 3));
        crushingRitual.add(new RitualComponent(0, 0, -1, 3));
        crushingRitual.add(new RitualComponent(-1, 0, 0, 3));
        crushingRitual.add(new RitualComponent(2, 0, 0, 2));
        crushingRitual.add(new RitualComponent(0, 0, 2, 2));
        crushingRitual.add(new RitualComponent(-2, 0, 0, 2));
        crushingRitual.add(new RitualComponent(0, 0, -2, 2));
        crushingRitual.add(new RitualComponent(2, 0, 2, 5));
        crushingRitual.add(new RitualComponent(2, 0, -2, 5));
        crushingRitual.add(new RitualComponent(-2, 0, 2, 5));
        crushingRitual.add(new RitualComponent(-2, 0, -2, 5));
        crushingRitual.add(new RitualComponent(2, 1, 0, 4));
        crushingRitual.add(new RitualComponent(-2, 1, 0, 4));
        crushingRitual.add(new RitualComponent(0, 1, 2, 4));
        crushingRitual.add(new RitualComponent(0, 1, -2, 4));
        ArrayList<RitualComponent> leapingRitual = new ArrayList<RitualComponent>();
        leapingRitual.add(new RitualComponent(0, 0, -2, 5));
        leapingRitual.add(new RitualComponent(1, 0, -1, 4));
        leapingRitual.add(new RitualComponent(-1, 0, -1, 4));
        for (int i4 = 0; i4 <= 2; ++i4) {
            leapingRitual.add(new RitualComponent(2, 0, i4, 4));
            leapingRitual.add(new RitualComponent(-2, 0, i4, 4));
        }
        ArrayList<RitualComponent> animalGrowthRitual = new ArrayList<RitualComponent>();
        animalGrowthRitual.add(new RitualComponent(0, 0, 2, 5));
        animalGrowthRitual.add(new RitualComponent(2, 0, 0, 5));
        animalGrowthRitual.add(new RitualComponent(0, 0, -2, 5));
        animalGrowthRitual.add(new RitualComponent(-2, 0, 0, 5));
        animalGrowthRitual.add(new RitualComponent(0, 0, 1, 1));
        animalGrowthRitual.add(new RitualComponent(1, 0, 0, 1));
        animalGrowthRitual.add(new RitualComponent(0, 0, -1, 1));
        animalGrowthRitual.add(new RitualComponent(-1, 0, 0, 1));
        animalGrowthRitual.add(new RitualComponent(1, 0, 2, 3));
        animalGrowthRitual.add(new RitualComponent(-1, 0, 2, 3));
        animalGrowthRitual.add(new RitualComponent(1, 0, -2, 3));
        animalGrowthRitual.add(new RitualComponent(-1, 0, -2, 3));
        animalGrowthRitual.add(new RitualComponent(2, 0, 1, 4));
        animalGrowthRitual.add(new RitualComponent(2, 0, -1, 4));
        animalGrowthRitual.add(new RitualComponent(-2, 0, 1, 4));
        animalGrowthRitual.add(new RitualComponent(-2, 0, -1, 4));
        ArrayList<RitualComponent> wellOfSufferingRitual = new ArrayList<RitualComponent>();
        wellOfSufferingRitual.add(new RitualComponent(1, 0, 1, 2));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, 1, 2));
        wellOfSufferingRitual.add(new RitualComponent(1, 0, -1, 2));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, -1, 2));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, 2, 2));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, -2, 2));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, 2, 2));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, -2, 2));
        wellOfSufferingRitual.add(new RitualComponent(0, -1, 2, 3));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, 0, 3));
        wellOfSufferingRitual.add(new RitualComponent(0, -1, -2, 3));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, 0, 3));
        wellOfSufferingRitual.add(new RitualComponent(-3, -1, -3, 5));
        wellOfSufferingRitual.add(new RitualComponent(3, -1, -3, 5));
        wellOfSufferingRitual.add(new RitualComponent(-3, -1, 3, 5));
        wellOfSufferingRitual.add(new RitualComponent(3, -1, 3, 5));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, -1, 2, 1));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, -1, -2, 1));
        wellOfSufferingRitual.add(new RitualComponent(2, -1, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, -1, 2, 1));
        wellOfSufferingRitual.add(new RitualComponent(-2, -1, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, -1, -2, 1));
        wellOfSufferingRitual.add(new RitualComponent(1, 0, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, 0, 1, 1));
        wellOfSufferingRitual.add(new RitualComponent(1, 0, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, 0, 1, 1));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, 4, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, 0, -1, 1));
        wellOfSufferingRitual.add(new RitualComponent(-1, 0, -4, 1));
        wellOfSufferingRitual.add(new RitualComponent(-4, 0, -1, 1));
        wellOfSufferingRitual.add(new RitualComponent(4, 1, 0, 4));
        wellOfSufferingRitual.add(new RitualComponent(0, 1, 4, 4));
        wellOfSufferingRitual.add(new RitualComponent(-4, 1, 0, 4));
        wellOfSufferingRitual.add(new RitualComponent(0, 1, -4, 4));
        ArrayList<RitualComponent> healingRitual = new ArrayList<RitualComponent>();
        healingRitual.add(new RitualComponent(4, 0, 0, 4));
        healingRitual.add(new RitualComponent(5, 0, -1, 4));
        healingRitual.add(new RitualComponent(5, 0, 1, 4));
        healingRitual.add(new RitualComponent(-4, 0, 0, 4));
        healingRitual.add(new RitualComponent(-5, 0, -1, 4));
        healingRitual.add(new RitualComponent(-5, 0, 1, 4));
        healingRitual.add(new RitualComponent(0, 0, 4, 2));
        healingRitual.add(new RitualComponent(-1, 0, 5, 2));
        healingRitual.add(new RitualComponent(1, 0, 5, 2));
        healingRitual.add(new RitualComponent(0, 0, -4, 2));
        healingRitual.add(new RitualComponent(-1, 0, -5, 2));
        healingRitual.add(new RitualComponent(1, 0, -5, 2));
        healingRitual.add(new RitualComponent(3, 0, 5, 1));
        healingRitual.add(new RitualComponent(5, 0, 3, 1));
        healingRitual.add(new RitualComponent(3, 0, -5, 1));
        healingRitual.add(new RitualComponent(5, 0, -3, 1));
        healingRitual.add(new RitualComponent(-3, 0, 5, 1));
        healingRitual.add(new RitualComponent(-5, 0, 3, 1));
        healingRitual.add(new RitualComponent(-3, 0, -5, 1));
        healingRitual.add(new RitualComponent(-5, 0, -3, 1));
        healingRitual.add(new RitualComponent(-3, 0, -3, 5));
        healingRitual.add(new RitualComponent(-3, 0, 3, 5));
        healingRitual.add(new RitualComponent(3, 0, -3, 5));
        healingRitual.add(new RitualComponent(3, 0, 3, 5));
        healingRitual.add(new RitualComponent(4, 0, 5, 3));
        healingRitual.add(new RitualComponent(4, -1, 5, 3));
        healingRitual.add(new RitualComponent(5, 0, 4, 3));
        healingRitual.add(new RitualComponent(5, -1, 4, 3));
        healingRitual.add(new RitualComponent(5, 0, 5, 3));
        healingRitual.add(new RitualComponent(4, 0, -5, 3));
        healingRitual.add(new RitualComponent(4, -1, -5, 3));
        healingRitual.add(new RitualComponent(5, 0, -4, 3));
        healingRitual.add(new RitualComponent(5, -1, -4, 3));
        healingRitual.add(new RitualComponent(5, 0, -5, 3));
        healingRitual.add(new RitualComponent(-4, 0, 5, 3));
        healingRitual.add(new RitualComponent(-4, -1, 5, 3));
        healingRitual.add(new RitualComponent(-5, 0, 4, 3));
        healingRitual.add(new RitualComponent(-5, -1, 4, 3));
        healingRitual.add(new RitualComponent(-5, 0, 5, 3));
        healingRitual.add(new RitualComponent(-4, 0, -5, 3));
        healingRitual.add(new RitualComponent(-4, -1, -5, 3));
        healingRitual.add(new RitualComponent(-5, 0, -4, 3));
        healingRitual.add(new RitualComponent(-5, -1, -4, 3));
        healingRitual.add(new RitualComponent(-5, 0, -5, 3));
        ArrayList<RitualComponent> featheredKnifeRitual = new ArrayList<RitualComponent>();
        featheredKnifeRitual.add(new RitualComponent(1, 0, 0, 5));
        featheredKnifeRitual.add(new RitualComponent(-1, 0, 0, 5));
        featheredKnifeRitual.add(new RitualComponent(0, 0, 1, 5));
        featheredKnifeRitual.add(new RitualComponent(0, 0, -1, 5));
        featheredKnifeRitual.add(new RitualComponent(2, -1, 0, 1));
        featheredKnifeRitual.add(new RitualComponent(-2, -1, 0, 1));
        featheredKnifeRitual.add(new RitualComponent(0, -1, 2, 1));
        featheredKnifeRitual.add(new RitualComponent(0, -1, -2, 1));
        featheredKnifeRitual.add(new RitualComponent(1, -1, 1, 4));
        featheredKnifeRitual.add(new RitualComponent(1, -1, -1, 4));
        featheredKnifeRitual.add(new RitualComponent(-1, -1, 1, 4));
        featheredKnifeRitual.add(new RitualComponent(-1, -1, -1, 4));
        featheredKnifeRitual.add(new RitualComponent(4, -1, 2, 2));
        featheredKnifeRitual.add(new RitualComponent(2, -1, 4, 2));
        featheredKnifeRitual.add(new RitualComponent(-4, -1, 2, 2));
        featheredKnifeRitual.add(new RitualComponent(2, -1, -4, 2));
        featheredKnifeRitual.add(new RitualComponent(4, -1, -2, 2));
        featheredKnifeRitual.add(new RitualComponent(-2, -1, 4, 2));
        featheredKnifeRitual.add(new RitualComponent(-4, -1, -2, 2));
        featheredKnifeRitual.add(new RitualComponent(-2, -1, -4, 2));
        featheredKnifeRitual.add(new RitualComponent(4, 0, 2, 3));
        featheredKnifeRitual.add(new RitualComponent(2, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, 2, 3));
        featheredKnifeRitual.add(new RitualComponent(2, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(4, 0, -2, 3));
        featheredKnifeRitual.add(new RitualComponent(-2, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, -2, 3));
        featheredKnifeRitual.add(new RitualComponent(-2, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(4, 0, 3, 3));
        featheredKnifeRitual.add(new RitualComponent(3, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, 3, 3));
        featheredKnifeRitual.add(new RitualComponent(3, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(4, 0, -3, 3));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, 4, 3));
        featheredKnifeRitual.add(new RitualComponent(-4, 0, -3, 3));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, -4, 3));
        featheredKnifeRitual.add(new RitualComponent(3, 0, 3, 4));
        featheredKnifeRitual.add(new RitualComponent(3, 0, -3, 4));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, 3, 4));
        featheredKnifeRitual.add(new RitualComponent(-3, 0, -3, 4));
        ArrayList<RitualComponent> featheredEarthRitual = new ArrayList<RitualComponent>();
        featheredEarthRitual.add(new RitualComponent(1, 0, 0, 5));
        featheredEarthRitual.add(new RitualComponent(-1, 0, 0, 5));
        featheredEarthRitual.add(new RitualComponent(0, 0, 1, 5));
        featheredEarthRitual.add(new RitualComponent(0, 0, -1, 5));
        featheredEarthRitual.add(new RitualComponent(2, 0, 2, 4));
        featheredEarthRitual.add(new RitualComponent(-2, 0, 2, 4));
        featheredEarthRitual.add(new RitualComponent(-2, 0, -2, 4));
        featheredEarthRitual.add(new RitualComponent(2, 0, -2, 4));
        featheredEarthRitual.add(new RitualComponent(1, 0, 3, 3));
        featheredEarthRitual.add(new RitualComponent(0, 0, 3, 3));
        featheredEarthRitual.add(new RitualComponent(-1, 0, 3, 3));
        featheredEarthRitual.add(new RitualComponent(1, 0, -3, 3));
        featheredEarthRitual.add(new RitualComponent(0, 0, -3, 3));
        featheredEarthRitual.add(new RitualComponent(-1, 0, -3, 3));
        featheredEarthRitual.add(new RitualComponent(3, 0, 1, 3));
        featheredEarthRitual.add(new RitualComponent(3, 0, 0, 3));
        featheredEarthRitual.add(new RitualComponent(3, 0, -1, 3));
        featheredEarthRitual.add(new RitualComponent(-3, 0, 1, 3));
        featheredEarthRitual.add(new RitualComponent(-3, 0, 0, 3));
        featheredEarthRitual.add(new RitualComponent(-3, 0, -1, 3));
        featheredEarthRitual.add(new RitualComponent(4, 4, 4, 2));
        featheredEarthRitual.add(new RitualComponent(-4, 4, 4, 2));
        featheredEarthRitual.add(new RitualComponent(-4, 4, -4, 2));
        featheredEarthRitual.add(new RitualComponent(4, 4, -4, 2));
        featheredEarthRitual.add(new RitualComponent(4, 5, 5, 4));
        featheredEarthRitual.add(new RitualComponent(4, 5, 3, 4));
        featheredEarthRitual.add(new RitualComponent(5, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(3, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, 5, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, 3, 4));
        featheredEarthRitual.add(new RitualComponent(-5, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(-3, 5, 4, 4));
        featheredEarthRitual.add(new RitualComponent(4, 5, -5, 4));
        featheredEarthRitual.add(new RitualComponent(4, 5, -3, 4));
        featheredEarthRitual.add(new RitualComponent(5, 5, -4, 4));
        featheredEarthRitual.add(new RitualComponent(3, 5, -4, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, -5, 4));
        featheredEarthRitual.add(new RitualComponent(-4, 5, -3, 4));
        featheredEarthRitual.add(new RitualComponent(-5, 5, -4, 4));
        featheredEarthRitual.add(new RitualComponent(-3, 5, -4, 4));
        ArrayList<RitualComponent> biomeChangerRitual = new ArrayList<RitualComponent>();
        biomeChangerRitual.add(new RitualComponent(1, 0, -2, 4));
        biomeChangerRitual.add(new RitualComponent(1, 0, -3, 4));
        biomeChangerRitual.add(new RitualComponent(2, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(3, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(1, 0, 2, 4));
        biomeChangerRitual.add(new RitualComponent(1, 0, 3, 4));
        biomeChangerRitual.add(new RitualComponent(2, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(3, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -2, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -3, 4));
        biomeChangerRitual.add(new RitualComponent(-2, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(-3, 0, -1, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 2, 4));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 3, 4));
        biomeChangerRitual.add(new RitualComponent(-2, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(-3, 0, 1, 4));
        biomeChangerRitual.add(new RitualComponent(3, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(3, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, -5, 2));
        biomeChangerRitual.add(new RitualComponent(5, 0, -4, 2));
        biomeChangerRitual.add(new RitualComponent(3, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(3, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, 5, 2));
        biomeChangerRitual.add(new RitualComponent(5, 0, 4, 2));
        biomeChangerRitual.add(new RitualComponent(-3, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(-3, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 3, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 5, 2));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 4, 2));
        biomeChangerRitual.add(new RitualComponent(-3, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(-3, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -3, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -5, 2));
        biomeChangerRitual.add(new RitualComponent(-5, 0, -4, 2));
        biomeChangerRitual.add(new RitualComponent(0, 0, -5, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -6, 1));
        biomeChangerRitual.add(new RitualComponent(1, 0, -6, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -8, 0));
        biomeChangerRitual.add(new RitualComponent(0, 0, -8, 0));
        biomeChangerRitual.add(new RitualComponent(1, 0, -8, 0));
        biomeChangerRitual.add(new RitualComponent(-1, 0, -10, 5));
        biomeChangerRitual.add(new RitualComponent(0, 0, -10, 5));
        biomeChangerRitual.add(new RitualComponent(1, 0, -10, 5));
        biomeChangerRitual.add(new RitualComponent(0, 0, 5, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 6, 1));
        biomeChangerRitual.add(new RitualComponent(1, 0, 6, 1));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 8, 0));
        biomeChangerRitual.add(new RitualComponent(0, 0, 8, 0));
        biomeChangerRitual.add(new RitualComponent(1, 0, 8, 0));
        biomeChangerRitual.add(new RitualComponent(-1, 0, 10, 5));
        biomeChangerRitual.add(new RitualComponent(0, 0, 10, 5));
        biomeChangerRitual.add(new RitualComponent(1, 0, 10, 5));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 0, 1));
        biomeChangerRitual.add(new RitualComponent(-6, 0, -1, 1));
        biomeChangerRitual.add(new RitualComponent(-6, 0, 1, 1));
        biomeChangerRitual.add(new RitualComponent(-8, 0, -1, 0));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 0, 0));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 1, 0));
        biomeChangerRitual.add(new RitualComponent(-10, 0, -1, 5));
        biomeChangerRitual.add(new RitualComponent(-10, 0, 0, 5));
        biomeChangerRitual.add(new RitualComponent(-10, 0, 1, 5));
        biomeChangerRitual.add(new RitualComponent(5, 0, 0, 1));
        biomeChangerRitual.add(new RitualComponent(6, 0, -1, 1));
        biomeChangerRitual.add(new RitualComponent(6, 0, 1, 1));
        biomeChangerRitual.add(new RitualComponent(8, 0, -1, 0));
        biomeChangerRitual.add(new RitualComponent(8, 0, 0, 0));
        biomeChangerRitual.add(new RitualComponent(8, 0, 1, 0));
        biomeChangerRitual.add(new RitualComponent(10, 0, -1, 5));
        biomeChangerRitual.add(new RitualComponent(10, 0, 0, 5));
        biomeChangerRitual.add(new RitualComponent(10, 0, 1, 5));
        biomeChangerRitual.add(new RitualComponent(6, 0, -6, 4));
        biomeChangerRitual.add(new RitualComponent(6, 0, -7, 4));
        biomeChangerRitual.add(new RitualComponent(7, 0, -6, 4));
        biomeChangerRitual.add(new RitualComponent(7, 0, -5, 3));
        biomeChangerRitual.add(new RitualComponent(5, 0, -7, 3));
        biomeChangerRitual.add(new RitualComponent(8, 0, -5, 5));
        biomeChangerRitual.add(new RitualComponent(8, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(9, 0, -4, 3));
        biomeChangerRitual.add(new RitualComponent(5, 0, -8, 5));
        biomeChangerRitual.add(new RitualComponent(4, 0, -8, 3));
        biomeChangerRitual.add(new RitualComponent(4, 0, -9, 3));
        biomeChangerRitual.add(new RitualComponent(-6, 0, 6, 4));
        biomeChangerRitual.add(new RitualComponent(-6, 0, 7, 4));
        biomeChangerRitual.add(new RitualComponent(-7, 0, 6, 4));
        biomeChangerRitual.add(new RitualComponent(-7, 0, 5, 3));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 7, 3));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 5, 5));
        biomeChangerRitual.add(new RitualComponent(-8, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(-9, 0, 4, 3));
        biomeChangerRitual.add(new RitualComponent(-5, 0, 8, 5));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 8, 3));
        biomeChangerRitual.add(new RitualComponent(-4, 0, 9, 3));
        biomeChangerRitual.add(new RitualComponent(6, 0, 6, 2));
        biomeChangerRitual.add(new RitualComponent(6, 0, 7, 2));
        biomeChangerRitual.add(new RitualComponent(7, 0, 6, 2));
        biomeChangerRitual.add(new RitualComponent(7, 0, 5, 1));
        biomeChangerRitual.add(new RitualComponent(5, 0, 7, 1));
        biomeChangerRitual.add(new RitualComponent(8, 0, 5, 5));
        biomeChangerRitual.add(new RitualComponent(8, 0, 4, 1));
        biomeChangerRitual.add(new RitualComponent(9, 0, 4, 1));
        biomeChangerRitual.add(new RitualComponent(5, 0, 8, 5));
        biomeChangerRitual.add(new RitualComponent(4, 0, 8, 1));
        biomeChangerRitual.add(new RitualComponent(4, 0, 9, 1));
        biomeChangerRitual.add(new RitualComponent(-6, 0, -6, 2));
        biomeChangerRitual.add(new RitualComponent(-6, 0, -7, 2));
        biomeChangerRitual.add(new RitualComponent(-7, 0, -6, 2));
        biomeChangerRitual.add(new RitualComponent(-7, 0, -5, 1));
        biomeChangerRitual.add(new RitualComponent(-5, 0, -7, 1));
        biomeChangerRitual.add(new RitualComponent(-8, 0, -5, 5));
        biomeChangerRitual.add(new RitualComponent(-8, 0, -4, 1));
        biomeChangerRitual.add(new RitualComponent(-9, 0, -4, 1));
        biomeChangerRitual.add(new RitualComponent(-5, 0, -8, 5));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -8, 1));
        biomeChangerRitual.add(new RitualComponent(-4, 0, -9, 1));
        ArrayList<RitualComponent> flightRitual = new ArrayList<RitualComponent>();
        flightRitual.add(new RitualComponent(1, 0, 0, 5));
        flightRitual.add(new RitualComponent(-1, 0, 0, 5));
        flightRitual.add(new RitualComponent(0, 0, 1, 5));
        flightRitual.add(new RitualComponent(0, 0, -1, 5));
        flightRitual.add(new RitualComponent(2, 0, 2, 4));
        flightRitual.add(new RitualComponent(-2, 0, 2, 4));
        flightRitual.add(new RitualComponent(-2, 0, -2, 4));
        flightRitual.add(new RitualComponent(2, 0, -2, 4));
        flightRitual.add(new RitualComponent(1, 0, 3, 3));
        flightRitual.add(new RitualComponent(0, 0, 3, 3));
        flightRitual.add(new RitualComponent(-1, 0, 3, 3));
        flightRitual.add(new RitualComponent(1, 0, -3, 3));
        flightRitual.add(new RitualComponent(0, 0, -3, 3));
        flightRitual.add(new RitualComponent(-1, 0, -3, 3));
        flightRitual.add(new RitualComponent(3, 0, 1, 3));
        flightRitual.add(new RitualComponent(3, 0, 0, 3));
        flightRitual.add(new RitualComponent(3, 0, -1, 3));
        flightRitual.add(new RitualComponent(-3, 0, 1, 3));
        flightRitual.add(new RitualComponent(-3, 0, 0, 3));
        flightRitual.add(new RitualComponent(-3, 0, -1, 3));
        flightRitual.add(new RitualComponent(-3, 0, -4, 1));
        flightRitual.add(new RitualComponent(-4, 0, -3, 1));
        flightRitual.add(new RitualComponent(-3, 0, 4, 1));
        flightRitual.add(new RitualComponent(4, 0, -3, 1));
        flightRitual.add(new RitualComponent(3, 0, -4, 1));
        flightRitual.add(new RitualComponent(-4, 0, 3, 1));
        flightRitual.add(new RitualComponent(3, 0, 4, 1));
        flightRitual.add(new RitualComponent(4, 0, 3, 1));
        flightRitual.add(new RitualComponent(-1, 1, 0, 2));
        flightRitual.add(new RitualComponent(1, 1, 0, 2));
        flightRitual.add(new RitualComponent(0, 1, -1, 2));
        flightRitual.add(new RitualComponent(0, 1, 1, 2));
        flightRitual.add(new RitualComponent(-2, 1, 0, 0));
        flightRitual.add(new RitualComponent(2, 1, 0, 0));
        flightRitual.add(new RitualComponent(0, 1, -2, 0));
        flightRitual.add(new RitualComponent(0, 1, 2, 0));
        flightRitual.add(new RitualComponent(-4, 1, 0, 0));
        flightRitual.add(new RitualComponent(4, 1, 0, 0));
        flightRitual.add(new RitualComponent(0, 1, -4, 0));
        flightRitual.add(new RitualComponent(0, 1, 4, 0));
        flightRitual.add(new RitualComponent(-5, 1, 0, 4));
        flightRitual.add(new RitualComponent(5, 1, 0, 4));
        flightRitual.add(new RitualComponent(0, 1, -5, 4));
        flightRitual.add(new RitualComponent(0, 1, 5, 4));
        flightRitual.add(new RitualComponent(5, 0, 0, 5));
        flightRitual.add(new RitualComponent(-5, 0, 0, 5));
        flightRitual.add(new RitualComponent(0, 0, 5, 5));
        flightRitual.add(new RitualComponent(0, 0, -5, 5));
        for (i2 = 2; i2 <= 4; ++i2) {
            flightRitual.add(new RitualComponent(-i2, 2, 0, 3));
            flightRitual.add(new RitualComponent(i2, 2, 0, 3));
            flightRitual.add(new RitualComponent(0, 2, -i2, 3));
            flightRitual.add(new RitualComponent(0, 2, i2, 3));
        }
        flightRitual.add(new RitualComponent(2, 4, 1, 2));
        flightRitual.add(new RitualComponent(1, 4, 2, 2));
        flightRitual.add(new RitualComponent(-2, 4, 1, 2));
        flightRitual.add(new RitualComponent(1, 4, -2, 2));
        flightRitual.add(new RitualComponent(2, 4, -1, 2));
        flightRitual.add(new RitualComponent(-1, 4, 2, 2));
        flightRitual.add(new RitualComponent(-2, 4, -1, 2));
        flightRitual.add(new RitualComponent(-1, 4, -2, 2));
        flightRitual.add(new RitualComponent(2, 4, 2, 4));
        flightRitual.add(new RitualComponent(-2, 4, 2, 4));
        flightRitual.add(new RitualComponent(2, 4, -2, 4));
        flightRitual.add(new RitualComponent(-2, 4, -2, 4));
        flightRitual.add(new RitualComponent(-4, 2, -4, 2));
        flightRitual.add(new RitualComponent(4, 2, 4, 2));
        flightRitual.add(new RitualComponent(4, 2, -4, 2));
        flightRitual.add(new RitualComponent(-4, 2, 4, 2));
        for (i2 = -1; i2 <= 1; ++i2) {
            flightRitual.add(new RitualComponent(3, 4, i2, 3));
            flightRitual.add(new RitualComponent(-3, 4, i2, 3));
            flightRitual.add(new RitualComponent(i2, 4, 3, 3));
            flightRitual.add(new RitualComponent(i2, 4, -3, 3));
        }
        ArrayList<RitualComponent> meteorRitual = new ArrayList<RitualComponent>();
        meteorRitual.add(new RitualComponent(2, 0, 0, 2));
        meteorRitual.add(new RitualComponent(-2, 0, 0, 2));
        meteorRitual.add(new RitualComponent(0, 0, 2, 2));
        meteorRitual.add(new RitualComponent(0, 0, -2, 2));
        meteorRitual.add(new RitualComponent(3, 0, 1, 4));
        meteorRitual.add(new RitualComponent(3, 0, -1, 4));
        meteorRitual.add(new RitualComponent(-3, 0, 1, 4));
        meteorRitual.add(new RitualComponent(-3, 0, -1, 4));
        meteorRitual.add(new RitualComponent(1, 0, 3, 4));
        meteorRitual.add(new RitualComponent(-1, 0, 3, 4));
        meteorRitual.add(new RitualComponent(1, 0, -3, 4));
        meteorRitual.add(new RitualComponent(-1, 0, -3, 4));
        meteorRitual.add(new RitualComponent(4, 0, 2, 4));
        meteorRitual.add(new RitualComponent(4, 0, -2, 4));
        meteorRitual.add(new RitualComponent(-4, 0, 2, 4));
        meteorRitual.add(new RitualComponent(-4, 0, -2, 4));
        meteorRitual.add(new RitualComponent(2, 0, 4, 4));
        meteorRitual.add(new RitualComponent(-2, 0, 4, 4));
        meteorRitual.add(new RitualComponent(2, 0, -4, 4));
        meteorRitual.add(new RitualComponent(-2, 0, -4, 4));
        meteorRitual.add(new RitualComponent(5, 0, 3, 5));
        meteorRitual.add(new RitualComponent(5, 0, -3, 5));
        meteorRitual.add(new RitualComponent(-5, 0, 3, 5));
        meteorRitual.add(new RitualComponent(-5, 0, -3, 5));
        meteorRitual.add(new RitualComponent(3, 0, 5, 5));
        meteorRitual.add(new RitualComponent(-3, 0, 5, 5));
        meteorRitual.add(new RitualComponent(3, 0, -5, 5));
        meteorRitual.add(new RitualComponent(-3, 0, -5, 5));
        meteorRitual.add(new RitualComponent(-4, 0, -4, 5));
        meteorRitual.add(new RitualComponent(-4, 0, 4, 5));
        meteorRitual.add(new RitualComponent(4, 0, 4, 5));
        meteorRitual.add(new RitualComponent(4, 0, -4, 5));
        for (i = 4; i <= 6; ++i) {
            meteorRitual.add(new RitualComponent(i, 0, 0, 3));
            meteorRitual.add(new RitualComponent(-i, 0, 0, 3));
            meteorRitual.add(new RitualComponent(0, 0, i, 3));
            meteorRitual.add(new RitualComponent(0, 0, -i, 3));
        }
        meteorRitual.add(new RitualComponent(8, 0, 0, 3));
        meteorRitual.add(new RitualComponent(-8, 0, 0, 3));
        meteorRitual.add(new RitualComponent(0, 0, 8, 3));
        meteorRitual.add(new RitualComponent(0, 0, -8, 3));
        meteorRitual.add(new RitualComponent(8, 1, 0, 3));
        meteorRitual.add(new RitualComponent(-8, 1, 0, 3));
        meteorRitual.add(new RitualComponent(0, 1, 8, 3));
        meteorRitual.add(new RitualComponent(0, 1, -8, 3));
        meteorRitual.add(new RitualComponent(7, 1, 0, 3));
        meteorRitual.add(new RitualComponent(-7, 1, 0, 3));
        meteorRitual.add(new RitualComponent(0, 1, 7, 3));
        meteorRitual.add(new RitualComponent(0, 1, -7, 3));
        meteorRitual.add(new RitualComponent(7, 2, 0, 2));
        meteorRitual.add(new RitualComponent(-7, 2, 0, 2));
        meteorRitual.add(new RitualComponent(0, 2, 7, 2));
        meteorRitual.add(new RitualComponent(0, 2, -7, 2));
        meteorRitual.add(new RitualComponent(6, 2, 0, 2));
        meteorRitual.add(new RitualComponent(-6, 2, 0, 2));
        meteorRitual.add(new RitualComponent(0, 2, 6, 2));
        meteorRitual.add(new RitualComponent(0, 2, -6, 2));
        meteorRitual.add(new RitualComponent(6, 3, 0, 1));
        meteorRitual.add(new RitualComponent(-6, 3, 0, 1));
        meteorRitual.add(new RitualComponent(0, 3, 6, 1));
        meteorRitual.add(new RitualComponent(0, 3, -6, 1));
        meteorRitual.add(new RitualComponent(5, 3, 0, 1));
        meteorRitual.add(new RitualComponent(-5, 3, 0, 1));
        meteorRitual.add(new RitualComponent(0, 3, 5, 1));
        meteorRitual.add(new RitualComponent(0, 3, -5, 1));
        meteorRitual.add(new RitualComponent(5, 4, 0, 4));
        meteorRitual.add(new RitualComponent(-5, 4, 0, 4));
        meteorRitual.add(new RitualComponent(0, 4, 5, 4));
        meteorRitual.add(new RitualComponent(0, 4, -5, 4));
        for (i = -1; i <= 1; ++i) {
            meteorRitual.add(new RitualComponent(i, 4, 4, 4));
            meteorRitual.add(new RitualComponent(i, 4, -4, 4));
            meteorRitual.add(new RitualComponent(4, 4, i, 4));
            meteorRitual.add(new RitualComponent(-4, 4, i, 4));
        }
        meteorRitual.add(new RitualComponent(2, 4, 4, 1));
        meteorRitual.add(new RitualComponent(4, 4, 2, 1));
        meteorRitual.add(new RitualComponent(2, 4, -4, 1));
        meteorRitual.add(new RitualComponent(-4, 4, 2, 1));
        meteorRitual.add(new RitualComponent(-2, 4, 4, 1));
        meteorRitual.add(new RitualComponent(4, 4, -2, 1));
        meteorRitual.add(new RitualComponent(-2, 4, -4, 1));
        meteorRitual.add(new RitualComponent(-4, 4, -2, 1));
        meteorRitual.add(new RitualComponent(2, 4, 3, 2));
        meteorRitual.add(new RitualComponent(3, 4, 2, 2));
        meteorRitual.add(new RitualComponent(3, 4, 3, 2));
        meteorRitual.add(new RitualComponent(-2, 4, 3, 2));
        meteorRitual.add(new RitualComponent(3, 4, -2, 2));
        meteorRitual.add(new RitualComponent(3, 4, -3, 2));
        meteorRitual.add(new RitualComponent(2, 4, -3, 2));
        meteorRitual.add(new RitualComponent(-3, 4, 2, 2));
        meteorRitual.add(new RitualComponent(-3, 4, 3, 2));
        meteorRitual.add(new RitualComponent(-2, 4, -3, 2));
        meteorRitual.add(new RitualComponent(-3, 4, -2, 2));
        meteorRitual.add(new RitualComponent(-3, 4, -3, 2));
        ArrayList<RitualComponent> apiaryRitual = new ArrayList<RitualComponent>();
        apiaryRitual.add(new RitualComponent(1, 0, 0, 5));
        apiaryRitual.add(new RitualComponent(1, 0, 1, 5));
        apiaryRitual.add(new RitualComponent(1, 0, -1, 5));
        apiaryRitual.add(new RitualComponent(-1, 0, -1, 5));
        apiaryRitual.add(new RitualComponent(-1, 0, 1, 5));
        apiaryRitual.add(new RitualComponent(-1, 0, 0, 5));
        apiaryRitual.add(new RitualComponent(0, 0, -1, 5));
        apiaryRitual.add(new RitualComponent(0, 0, 1, 5));
        ritualList.add(new Rituals(waterRitual, 1, 500, new RitualEffectWater(), "Ritual of the Full Spring"));
        ritualList.add(new Rituals(lavaRitual, 1, 10000, new RitualEffectLava(), "Serenade of the Nether"));
        ritualList.add(new Rituals(growthRitual, 1, 1000, new RitualEffectGrowth(), "Ritual of the Green Grove"));
        ritualList.add(new Rituals(interdictionRitual, 1, 1000, new RitualEffectInterdiction(), "Interdiction Ritual"));
        ritualList.add(new Rituals(containmentRitual, 1, 2000, new RitualEffectContainment(), "Ritual of Containment"));
        ritualList.add(new Rituals(boundSoulRitual, 1, 5000, new RitualEffectSoulBound(), "Ritual of Binding"));
        ritualList.add(new Rituals(unbindingRitual, 1, 30000, new RitualEffectUnbinding(), "Ritual of Unbinding"));
        ritualList.add(new Rituals(jumpingRitual, 1, 1000, new RitualEffectJumping(), "Ritual of the High Jump"));
        ritualList.add(new Rituals(magneticRitual, 1, 5000, new RitualEffectMagnetic(), "Ritual of Magnetism"));
        ritualList.add(new Rituals(crushingRitual, 1, 2500, new RitualEffectCrushing(), "Ritual of the Crusher"));
        ritualList.add(new Rituals(leapingRitual, 1, 1000, new RitualEffectLeap(), "Ritual of Speed"));
        ritualList.add(new Rituals(animalGrowthRitual, 1, 10000, new RitualEffectAnimalGrowth(), "Ritual of the Shepherd"));
        ritualList.add(new Rituals(wellOfSufferingRitual, 1, 50000, new RitualEffectWellOfSuffering(), "Well of Suffering"));
        ritualList.add(new Rituals(healingRitual, 1, 25000, new RitualEffectHealing(), "Ritual of Regeneration"));
        ritualList.add(new Rituals(featheredKnifeRitual, 1, 50000, new RitualEffectFeatheredKnife(), "Ritual of the Feathered Knife"));
        ritualList.add(new Rituals(featheredEarthRitual, 2, 100000, new RitualEffectFeatheredEarth(), "Ritual of the Feathered Earth"));
        ritualList.add(new Rituals(biomeChangerRitual, 2, 1000000, new RitualEffectBiomeChanger(), "Ritual of Gaia's Transformation"));
        ritualList.add(new Rituals(flightRitual, 2, 1000000, new RitualEffectFlight(), "Reverence of the Condor"));
        ritualList.add(new Rituals(meteorRitual, 2, 1000000, new RitualEffectSummonMeteor(), "Mark of the Falling Tower"));
        ritualList.add(new Rituals(apiaryRitual, 1, 100, new RitualEffectApiaryOverclock(), "Apiary Overclock"));
    }

    public static int getCostForActivation(int ritualID) {
        if (ritualID <= ritualList.size()) {
            return Rituals.ritualList.get((int)(ritualID - 1)).actCost;
        }
        return 0;
    }

    public static int getInitialCooldown(int ritualID) {
        RitualEffect ef;
        if (ritualID <= ritualList.size() && (ef = Rituals.ritualList.get((int)(ritualID - 1)).effect) != null) {
            return ef.getInitialCooldown();
        }
        return 0;
    }

    public static List<RitualComponent> getRitualList(int ritualID) {
        if (ritualID <= ritualList.size()) {
            return ritualList.get(ritualID - 1).obtainComponents();
        }
        return null;
    }

    private List<RitualComponent> obtainComponents() {
        return this.components;
    }

    private int getCrystalLevel() {
        return this.crystalLevel;
    }

    public static void performEffect(TEMasterStone ritualStone, int ritualID) {
        RitualEffect ef;
        if (ritualID <= ritualList.size() && (ef = Rituals.ritualList.get((int)(ritualID - 1)).effect) != null) {
            ef.performEffect(ritualStone);
        }
    }

    public static int getNumberOfRituals() {
        return ritualList.size();
    }

    public String getRitualName() {
        return this.name;
    }

    public static String getNameOfRitual(int id) {
        if (ritualList.get(id) != null) {
            return ritualList.get(id).getRitualName();
        }
        return "";
    }
}

