/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.common.LifeEssenceNetwork;
import WayofTime.alchemicalWizardry.common.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import WayofTime.alchemicalWizardry.common.tileEntity.TEPlinth;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class RitualEffectBiomeChanger
extends RitualEffect {
    @Override
    public void performEffect(TEMasterStone ritualStone) {
        int cooldown;
        WorldServer worldSave = MinecraftServer.func_71276_C().field_71305_c[0];
        String owner = ritualStone.getOwner();
        LifeEssenceNetwork data = (LifeEssenceNetwork)worldSave.func_72943_a(LifeEssenceNetwork.class, owner);
        if (data == null) {
            data = new LifeEssenceNetwork(owner);
            worldSave.func_72823_a(owner, (WorldSavedData)data);
        }
        if ((cooldown = ritualStone.getCooldown()) > 0) {
            ritualStone.setCooldown(cooldown - 1);
            if (ritualStone.func_145831_w().field_73012_v.nextInt(15) == 0) {
                ritualStone.func_145831_w().func_72942_c((Entity)new EntityLightningBolt(ritualStone.func_145831_w(), (double)(ritualStone.field_145851_c - 1 + ritualStone.func_145831_w().field_73012_v.nextInt(3)), (double)(ritualStone.field_145848_d + 1), (double)(ritualStone.field_145849_e - 1 + ritualStone.func_145831_w().field_73012_v.nextInt(3))));
            }
            return;
        }
        int currentEssence = data.currentEssence;
        World world = ritualStone.func_145831_w();
        int x = ritualStone.field_145851_c;
        int y = ritualStone.field_145848_d;
        int z = ritualStone.field_145849_e;
        int range = 10;
        if (currentEssence < this.getCostPerRefresh()) {
            EntityPlayerMP entityOwner = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(owner);
            if (entityOwner == null) {
                return;
            }
            entityOwner.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 80));
        } else {
            boolean[][] boolList = new boolean[range * 2 + 1][range * 2 + 1];
            for (int i = 0; i < 2 * range + 1; ++i) {
                for (int j = 0; j < 2 * range + 1; ++j) {
                    boolList[i][j] = false;
                }
            }
            boolList[range][range] = true;
            boolean isReady = false;
            while (!isReady) {
                isReady = true;
                for (int i = 0; i < 2 * range + 1; ++i) {
                    for (int j = 0; j < 2 * range + 1; ++j) {
                        Block block;
                        if (!boolList[i][j]) continue;
                        if (!(i - 1 < 0 || boolList[i - 1][j] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i - 1, y + 1, z - range + j)) || ModBlocks.bloodStoneBrick.equals(block))) {
                            boolList[i - 1][j] = true;
                            isReady = false;
                        }
                        if (!(j - 1 < 0 || boolList[i][j - 1] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i, y + 1, z - range + j - 1)) || ModBlocks.bloodStoneBrick.equals(block))) {
                            boolList[i][j - 1] = true;
                            isReady = false;
                        }
                        if (!(i + 1 > 2 * range || boolList[i + 1][j] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i + 1, y + 1, z - range + j)) || ModBlocks.bloodStoneBrick.equals(block))) {
                            boolList[i + 1][j] = true;
                            isReady = false;
                        }
                        if (j + 1 > 2 * range || boolList[i][j + 1] || ModBlocks.largeBloodStoneBrick.equals(block = world.func_147439_a(x - range + i, y + 1, z - range + j + 1)) || ModBlocks.bloodStoneBrick.equals(block)) continue;
                        boolList[i][j + 1] = true;
                        isReady = false;
                    }
                }
            }
            float temperature = 0.5f;
            float humidity = 0.5f;
            float acceptableRange = 0.1f;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    Item itemTest;
                    if (i == 0 && j == 0) continue;
                    boolean isItemConsumed = false;
                    TileEntity tileEntity = world.func_147438_o(x + i, y, z + j);
                    if (!(tileEntity instanceof TEPlinth)) continue;
                    TEPlinth tilePlinth = (TEPlinth)tileEntity;
                    ItemStack itemStack = tilePlinth.func_70301_a(0);
                    if (itemStack != null && (itemTest = itemStack.func_77973_b()) != null) {
                        if (itemTest instanceof ItemBlock) {
                            Block item = ((ItemBlock)itemTest).field_150939_a;
                            if (item == Blocks.field_150354_m) {
                                humidity -= 0.1f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150368_y) {
                                humidity += 0.4f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150354_m) {
                                humidity -= 0.1f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150322_A) {
                                humidity -= 0.2f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150424_aL) {
                                humidity -= 0.4f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150402_ci) {
                                temperature += 0.2f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150432_aD) {
                                temperature -= 0.4f;
                                isItemConsumed = true;
                            } else if (item == Blocks.field_150433_aE) {
                                temperature -= 0.2f;
                                isItemConsumed = true;
                            }
                        } else if (itemTest.equals(Items.field_151100_aR) && itemStack.func_77960_j() == 4) {
                            humidity += 0.1f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151129_at)) {
                            temperature += 0.4f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151131_as)) {
                            humidity += 0.2f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151044_h)) {
                            temperature += 0.1f;
                            isItemConsumed = true;
                        } else if (itemTest.equals(Items.field_151126_ay)) {
                            temperature -= 0.1f;
                            isItemConsumed = true;
                        }
                    }
                    if (!isItemConsumed) continue;
                    tilePlinth.func_70299_a(0, null);
                    world.func_147471_g(x + i, y, z + j);
                    world.func_72942_c((Entity)new EntityLightningBolt(world, (double)(x + i), (double)(y + 1), (double)(z + j)));
                }
            }
            boolean wantsSnow = false;
            boolean wantsRain = true;
            int biomeID = 1;
            BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
            int iteration = 0;
            for (BiomeGenBase biome : biomeList) {
                if (biome == null) continue;
                float temp = biome.field_76750_F;
                float rainfall = biome.field_76751_G;
                temperature = Math.min(2.0f, Math.max(0.0f, temperature));
                if (Math.abs(rainfall - (humidity = Math.min(2.0f, Math.max(0.0f, humidity)))) < acceptableRange && Math.abs(temperature - temp) < acceptableRange) {
                    biomeID = iteration;
                    break;
                }
                ++iteration;
            }
            for (int i = 0; i < 2 * range + 1; ++i) {
                for (int j = 0; j < 2 * range + 1; ++j) {
                    if (!boolList[i][j]) continue;
                    Chunk chunk = world.func_72938_d(x - range + i, z - range + j);
                    byte[] byteArray = chunk.func_76605_m();
                    int moduX = (x - range + i) % 16;
                    int moduZ = (z - range + j) % 16;
                    if (moduX < 0) {
                        moduX += 16;
                    }
                    if (moduZ < 0) {
                        moduZ += 16;
                    }
                    byteArray[moduZ * 16 + moduX] = (byte)biomeID;
                    chunk.func_76616_a(byteArray);
                }
            }
            data.currentEssence = currentEssence - this.getCostPerRefresh();
            data.func_76185_a();
            ritualStone.setActive(false);
        }
    }

    @Override
    public int getCostPerRefresh() {
        return 0;
    }

    @Override
    public int getInitialCooldown() {
        return 200;
    }
}

