/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.ArmourUpgrade;
import WayofTime.alchemicalWizardry.common.IBindable;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;

@Optional.InterfaceList(value={@Optional.Interface(iface="IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="IGoggles", modid="Thaumcraft")})
public class BoundArmour
extends ItemArmor
implements ISpecialArmor,
IBindable {
    private static int invSize = 9;
    private static IIcon helmetIcon;
    private static IIcon plateIcon;
    private static IIcon leggingsIcon;
    private static IIcon bootsIcon;

    public BoundArmour(int armorType) {
        super(ItemArmor.ArmorMaterial.GOLD, 0, armorType);
        this.func_77656_e(1000);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
        helmetIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundHelmet");
        plateIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundPlate");
        leggingsIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundLeggings");
        bootsIcon = iconRegister.func_94245_a("AlchemicalWizardry:BoundBoots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (this.equals(ModItems.boundHelmet)) {
            return helmetIcon;
        }
        if (this.equals(ModItems.boundPlate)) {
            return plateIcon;
        }
        if (this.equals(ModItems.boundLeggings)) {
            return leggingsIcon;
        }
        if (this.equals(ModItems.boundBoots)) {
            return bootsIcon;
        }
        return this.field_77791_bV;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.equals(DamageSource.field_76369_e)) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (source.equals(DamageSource.field_76380_i)) {
            if (this.isImmuneToVoid(armor)) {
                return new ISpecialArmor.ArmorProperties(-1, 3.0, 100000);
            }
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        ItemStack helmet = player.func_71124_b(4);
        ItemStack plate = player.func_71124_b(3);
        ItemStack leggings = player.func_71124_b(2);
        ItemStack boots = player.func_71124_b(1);
        if (helmet == null || plate == null || leggings == null || boots == null) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (helmet.func_77973_b().equals(ModItems.boundHelmet) || plate.func_77973_b().equals(ModItems.boundPlate) || leggings.func_77973_b().equals(ModItems.boundLeggings) || boots.func_77973_b().equals(ModItems.boundBoots)) {
            if (source.func_76363_c()) {
                return new ISpecialArmor.ArmorProperties(-1, 3.0, 3);
            }
            return new ISpecialArmor.ArmorProperties(-1, 3.0, 100000);
        }
        return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (armor.equals(ModItems.boundHelmet)) {
            return 3;
        }
        if (armor.equals(ModItems.boundPlate)) {
            return 8;
        }
        if (armor.equals(ModItems.boundLeggings)) {
            return 6;
        }
        if (armor.equals(ModItems.boundBoots)) {
            return 3;
        }
        return 5;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (entity instanceof EntityPlayer) {
            EnergyItems.checkAndSetItemOwner(stack, (EntityPlayer)entity);
            if (((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                return;
            }
        }
        stack.func_77964_b(stack.func_77960_j() + damage);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add("Devilish Protection");
        if (par1ItemStack.field_77990_d != null) {
            ItemStack[] inv;
            if (!par1ItemStack.field_77990_d.func_74779_i("ownerName").equals("")) {
                par3List.add("Current owner: " + par1ItemStack.field_77990_d.func_74779_i("ownerName"));
            }
            if ((inv = this.getInternalInventory(par1ItemStack)) == null) {
                return;
            }
            for (int i = 0; i < invSize; ++i) {
                if (inv[i] == null) continue;
                par3List.add("Item in slot " + i + ": " + inv[i].func_82833_r());
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_82165_m(Potion.field_76441_p.field_76415_H)) {
            if (this == ModItems.boundHelmet || this == ModItems.boundPlate || this == ModItems.boundBoots) {
                return "alchemicalwizardry:models/armor/boundArmour_invisible_layer_1.png";
            }
            if (this == ModItems.boundLeggings) {
                return "alchemicalwizardry:models/armor/boundArmour_invisible_layer_2.png";
            }
        }
        if (this == ModItems.boundHelmet || this == ModItems.boundPlate || this == ModItems.boundBoots) {
            return "alchemicalwizardry:models/armor/boundArmour_layer_1.png";
        }
        if (this == ModItems.boundLeggings) {
            return "alchemicalwizardry:models/armor/boundArmour_layer_2.png";
        }
        return null;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        return super.func_77659_a(par1ItemStack, par2World, par3EntityPlayer);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        int maxBloodLevel = this.getMaxBloodShardLevel(itemStack);
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv != null) {
            boolean iSize = false;
            boolean iBlood = false;
        }
        if (!player.func_70644_a(AlchemicalWizardry.customPotionInhibit)) {
            this.tickInternalInventory(itemStack, world, player, 0, false);
        }
        if (itemStack.func_77960_j() > 0) {
            EnergyItems.checkAndSetItemOwner(itemStack, player);
            if (!player.field_71075_bZ.field_75098_d) {
                EnergyItems.syphonBatteries(itemStack, player, itemStack.func_77960_j() * 75);
                itemStack.func_77964_b(0);
            }
        }
    }

    public void tickInternalInventory(ItemStack par1ItemStack, World par2World, EntityPlayer par3Entity, int par4, boolean par5) {
        ItemStack[] inv = this.getInternalInventory(par1ItemStack);
        if (inv == null) {
            return;
        }
        int blood = this.getMaxBloodShardLevel(par1ItemStack);
        for (int i = 0; i < invSize; ++i) {
            if (inv[i] == null || !(inv[i].func_77973_b() instanceof ArmourUpgrade) || blood <= 0) continue;
            if (((ArmourUpgrade)inv[i].func_77973_b()).isUpgrade()) {
                ((ArmourUpgrade)inv[i].func_77973_b()).onArmourUpdate(par2World, par3Entity, inv[i]);
                --blood;
            }
            if (par2World.func_72820_D() % 200L != 0L || !(this.getUpgradeCostMultiplier(par1ItemStack) > 0.02f)) continue;
            EnergyItems.syphonBatteries(par1ItemStack, par3Entity, (int)((float)((ArmourUpgrade)inv[i].func_77973_b()).getEnergyForTenSeconds() * this.getUpgradeCostMultiplier(par1ItemStack)));
        }
    }

    public int getMaxBloodShardLevel(ItemStack armourStack) {
        ItemStack[] inv = this.getInternalInventory(armourStack);
        if (inv == null) {
            return 0;
        }
        int max = 0;
        for (int i = 0; i < invSize; ++i) {
            ItemStack itemStack = inv[i];
            if (itemStack == null) continue;
            if (itemStack.func_77973_b().equals(ModItems.weakBloodShard)) {
                max = Math.max(max, 1);
            }
            if (!itemStack.func_77973_b().equals(ModItems.demonBloodShard)) continue;
            max = Math.max(max, 2);
        }
        return max;
    }

    public boolean hasAddedToInventory(ItemStack sigilItemStack, ItemStack addedItemStack) {
        ItemStack[] inv = this.getInternalInventory(sigilItemStack);
        if (inv == null) {
            return false;
        }
        if (addedItemStack == null) {
            return false;
        }
        Item item = addedItemStack.func_77973_b();
        int candidateSlot = -1;
        for (int i = invSize - 1; i >= 0; --i) {
            ItemStack nextItem = inv[i];
            if (nextItem != null) continue;
            candidateSlot = i;
        }
        if (candidateSlot == -1) {
            return false;
        }
        if (addedItemStack.func_77973_b() instanceof ArmourUpgrade) {
            inv[candidateSlot] = addedItemStack;
            this.saveInternalInventory(sigilItemStack, inv);
            return true;
        }
        return false;
    }

    public ItemStack[] getInternalInventory(ItemStack itemStack) {
        NBTTagCompound itemTag = itemStack.field_77990_d;
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        ItemStack[] inv = new ItemStack[9];
        NBTTagList tagList = itemTag.func_150295_c("Inventory", 10);
        if (tagList == null) {
            return null;
        }
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= invSize) continue;
            inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        return inv;
    }

    public void saveInternalInventory(ItemStack itemStack, ItemStack[] inventory) {
        NBTTagCompound itemTag = itemStack.field_77990_d;
        if (itemTag == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < invSize; ++i) {
            ItemStack stack = inventory[i];
            if (inventory[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            inventory[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        itemTag.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public boolean isImmuneToVoid(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv == null) {
            return false;
        }
        for (ItemStack item : inv) {
            if (item == null || !item.func_77973_b().equals(ModItems.voidSigil)) continue;
            return true;
        }
        return false;
    }

    public float getUpgradeCostMultiplier(ItemStack itemStack) {
        ItemStack[] inv = this.getInternalInventory(itemStack);
        if (inv == null) {
            return 1.0f;
        }
        for (ItemStack item : inv) {
            if (item == null) continue;
            if (item.func_77973_b().equals(ModItems.weakBloodOrb)) {
                return 0.75f;
            }
            if (item.func_77973_b().equals(ModItems.apprenticeBloodOrb)) {
                return 0.5f;
            }
            if (item.func_77973_b().equals(ModItems.magicianBloodOrb)) {
                return 0.25f;
            }
            if (item.func_77973_b().equals(ModItems.masterBloodOrb)) {
                return 0.0f;
            }
            if (!item.func_77973_b().equals(ModItems.archmageBloodOrb)) continue;
            return 0.0f;
        }
        return 1.0f;
    }

    public int func_77619_b() {
        return 0;
    }
}

