/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.altarRecipeRegistry;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.altarRecipeRegistry.AltarRecipe;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class AltarRecipeRegistry {
    public static List<AltarRecipe> altarRecipes = new LinkedList<AltarRecipe>();

    public static void registerAltarRecipe(ItemStack result, ItemStack requiredItem, int minTier, int liquidRequired, int consumptionRate, int drainRate, boolean canBeFilled) {
        altarRecipes.add(new AltarRecipe(result, requiredItem, minTier, liquidRequired, consumptionRate, drainRate, canBeFilled));
    }

    public static void registerAltarOrbRecipe(ItemStack orbStack, int minTier, int consumptionRate) {
        AltarRecipeRegistry.registerAltarRecipe(null, orbStack, minTier, 0, consumptionRate, 0, true);
    }

    public static void initRecipes() {
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.weakBloodOrb), new ItemStack(Items.field_151045_i), 1, 2000, 2, 1, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.apprenticeBloodOrb), new ItemStack(Items.field_151166_bC), 2, 5000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.magicianBloodOrb), new ItemStack(Blocks.field_150340_R), 3, 25000, 20, 20, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.masterBloodOrb), new ItemStack(ModItems.weakBloodShard), 4, 40000, 30, 50, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.archmageBloodOrb), new ItemStack(ModItems.demonBloodShard), 5, 75000, 50, 100, false);
        AltarRecipeRegistry.registerAltarOrbRecipe(new ItemStack(ModItems.weakBloodOrb), 1, 2);
        AltarRecipeRegistry.registerAltarOrbRecipe(new ItemStack(ModItems.apprenticeBloodOrb), 2, 5);
        AltarRecipeRegistry.registerAltarOrbRecipe(new ItemStack(ModItems.magicianBloodOrb), 3, 15);
        AltarRecipeRegistry.registerAltarOrbRecipe(new ItemStack(ModItems.masterBloodOrb), 4, 25);
        AltarRecipeRegistry.registerAltarOrbRecipe(new ItemStack(ModItems.archmageBloodOrb), 5, 50);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.telepositionFocus), new ItemStack(Items.field_151079_bi), 4, 2000, 10, 10, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.enhancedTelepositionFocus), new ItemStack(ModItems.telepositionFocus), 4, 10000, 25, 15, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.demonicSlate), new ItemStack(ModItems.imbuedSlate), 4, 15000, 20, 20, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.duskScribeTool), new ItemStack(Blocks.field_150402_ci), 4, 2000, 20, 10, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModBlocks.bloodSocket), new ItemStack(ModBlocks.emptySocket), 3, 30000, 40, 10, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.earthScribeTool), new ItemStack(Blocks.field_150343_Z), 3, 1000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.waterScribeTool), new ItemStack(Blocks.field_150368_y), 3, 1000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.blankSpell), new ItemStack(Blocks.field_150359_w), 2, 1000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.blankSlate), new ItemStack(Blocks.field_150348_b), 1, 1000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.activationCrystal), new ItemStack(ModItems.lavaCrystal), 3, 10000, 20, 10, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.fireScribeTool), new ItemStack(Items.field_151064_bs), 3, 1000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.airScribeTool), new ItemStack(Items.field_151073_bk), 3, 1000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.imbuedSlate), new ItemStack(ModItems.reinforcedSlate), 3, 5000, 15, 10, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.daggerOfSacrifice), new ItemStack(Items.field_151040_l), 2, 3000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.alchemyFlask), new ItemStack(Items.field_151069_bo), 2, 2000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.reinforcedSlate), new ItemStack(ModItems.blankSlate), 2, 2000, 5, 5, false);
        AltarRecipeRegistry.registerAltarRecipe(new ItemStack(ModItems.bucketLife), new ItemStack(Items.field_151133_ar), 1, 1000, 5, 0, false);
    }

    public static boolean isRequiredItemValid(ItemStack testItem, int currentTierAltar) {
        for (AltarRecipe recipe : altarRecipes) {
            if (!recipe.doesRequiredItemMatch(testItem, currentTierAltar)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getItemForItemAndTier(ItemStack testItem, int currentTierAltar) {
        for (AltarRecipe recipe : altarRecipes) {
            if (!recipe.doesRequiredItemMatch(testItem, currentTierAltar)) continue;
            return ItemStack.func_77944_b((ItemStack)recipe.getResult());
        }
        return null;
    }

    public static AltarRecipe getAltarRecipeForItemAndTier(ItemStack testItem, int currentTierAltar) {
        for (AltarRecipe recipe : altarRecipes) {
            if (!recipe.doesRequiredItemMatch(testItem, currentTierAltar)) continue;
            return recipe;
        }
        return null;
    }
}

