/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.IBindingAgent;
import WayofTime.alchemicalWizardry.common.ICatalyst;
import WayofTime.alchemicalWizardry.common.IFillingAgent;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.alchemy.AlchemicalPotionCreationHandler;
import WayofTime.alchemicalWizardry.common.alchemy.AlchemyRecipeRegistry;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.items.potion.AlchemyFlask;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class TEWritingTable
extends TileEntity
implements IInventory {
    private ItemStack[] inv = new ItemStack[7];
    private int progress;
    private int progressNeeded = 100;
    private int amountUsed;
    public static final int sizeInv = 7;

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.progress = tagCompound.func_74762_e("progress");
        this.amountUsed = tagCompound.func_74762_e("amountUsed");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74768_a("progress", this.progress);
        tagCompound.func_74768_a("amountUsed", this.amountUsed);
    }

    public String func_145825_b() {
        return "aw.TEWritingTable";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public Packet func_145844_m() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData) {
        if (intData == null) {
            return;
        }
        if (intData.length == 21) {
            for (int i = 0; i < 7; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[21];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[pos++] = is.func_77960_j();
                sortList[pos++] = is.field_77994_a;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    public ItemStack getResultingItemStack() {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        return AlchemyRecipeRegistry.getResult(composedRecipe, this.inv[0]);
    }

    public boolean isRecipeValid() {
        return this.getResultingItemStack() != null;
    }

    public int getAmountNeeded(ItemStack bloodOrb) {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        return AlchemyRecipeRegistry.getAmountNeeded(composedRecipe, bloodOrb);
    }

    public boolean containsPotionFlask() {
        return this.getPotionFlaskPosition() != -1;
    }

    public int getPotionFlaskPosition() {
        for (int i = 1; i <= 5; ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() instanceof ItemBlock || this.inv[i].func_77973_b() != ModItems.alchemyFlask) continue;
            return i;
        }
        return -1;
    }

    public boolean containsRegisteredPotionIngredient() {
        return this.getRegisteredPotionIngredientPosition() != -1;
    }

    public int getRegisteredPotionIngredientPosition() {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        int location = AlchemicalPotionCreationHandler.getRegisteredPotionIngredientPosition(composedRecipe);
        if (location != -1) {
            return location + 1;
        }
        return -1;
    }

    public boolean containsCatalyst() {
        return this.getCatalystPosition() != -1;
    }

    public int getCatalystPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].func_77973_b() instanceof ICatalyst)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsBindingAgent() {
        return this.getBindingAgentPosition() != -1;
    }

    public int getBindingAgentPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].func_77973_b() instanceof IBindingAgent)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsFillingAgent() {
        return this.getFillingAgentPosition() != -1;
    }

    public int getFillingAgentPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].func_77973_b() instanceof IFillingAgent)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsBlankSlate() {
        return this.getBlankSlatePosition() != -1;
    }

    public int getBlankSlatePosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || this.inv[i + 1].func_77973_b() != ModItems.blankSlate) continue;
            return i + 1;
        }
        return -1;
    }

    public void func_145845_h() {
        long worldTime = this.field_145850_b.func_72820_D();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.containsPotionFlask() && this.containsRegisteredPotionIngredient()) {
            if (this.containsCatalyst()) {
                if (this.func_70301_a(6) == null) {
                    ++this.progress;
                    if (worldTime % 4L == 0L) {
                        SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    if (this.progress >= this.progressNeeded) {
                        ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                        ItemStack ingredientStack = this.inv[this.getRegisteredPotionIngredientPosition()];
                        ItemStack catalystStack = this.inv[this.getCatalystPosition()];
                        if (flaskStack == null || ingredientStack == null || catalystStack == null) {
                            this.progress = 0;
                            if (this.field_145850_b != null) {
                                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            }
                            return;
                        }
                        int potionID = AlchemicalPotionCreationHandler.getPotionIDForStack(ingredientStack);
                        int catalystLevel = ((ICatalyst)catalystStack.func_77973_b()).getCatalystLevel();
                        boolean isConcentration = ((ICatalyst)catalystStack.func_77973_b()).isConcentration();
                        if (potionID == -1 || catalystLevel < 0) {
                            this.progress = 0;
                            if (this.field_145850_b != null) {
                                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            }
                            return;
                        }
                        if (isConcentration) {
                            ((AlchemyFlask)flaskStack.func_77973_b()).setConcentrationOfPotion(flaskStack, potionID, catalystLevel);
                        } else {
                            ((AlchemyFlask)flaskStack.func_77973_b()).setDurationFactorOfPotion(flaskStack, potionID, catalystLevel);
                        }
                        this.func_70299_a(6, flaskStack);
                        this.func_70298_a(this.getPotionFlaskPosition(), 1);
                        this.func_70298_a(this.getCatalystPosition(), 1);
                        this.func_70298_a(this.getRegisteredPotionIngredientPosition(), 1);
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
            } else if (this.containsBindingAgent() && this.func_70301_a(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= this.progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack ingredientStack = this.inv[this.getRegisteredPotionIngredientPosition()];
                    ItemStack agentStack = this.inv[this.getBindingAgentPosition()];
                    if (flaskStack == null || ingredientStack == null || agentStack == null) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    int potionEffectNumber = ((AlchemyFlask)flaskStack.func_77973_b()).getNumberOfPotionEffects(flaskStack);
                    int potionID = AlchemicalPotionCreationHandler.getPotionIDForStack(ingredientStack);
                    int tickDuration = AlchemicalPotionCreationHandler.getPotionTickDurationForStack(ingredientStack);
                    float successChance = ((IBindingAgent)agentStack.func_77973_b()).getSuccessRateForPotionNumber(potionEffectNumber);
                    if (potionID == -1) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    ((AlchemyFlask)flaskStack.func_77973_b()).addPotionEffect(flaskStack, potionID, tickDuration);
                    if (successChance > this.field_145850_b.field_73012_v.nextFloat()) {
                        this.func_70299_a(6, flaskStack);
                    } else {
                        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 2.0f, false);
                    }
                    this.func_70298_a(this.getPotionFlaskPosition(), 1);
                    this.func_70298_a(this.getBindingAgentPosition(), 1);
                    this.func_70298_a(this.getRegisteredPotionIngredientPosition(), 1);
                    this.progress = 0;
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        } else if (this.containsBlankSlate() && this.containsPotionFlask()) {
            if (this.func_70301_a(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= this.progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack blankSlate = this.inv[this.getBlankSlatePosition()];
                    if (flaskStack == null || blankSlate == null) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    ((AlchemyFlask)flaskStack.func_77973_b()).setIsPotionThrowable(true, flaskStack);
                    this.func_70299_a(6, flaskStack);
                    this.func_70298_a(this.getPotionFlaskPosition(), 1);
                    this.func_70298_a(this.getBlankSlatePosition(), 1);
                    this.progress = 0;
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        } else if (this.containsFillingAgent() && this.containsPotionFlask()) {
            if (this.func_70301_a(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (this.progress >= this.progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack fillingAgent = this.inv[this.getFillingAgentPosition()];
                    if (flaskStack == null || fillingAgent == null) {
                        this.progress = 0;
                        if (this.field_145850_b != null) {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        return;
                    }
                    int potionEffects = ((AlchemyFlask)flaskStack.func_77973_b()).getNumberOfPotionEffects(flaskStack);
                    int potionFillAmount = ((IFillingAgent)fillingAgent.func_77973_b()).getFilledAmountForPotionNumber(potionEffects);
                    flaskStack.func_77964_b(Math.max(0, flaskStack.func_77960_j() - potionFillAmount));
                    this.func_70299_a(6, flaskStack);
                    this.func_70298_a(this.getPotionFlaskPosition(), 1);
                    this.func_70298_a(this.getFillingAgentPosition(), 1);
                    this.progress = 0;
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        } else {
            if (!this.isRecipeValid()) {
                this.progress = 0;
                return;
            }
            if (this.progress <= 0) {
                this.progress = 0;
                this.amountUsed = this.getAmountNeeded(this.func_70301_a(0));
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if (this.func_70301_a(6) == null) {
                if (!EnergyItems.syphonWhileInContainer(this.func_70301_a(0), this.amountUsed)) {
                    return;
                }
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                ++this.progress;
                if (this.progress >= this.progressNeeded) {
                    this.progress = 0;
                    this.func_70299_a(6, this.getResultingItemStack());
                    for (int i = 0; i < 5; ++i) {
                        this.func_70298_a(i + 1, 1);
                    }
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            } else if (this.func_70301_a(6).func_77973_b() == this.getResultingItemStack().func_77973_b() && this.getResultingItemStack().field_77994_a <= this.func_70301_a(6).func_77976_d() - this.func_70301_a((int)6).field_77994_a) {
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 20, this.field_145850_b.field_73011_w.field_76574_g, 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                if (!EnergyItems.syphonWhileInContainer(this.func_70301_a(0), this.amountUsed)) {
                    return;
                }
                ++this.progress;
                if (this.progress >= this.progressNeeded) {
                    this.progress = 0;
                    ItemStack result = this.getResultingItemStack().func_77946_l();
                    result.field_77994_a += this.func_70301_a((int)6).field_77994_a;
                    this.func_70299_a(6, result);
                    for (int i = 0; i < 5; ++i) {
                        this.func_70298_a(i + 1, 1);
                    }
                    if (this.field_145850_b != null) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        }
    }
}

