/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.common.IDemon;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.PlinthComponent;
import WayofTime.alchemicalWizardry.common.items.EnergyBattery;
import WayofTime.alchemicalWizardry.common.summoning.SummoningRegistry;
import WayofTime.alchemicalWizardry.common.summoning.SummoningRegistryComponent;
import WayofTime.alchemicalWizardry.common.tileEntity.TEPedestal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class TEPlinth
extends TileEntity
implements IInventory {
    private ItemStack[] inv = new ItemStack[1];
    private boolean isActive = false;
    private boolean paradigm;
    private ItemStack[] ring1Inv = new ItemStack[6];
    private ItemStack[] ring2Inv = new ItemStack[6];
    private ItemStack[] ring3Inv = new ItemStack[6];
    public static final int sizeInv = 1;
    private int progressInterval = 50;
    private int progress = 0;
    public static List<PlinthComponent> pedestalPositions = new ArrayList<PlinthComponent>();

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        NBTTagList ring1TagList = par1NBTTagCompound.func_150295_c("ring1Inv", 10);
        for (int i = 0; i < ring1TagList.func_74745_c(); ++i) {
            NBTTagCompound tag = ring1TagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.ring1Inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        NBTTagList ring2TagList = par1NBTTagCompound.func_150295_c("ring2Inv", 10);
        for (int i = 0; i < ring2TagList.func_74745_c(); ++i) {
            NBTTagCompound tag = ring2TagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.ring2Inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        NBTTagList ring3TagList = par1NBTTagCompound.func_150295_c("ring3Inv", 10);
        for (int i = 0; i < ring3TagList.func_74745_c(); ++i) {
            NBTTagCompound tag = ring3TagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.ring3Inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.progress = par1NBTTagCompound.func_74762_e("progress");
        this.progressInterval = par1NBTTagCompound.func_74762_e("progressInterval");
        this.isActive = par1NBTTagCompound.func_74767_n("isActive");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        NBTTagList ring1ItemList = new NBTTagList();
        for (int i = 0; i < this.ring1Inv.length; ++i) {
            ItemStack stack = this.ring1Inv[i];
            if (this.ring1Inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.ring1Inv[i].func_77955_b(tag);
            ring1ItemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("ring1Inv", (NBTBase)ring1ItemList);
        NBTTagList ring2ItemList = new NBTTagList();
        for (int i = 0; i < this.ring2Inv.length; ++i) {
            ItemStack stack = this.ring2Inv[i];
            if (this.ring2Inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.ring2Inv[i].func_77955_b(tag);
            ring2ItemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("ring2Inv", (NBTBase)ring1ItemList);
        NBTTagList ring3ItemList = new NBTTagList();
        for (int i = 0; i < this.ring3Inv.length; ++i) {
            ItemStack stack = this.ring3Inv[i];
            if (this.ring3Inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.ring3Inv[i].func_77955_b(tag);
            ring3ItemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("ring3Inv", (NBTBase)ring1ItemList);
        par1NBTTagCompound.func_74768_a("progress", this.progress);
        par1NBTTagCompound.func_74768_a("progressInterval", this.progressInterval);
        par1NBTTagCompound.func_74757_a("isActive", this.isActive);
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inv[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "TEPlinth";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isActive()) {
            if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof EnergyBattery) {
                int bloodOrbLevel = ((EnergyBattery)this.func_70301_a(0).func_77973_b()).getOrbLevel();
                if (SummoningRegistry.isRecipeValid(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, true), this.composeItemsForRingAndParadigm(2, true), this.composeItemsForRingAndParadigm(3, true))) {
                    SummoningRegistryComponent src = SummoningRegistry.getRegistryComponent(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, true), this.composeItemsForRingAndParadigm(2, true), this.composeItemsForRingAndParadigm(3, true));
                    this.isActive = true;
                    this.paradigm = true;
                    this.progress = 0;
                    this.ring1Inv = src.getRingRecipeForRing(1);
                    this.ring2Inv = src.getRingRecipeForRing(2);
                    this.ring3Inv = src.getRingRecipeForRing(3);
                } else if (SummoningRegistry.isRecipeValid(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, false), this.composeItemsForRingAndParadigm(2, false), this.composeItemsForRingAndParadigm(3, false))) {
                    SummoningRegistryComponent src = SummoningRegistry.getRegistryComponent(bloodOrbLevel, this.composeItemsForRingAndParadigm(1, false), this.composeItemsForRingAndParadigm(2, false), this.composeItemsForRingAndParadigm(3, false));
                    this.isActive = true;
                    this.paradigm = false;
                    this.progress = 0;
                    this.ring1Inv = src.getRingRecipeForRing(1);
                    this.ring2Inv = src.getRingRecipeForRing(2);
                    this.ring3Inv = src.getRingRecipeForRing(3);
                } else {
                    this.isActive = false;
                    this.progress = 0;
                }
            }
        } else if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof EnergyBattery) {
            int bloodOrbLevel;
            EntityLivingBase entity;
            if (this.progress % this.progressInterval == 0) {
                ItemStack itemStack;
                int ring = this.progress / this.progressInterval / 6 + 1;
                int slot = this.progress / this.progressInterval % 6;
                switch (ring) {
                    case 1: {
                        itemStack = this.ring1Inv[slot];
                        break;
                    }
                    case 2: {
                        itemStack = this.ring2Inv[slot];
                        break;
                    }
                    case 3: {
                        itemStack = this.ring3Inv[slot];
                        break;
                    }
                    default: {
                        itemStack = null;
                    }
                }
                if (itemStack == null) {
                    this.progress += this.progressInterval;
                } else if (this.deleteItemStackInRing(ring, itemStack)) {
                    ++this.progress;
                }
            } else {
                ++this.progress;
            }
            if (this.progress >= this.progressInterval * 18 && (entity = SummoningRegistry.getEntity(this.field_145850_b, bloodOrbLevel = ((EnergyBattery)this.func_70301_a(0).func_77973_b()).getOrbLevel(), this.ring1Inv, this.ring2Inv, this.ring3Inv)) != null) {
                entity.func_70107_b((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5);
                this.field_145850_b.func_72838_d((Entity)entity);
                if (entity instanceof IDemon) {
                    ((IDemon)entity).setSummonedConditions();
                }
                this.field_145850_b.func_72876_a((Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 3.0f, false);
                this.deleteItemsInRing(1);
                this.isActive = false;
                this.progress = 0;
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    public void deleteItemsInRing(int ring) {
        if (this.paradigm) {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + pc.xOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.zOffset)) instanceof TEPedestal)) continue;
                ((TEPedestal)tileEntity).func_70299_a(0, null);
                this.field_145850_b.func_147471_g(this.field_145851_c + pc.xOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.zOffset);
                ++i;
            }
        } else {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + pc.zOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.xOffset)) instanceof TEPedestal)) continue;
                ((TEPedestal)tileEntity).func_70299_a(0, null);
                this.field_145850_b.func_147471_g(this.field_145851_c + pc.zOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.xOffset);
                ++i;
            }
        }
    }

    public boolean deleteItemStackInRing(int ring, ItemStack itemStack) {
        if (itemStack == null) {
            return true;
        }
        if (this.paradigm) {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + pc.xOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.zOffset)) instanceof TEPedestal)) continue;
                ItemStack possibleItem = ((TEPedestal)tileEntity).func_70301_a(0);
                if (possibleItem == null) {
                    ++i;
                    continue;
                }
                boolean test = false;
                if (possibleItem.func_77973_b() instanceof ItemBlock) {
                    if (itemStack.func_77973_b() instanceof ItemBlock) {
                        test = true;
                    }
                } else if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
                    test = true;
                }
                if (test && itemStack.func_77973_b() == possibleItem.func_77973_b() && (itemStack.func_77960_j() == possibleItem.func_77960_j() || itemStack.func_77960_j() == Short.MAX_VALUE)) {
                    ((TEPedestal)tileEntity).func_70298_a(0, 1);
                    if (((TEPedestal)tileEntity).func_70301_a(0) != null && ((TEPedestal)tileEntity).func_70301_a((int)0).field_77994_a == 0) {
                        ((TEPedestal)tileEntity).func_70299_a(0, null);
                    }
                    ((TEPedestal)tileEntity).onItemDeletion();
                    this.field_145850_b.func_147471_g(this.field_145851_c + pc.xOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.zOffset);
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + pc.zOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.xOffset)) instanceof TEPedestal)) continue;
                ItemStack possibleItem = ((TEPedestal)tileEntity).func_70301_a(0);
                if (possibleItem == null) {
                    ++i;
                    continue;
                }
                boolean test = false;
                if (possibleItem.func_77973_b() instanceof ItemBlock) {
                    if (itemStack.func_77973_b() instanceof ItemBlock) {
                        test = true;
                    }
                } else if (!(itemStack.func_77973_b() instanceof ItemBlock)) {
                    test = true;
                }
                if (test && itemStack.func_77973_b() == possibleItem.func_77973_b() && (itemStack.func_77960_j() == possibleItem.func_77960_j() || itemStack.func_77960_j() == Short.MAX_VALUE)) {
                    ((TEPedestal)tileEntity).func_70298_a(0, 1);
                    ((TEPedestal)tileEntity).onItemDeletion();
                    this.field_145850_b.func_147471_g(this.field_145851_c + pc.zOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.zOffset);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ItemStack[] composeItemsForRingAndParadigm(int ring, boolean paradigm) {
        ItemStack[] composed = new ItemStack[6];
        if (paradigm) {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + pc.xOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.zOffset)) instanceof TEPedestal)) continue;
                composed[i] = ((TEPedestal)tileEntity).func_70301_a(0);
                ++i;
            }
        } else {
            int i = 0;
            for (PlinthComponent pc : pedestalPositions) {
                TileEntity tileEntity;
                if (i >= 6 || pc.getRing() != ring || !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + pc.zOffset, this.field_145848_d + pc.yOffset, this.field_145849_e + pc.xOffset)) instanceof TEPedestal)) continue;
                composed[i] = ((TEPedestal)tileEntity).func_70301_a(0);
                ++i;
            }
        }
        return composed;
    }

    public void setActive() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Packet func_145844_m() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData) {
        if (intData == null) {
            return;
        }
        if (intData.length == 3) {
            for (int i = 0; i < 1; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.func_150899_d((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[3];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.func_150891_b((Item)is.func_77973_b());
                sortList[pos++] = is.func_77960_j();
                sortList[pos++] = is.field_77994_a;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    public static void initialize() {
        pedestalPositions.add(new PlinthComponent(1, 0, -2, 1));
        pedestalPositions.add(new PlinthComponent(2, 0, 0, 1));
        pedestalPositions.add(new PlinthComponent(1, 0, 2, 1));
        pedestalPositions.add(new PlinthComponent(-1, 0, -2, 1));
        pedestalPositions.add(new PlinthComponent(-2, 0, 0, 1));
        pedestalPositions.add(new PlinthComponent(-1, 0, 2, 1));
        pedestalPositions.add(new PlinthComponent(3, 1, -5, 2));
        pedestalPositions.add(new PlinthComponent(6, 1, 0, 2));
        pedestalPositions.add(new PlinthComponent(3, 1, 5, 2));
        pedestalPositions.add(new PlinthComponent(-3, 1, -5, 2));
        pedestalPositions.add(new PlinthComponent(-6, 1, 0, 2));
        pedestalPositions.add(new PlinthComponent(-3, 1, 5, 2));
        pedestalPositions.add(new PlinthComponent(0, 2, -9, 3));
        pedestalPositions.add(new PlinthComponent(7, 2, -4, 3));
        pedestalPositions.add(new PlinthComponent(7, 2, 4, 3));
        pedestalPositions.add(new PlinthComponent(0, 2, 9, 3));
        pedestalPositions.add(new PlinthComponent(-7, 2, -4, 3));
        pedestalPositions.add(new PlinthComponent(-7, 2, 4, 3));
    }
}

