/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.common.entity.projectile.TeleportProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class SpellTeleport
extends HomSpell {
    Random itemRand = new Random();

    public SpellTeleport() {
        this.setEnergies(500, 300, 500, 1000);
    }

    @Override
    public ItemStack onOffensiveRangedRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        if (par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveRangedEnergy());
        }
        par2World.func_72838_d((Entity)new TeleportProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8, true));
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        return par1ItemStack;
    }

    @Override
    public ItemStack onOffensiveMeleeRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        if (par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveMeleeEnergy());
        }
        par2World.func_72838_d((Entity)new TeleportProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8, false));
        return par1ItemStack;
    }

    @Override
    public ItemStack onDefensiveRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        if (par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getDefensiveEnergy());
        }
        double xCoord = par3EntityPlayer.field_70165_t;
        double yCoord = par3EntityPlayer.field_70163_u;
        double zCoord = par3EntityPlayer.field_70161_v;
        SpellTeleport.teleportRandomly((EntityLivingBase)par3EntityPlayer, 128.0);
        for (int i = 0; i < 20; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.field_73011_w.field_76574_g, "portal", xCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 2.0f), yCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 2.0f), zCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 2.0f), this.itemRand.nextFloat(), this.itemRand.nextFloat(), this.itemRand.nextFloat());
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onEnvironmentalRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer);
        if (par3EntityPlayer.func_70093_af()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getEnvironmentalEnergy());
        }
        if (!par2World.field_72995_K) {
            int d0 = 3;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72332_a().func_72299_a(par3EntityPlayer.field_70165_t, par3EntityPlayer.field_70163_u, par3EntityPlayer.field_70161_v, par3EntityPlayer.field_70165_t + 1.0, par3EntityPlayer.field_70163_u + 2.0, par3EntityPlayer.field_70161_v + 1.0).func_72314_b((double)d0, (double)d0, (double)d0);
            List list = par3EntityPlayer.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase entityLiving : list) {
                if (entityLiving instanceof EntityPlayer && entityLiving.equals((Object)par3EntityPlayer)) continue;
                SpellTeleport.teleportRandomly(entityLiving, 128.0);
            }
        }
        double xCoord = par3EntityPlayer.field_70165_t;
        double yCoord = par3EntityPlayer.field_70163_u;
        double zCoord = par3EntityPlayer.field_70161_v;
        for (int i = 0; i < 32; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.field_73011_w.field_76574_g, "portal", xCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 2.0f), yCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 2.0f), zCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 2.0f), this.itemRand.nextFloat(), this.itemRand.nextFloat(), this.itemRand.nextFloat());
        }
        return par1ItemStack;
    }

    public static boolean teleportRandomly(EntityLivingBase entityLiving, double distance) {
        int i;
        double x = entityLiving.field_70165_t;
        double y = entityLiving.field_70163_u;
        double z = entityLiving.field_70161_v;
        Random rand = new Random();
        double d0 = x + (rand.nextDouble() - 0.5) * distance;
        double d1 = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
        double d2 = z + (rand.nextDouble() - 0.5) * distance;
        for (i = 0; !SpellTeleport.teleportTo(entityLiving, d0, d1, d2, x, y, z) && i < 100; ++i) {
            d0 = x + (rand.nextDouble() - 0.5) * distance;
            d1 = y + ((double)rand.nextInt((int)distance) - distance / 2.0);
            d2 = z + (rand.nextDouble() - 0.5) * distance;
        }
        return i < 100;
    }

    private static boolean teleportTo(EntityLivingBase entityLiving, double par1, double par3, double par5, double lastX, double lastY, double lastZ) {
        EnderTeleportEvent event = new EnderTeleportEvent(entityLiving, par1, par3, par5, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = lastX;
        double d4 = lastY;
        double d5 = lastZ;
        SpellTeleport.moveEntityViaTeleport(entityLiving, event.targetX, event.targetY, event.targetZ);
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)entityLiving.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityLiving.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityLiving.field_70161_v);
        if (entityLiving.field_70170_p.func_72899_e(i, j, k)) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block l = entityLiving.field_70170_p.func_147439_a(i, j - 1, k);
                if (l != null && l.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entityLiving.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                SpellTeleport.moveEntityViaTeleport(entityLiving, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v);
                if (entityLiving.field_70170_p.func_72945_a((Entity)entityLiving, entityLiving.field_70121_D).isEmpty() && !entityLiving.field_70170_p.func_72953_d(entityLiving.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            SpellTeleport.moveEntityViaTeleport(entityLiving, d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (j = 0; j < short1; ++j) {
            double d6 = (double)j / ((double)short1 - 1.0);
            float f = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f1 = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f2 = (entityLiving.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entityLiving.field_70165_t - d3) * d6 + (entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            double d8 = d4 + (entityLiving.field_70163_u - d4) * d6 + entityLiving.field_70170_p.field_73012_v.nextDouble() * (double)entityLiving.field_70131_O;
            double d9 = d5 + (entityLiving.field_70161_v - d5) * d6 + (entityLiving.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)entityLiving.field_70130_N * 2.0;
            entityLiving.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        return true;
    }

    public static void moveEntityViaTeleport(EntityLivingBase entityLiving, double x, double y, double z) {
        if (entityLiving instanceof EntityPlayer) {
            if (entityLiving != null && entityLiving instanceof EntityPlayerMP) {
                EnderTeleportEvent event;
                EntityPlayerMP entityplayermp = (EntityPlayerMP)entityLiving;
                if (entityplayermp.field_70170_p == entityLiving.field_70170_p && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)entityplayermp, x, y, z, 5.0f)))) {
                    if (entityLiving.func_70115_ae()) {
                        entityLiving.func_70078_a((Entity)null);
                    }
                    entityLiving.func_70634_a(event.targetX, event.targetY, event.targetZ);
                }
            }
        } else if (entityLiving != null) {
            entityLiving.func_70107_b(x, y, z);
        }
    }
}

