/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex;

import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.EntitySpellProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigm;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.IProjectileImpactEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.IProjectileUpdateEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.enhancement.SpellEnhancement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SpellParadigmProjectile
extends SpellParadigm {
    public DamageSource damageSource = DamageSource.field_76377_j;
    public float damage = 1.0f;
    public int cost = 0;
    public List<IProjectileImpactEffect> impactList = new ArrayList<IProjectileImpactEffect>();
    public List<IProjectileUpdateEffect> updateEffectList = new ArrayList<IProjectileUpdateEffect>();
    public boolean penetration = false;
    public int ricochetMax = 0;
    public boolean isSilkTouch = false;

    @Override
    public void enhanceParadigm(SpellEnhancement enh) {
    }

    @Override
    public void castSpell(World world, EntityPlayer entityPlayer, ItemStack itemStack) {
        EntitySpellProjectile proj = new EntitySpellProjectile(world, entityPlayer);
        this.prepareProjectile(proj);
        world.func_72838_d((Entity)proj);
        int cost = this.getTotalCost();
        EnergyItems.syphonBatteries(itemStack, entityPlayer, cost);
    }

    public static SpellParadigmProjectile getParadigmForEffectArray(List<SpellEffect> effectList) {
        SpellParadigmProjectile parad = new SpellParadigmProjectile();
        for (SpellEffect eff : effectList) {
            parad.addBufferedEffect(eff);
        }
        return parad;
    }

    public void prepareProjectile(EntitySpellProjectile proj) {
        proj.setDamage(this.damage);
        proj.setImpactList(this.impactList);
        proj.setUpdateEffectList(this.updateEffectList);
        proj.setPenetration(this.penetration);
        proj.setRicochetMax(this.ricochetMax);
        proj.setIsSilkTouch(this.isSilkTouch);
        proj.setSpellEffectList(this.bufferedEffectList);
    }

    public void addImpactEffect(IProjectileImpactEffect eff) {
        if (eff != null) {
            this.impactList.add(eff);
        }
    }

    public void addUpdateEffect(IProjectileUpdateEffect eff) {
        if (eff != null) {
            this.updateEffectList.add(eff);
        }
    }

    @Override
    public int getDefaultCost() {
        return 50;
    }
}

