/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex;

import WayofTime.alchemicalWizardry.common.spell.complex.SpellModifier;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmMelee;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmSelf;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.enhancement.SpellEnhancement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class SpellParadigm {
    protected List<SpellEffect> bufferedEffectList = new ArrayList<SpellEffect>();
    public List<String> effectList = new LinkedList<String>();

    public void addBufferedEffect(SpellEffect effect) {
        if (effect != null) {
            this.bufferedEffectList.add(effect);
            this.effectList.add(effect.getClass().getName());
        }
    }

    public void modifyBufferedEffect(SpellModifier modifier) {
        SpellEffect effect = this.getBufferedEffect();
        if (effect != null) {
            effect.modifyEffect(modifier);
            this.effectList.add(modifier.getClass().getName());
        }
    }

    public void applyEnhancement(SpellEnhancement enh) {
        if (enh != null) {
            if (this.bufferedEffectList.isEmpty()) {
                this.enhanceParadigm(enh);
            } else {
                SpellEffect effect = this.getBufferedEffect();
                if (effect != null) {
                    effect.enhanceEffect(enh);
                }
            }
            this.effectList.add(enh.getClass().getName());
        }
    }

    public abstract void enhanceParadigm(SpellEnhancement var1);

    public abstract void castSpell(World var1, EntityPlayer var2, ItemStack var3);

    public void applySpellEffect(SpellEffect effect) {
        effect.modifyParadigm(this);
    }

    public void applyAllSpellEffects() {
        for (SpellEffect effect : this.bufferedEffectList) {
            this.applySpellEffect(effect);
        }
    }

    public SpellEffect getBufferedEffect() {
        if (this.bufferedEffectList.isEmpty()) {
            return null;
        }
        return this.bufferedEffectList.get(this.bufferedEffectList.size() - 1);
    }

    public int getTotalCost() {
        int cost = 0;
        if (this.bufferedEffectList != null && !this.bufferedEffectList.isEmpty()) {
            if (this instanceof SpellParadigmProjectile) {
                for (SpellEffect effect : this.bufferedEffectList) {
                    cost += effect.getCostForProjectile();
                }
            } else if (this instanceof SpellParadigmSelf) {
                for (SpellEffect effect : this.bufferedEffectList) {
                    cost += effect.getCostForSelf();
                }
            } else if (this instanceof SpellParadigmMelee) {
                for (SpellEffect effect : this.bufferedEffectList) {
                    cost += effect.getCostForMelee();
                }
            }
            return (int)((double)cost * Math.sqrt(this.bufferedEffectList.size()));
        }
        return this.getDefaultCost();
    }

    public abstract int getDefaultCost();

    public int getBufferedEffectPower() {
        SpellEffect eff = this.getBufferedEffect();
        if (eff != null) {
            return eff.getPowerEnhancements();
        }
        return 0;
    }

    public int getBufferedEffectCost() {
        SpellEffect eff = this.getBufferedEffect();
        if (eff != null) {
            return eff.getCostEnhancements();
        }
        return 0;
    }

    public int getBufferedEffectPotency() {
        SpellEffect eff = this.getBufferedEffect();
        if (eff != null) {
            return eff.getPotencyEnhancements();
        }
        return 0;
    }
}

