/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex;

import WayofTime.alchemicalWizardry.common.spell.complex.SpellParadigmProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.IProjectileImpactEffect;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.IProjectileUpdateEffect;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntitySpellProjectile
extends Entity
implements IProjectile {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private int inData = 0;
    private boolean inGround = false;
    public EntityPlayer shootingEntity;
    private int ticksInAir = 0;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;
    private boolean isSilkTouch = false;
    private int maxRicochet = 0;
    private float damage = 1.0f;
    public List<IProjectileImpactEffect> impactList = new ArrayList<IProjectileImpactEffect>();
    private boolean penetration = false;
    public List<IProjectileUpdateEffect> updateEffectList = new ArrayList<IProjectileUpdateEffect>();
    public List<SpellEffect> spellEffectList = new LinkedList<SpellEffect>();
    private int blocksBroken = 0;

    public EntitySpellProjectile(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntitySpellProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(par2, par4, par6);
        this.field_70129_M = 0.0f;
    }

    public EntitySpellProjectile(World par1World, EntityPlayer par2EntityPlayer) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.func_70105_a(0.1f, 0.1f);
        this.func_70012_b(par2EntityPlayer.field_70165_t, par2EntityPlayer.field_70163_u + (double)par2EntityPlayer.func_70047_e(), par2EntityPlayer.field_70161_v, par2EntityPlayer.field_70177_z, par2EntityPlayer.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.2;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void func_70186_c(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        this.field_70159_w = var1 *= (double)var7;
        this.field_70181_x = var3 *= (double)var7;
        this.field_70179_y = var5 *= (double)var7;
        float var10 = MathHelper.func_76133_a((double)(var1 * var1 + var5 * var5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_70071_h_() {
        Block var16;
        super.func_70071_h_();
        this.performUpdateEffects();
        if (this.ticksInAir > 600) {
            this.func_70106_y();
        }
        if (this.shootingEntity == null) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 1.0), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - 1.0), (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)));
            Iterator i = players.iterator();
            double closestDistance = Double.MAX_VALUE;
            EntityPlayer closestPlayer = null;
            while (i.hasNext()) {
                EntityPlayer e = (EntityPlayer)i.next();
                double distance = e.func_70032_d((Entity)this);
                if (!(distance < closestDistance)) continue;
                closestPlayer = e;
            }
            if (closestPlayer != null) {
                this.shootingEntity = closestPlayer;
            }
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var1) * 180.0 / Math.PI);
        }
        if ((var16 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)) != null) {
            var16.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = var16.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.func_72318_a(this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            Block var18 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            int var19 = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (var18.equals(Block.func_149729_e((int)this.inTile)) && var19 != this.inData) return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir > 1 && this.ticksInAir < 3) {
            for (int particles = 0; particles < 3; ++particles) {
                this.doFiringParticles();
            }
        }
        Vec3 var17 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 var3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition var4 = this.field_70170_p.func_147447_a(var17, var3, true, false, false);
        var17 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        var3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (var4 != null) {
            var3 = this.field_70170_p.func_82732_R().func_72345_a(var4.field_72307_f.field_72450_a, var4.field_72307_f.field_72448_b, var4.field_72307_f.field_72449_c);
        }
        Entity var5 = null;
        List var6 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double var7 = 0.0;
        for (Entity var10 : var6) {
            double var14;
            float var11;
            AxisAlignedBB var12;
            MovingObjectPosition var13;
            if (!var10.func_70067_L() || var10 == this.shootingEntity && this.ticksInAir < 5 || (var13 = (var12 = var10.field_70121_D.func_72314_b((double)(var11 = 0.3f), (double)var11, (double)var11)).func_72327_a(var17, var3)) == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
            var5 = var10;
            var7 = var14;
        }
        if (var5 != null) {
            var4 = new MovingObjectPosition(var5);
        }
        if (var4 != null) {
            this.onImpact(var4);
            if (this.scheduledForDeath) {
                this.func_70106_y();
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void doFlightParticles() {
        if (this.ticksInAir % 3 == 0) {
            double gauss = this.gaussian(1.0);
            this.field_70170_p.func_72869_a("mobSpell", this.field_70165_t, this.field_70163_u, this.field_70161_v, gauss, gauss, 0.0);
        }
    }

    private void doFiringParticles() {
        this.field_70170_p.func_72869_a("mobSpellAmbient", this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(this.field_70159_w), this.gaussian(this.field_70181_x), this.gaussian(this.field_70179_y));
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.xTile);
        par1NBTTagCompound.func_74777_a("yTile", (short)this.yTile);
        par1NBTTagCompound.func_74777_a("zTile", (short)this.zTile);
        par1NBTTagCompound.func_74774_a("inTile", (byte)this.inTile);
        par1NBTTagCompound.func_74774_a("inData", (byte)this.inData);
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        NBTTagList effectList = new NBTTagList();
        for (SpellEffect eff : this.spellEffectList) {
            effectList.func_74742_a((NBTBase)eff.getTag());
        }
        par1NBTTagCompound.func_74782_a("Effects", (NBTBase)effectList);
        par1NBTTagCompound.func_74768_a("blocksBroken", this.blocksBroken);
        par1NBTTagCompound.func_74757_a("isSilkTouch", this.isSilkTouch);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.func_74765_d("xTile");
        this.yTile = par1NBTTagCompound.func_74765_d("yTile");
        this.zTile = par1NBTTagCompound.func_74765_d("zTile");
        this.inTile = par1NBTTagCompound.func_74771_c("inTile") & 0xFF;
        this.inData = par1NBTTagCompound.func_74771_c("inData") & 0xFF;
        this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        this.blocksBroken = par1NBTTagCompound.func_74762_e("blocksBroken");
        this.isSilkTouch = par1NBTTagCompound.func_74767_n("isSilkTouch");
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Effects", 10);
        LinkedList<SpellEffect> spellEffectList = new LinkedList<SpellEffect>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            SpellEffect eff = SpellEffect.getEffectFromTag(tag);
            if (eff == null) continue;
            spellEffectList.add(eff);
        }
        this.spellEffectList = spellEffectList;
        SpellParadigmProjectile parad = SpellParadigmProjectile.getParadigmForEffectArray(spellEffectList);
        parad.applyAllSpellEffects();
        parad.prepareProjectile(this);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setKnockbackStrength(int par1) {
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setIsCritical(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte var1 = this.field_70180_af.func_75683_a(16);
        return (var1 & 1) != 0;
    }

    private void onImpact(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g != null) {
            if (mop.field_72308_g == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.field_72308_g);
            this.performEntityImpactEffects(mop.field_72308_g);
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !this.penetration) {
            this.groundImpact(mop.field_72310_e);
            this.performTileImpactEffects(mop);
        }
    }

    private void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.shootingEntity), 1.0f);
            this.func_70106_y();
        } else {
            this.doDamage(this.damage, mop);
        }
        this.spawnHitParticles("exorcism", 8);
        this.func_70106_y();
    }

    private void spawnHitParticles(String string, int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.field_70170_p.func_72869_a("mobSpellAmbient", this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), this.posGauss(1.0), this.posGauss(1.0), 0.0);
        }
    }

    private void doDamage(float f, Entity mop) {
        mop.func_70097_a(this.getDamageSource(), f);
    }

    private DamageSource getDamageSource() {
        return DamageSource.func_76365_a((EntityPlayer)this.shootingEntity);
    }

    private void groundImpact(int sideHit) {
        this.ricochet(sideHit);
    }

    private double smallGauss(double d) {
        return ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * d;
    }

    private double posGauss(double d) {
        return (double)this.field_70146_Z.nextFloat() * 0.5 * d;
    }

    private double gaussian(double d) {
        return d + d * (((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0);
    }

    private void ricochet(int sideHit) {
        switch (sideHit) {
            case 0: 
            case 1: {
                this.field_70181_x *= -1.0;
                break;
            }
            case 2: 
            case 3: {
                this.field_70179_y *= -1.0;
                break;
            }
            case 4: 
            case 5: {
                this.field_70159_w *= -1.0;
            }
        }
        ++this.ricochetCounter;
        if (this.ricochetCounter > this.getRicochetMax()) {
            this.scheduledForDeath = true;
            block13: for (int particles = 0; particles < 4; ++particles) {
                switch (sideHit) {
                    case 0: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), -this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 1: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 2: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), -this.gaussian(0.1));
                        continue block13;
                    }
                    case 3: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 4: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case 5: {
                        this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                    }
                }
            }
        }
    }

    public int getRicochetMax() {
        return this.maxRicochet;
    }

    public void setRicochetMax(int ricochet) {
        this.maxRicochet = ricochet;
    }

    public void setImpactList(List<IProjectileImpactEffect> list) {
        this.impactList = list;
    }

    public void setUpdateEffectList(List<IProjectileUpdateEffect> list) {
        this.updateEffectList = list;
    }

    private void performEntityImpactEffects(Entity mop) {
        if (this.impactList != null) {
            for (IProjectileImpactEffect impactEffect : this.impactList) {
                impactEffect.onEntityImpact(mop, this);
            }
        }
    }

    private void performTileImpactEffects(MovingObjectPosition mop) {
        if (this.impactList != null) {
            for (IProjectileImpactEffect impactEffect : this.impactList) {
                impactEffect.onTileImpact(this.field_70170_p, mop);
            }
        }
    }

    private void performUpdateEffects() {
        if (this.updateEffectList != null) {
            for (IProjectileUpdateEffect updateEffect : this.updateEffectList) {
                updateEffect.onUpdateEffect(this);
            }
        }
    }

    public void setPenetration(boolean penetration) {
        this.penetration = penetration;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setSpellEffectList(List<SpellEffect> list) {
        this.spellEffectList = list;
    }

    public int getBlocksBroken() {
        return this.blocksBroken;
    }

    public void setBlocksBroken(int blocksBroken) {
        this.blocksBroken = blocksBroken;
    }

    public boolean getIsSilkTouch() {
        return this.isSilkTouch;
    }

    public void setIsSilkTouch(boolean bool) {
        this.isSilkTouch = bool;
    }
}

