/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EnergyBlastProjectile
extends Entity
implements IProjectile,
IThrowableEntity {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected int inTile = 0;
    protected int inData = 0;
    protected boolean inGround = false;
    public EntityLivingBase shootingEntity;
    protected int ticksInAir = 0;
    protected int maxTicksInAir = 600;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;
    protected int projectileDamage;

    public EnergyBlastProjectile(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
        this.maxTicksInAir = 600;
    }

    public EnergyBlastProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(par2, par4, par6);
        this.field_70129_M = 0.0f;
        this.maxTicksInAir = 600;
    }

    public EnergyBlastProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(par2EntityPlayer.field_70165_t, par2EntityPlayer.field_70163_u + (double)par2EntityPlayer.func_70047_e(), par2EntityPlayer.field_70161_v, par2EntityPlayer.field_70177_z, par2EntityPlayer.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.2;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
        this.projectileDamage = damage;
        this.maxTicksInAir = 600;
    }

    public EnergyBlastProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(posX, posY, posZ, rotationYaw, rotationPitch);
        this.func_70107_b(posX -= (double)(MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * 0.16f), posY -= 0.2, posZ -= (double)(MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * 0.16f));
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
        this.projectileDamage = damage;
        this.maxTicksInAir = maxTicksInAir;
    }

    public EnergyBlastProjectile(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir) {
        super(par1World);
        this.field_70155_l = 10.0;
        this.shootingEntity = par2EntityLivingBase;
        this.field_70163_u = par2EntityLivingBase.field_70163_u + (double)par2EntityLivingBase.func_70047_e() - (double)0.1f;
        double d0 = par3EntityLivingBase.field_70165_t - par2EntityLivingBase.field_70165_t;
        double d1 = par3EntityLivingBase.field_70121_D.field_72338_b + (double)(par3EntityLivingBase.field_70131_O / 1.5f) - this.field_70163_u;
        double d2 = par3EntityLivingBase.field_70161_v - par2EntityLivingBase.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(par2EntityLivingBase.field_70165_t + d4, this.field_70163_u, par2EntityLivingBase.field_70161_v + d5, f2, f3);
            this.field_70129_M = 0.0f;
            float f4 = (float)d3 * 0.2f;
            this.func_70186_c(d0, d1, d2, par4, par5);
        }
        this.projectileDamage = damage;
        this.maxTicksInAir = maxTicksInAir;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void func_70186_c(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)var8;
        this.field_70159_w = var1 *= (double)var7;
        this.field_70181_x = var3 *= (double)var7;
        this.field_70179_y = var5 *= (double)var7;
        float var10 = MathHelper.func_76133_a((double)(var1 * var1 + var5 * var5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_70071_h_() {
        Block var16;
        super.func_70071_h_();
        if (this.ticksInAir > this.maxTicksInAir) {
            this.func_70106_y();
        }
        if (this.shootingEntity == null) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 1.0), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - 1.0), (double)(this.field_70165_t + 1.0), (double)(this.field_70163_u + 1.0), (double)(this.field_70161_v + 1.0)));
            Iterator i = players.iterator();
            double closestDistance = Double.MAX_VALUE;
            EntityPlayer closestPlayer = null;
            while (i.hasNext()) {
                EntityPlayer e = (EntityPlayer)i.next();
                double distance = e.func_70032_d((Entity)this);
                if (!(distance < closestDistance)) continue;
                closestPlayer = e;
            }
            if (closestPlayer != null) {
                this.shootingEntity = closestPlayer;
            }
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var1) * 180.0 / Math.PI);
        }
        if ((var16 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)) != null) {
            var16.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = var16.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.func_72318_a(this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            Block var18 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            int var19 = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (var18.equals(Block.func_149729_e((int)this.inTile)) && var19 != this.inData) return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir > 1 && this.ticksInAir < 3) {
            for (int particles = 0; particles < 3; ++particles) {
                this.doFiringParticles();
            }
        }
        Vec3 var17 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 var3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition var4 = this.field_70170_p.func_147447_a(var17, var3, true, false, false);
        var17 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        var3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (var4 != null) {
            var3 = this.field_70170_p.func_82732_R().func_72345_a(var4.field_72307_f.field_72450_a, var4.field_72307_f.field_72448_b, var4.field_72307_f.field_72449_c);
        }
        Entity var5 = null;
        List var6 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double var7 = 0.0;
        for (Entity var10 : var6) {
            double var14;
            float var11;
            AxisAlignedBB var12;
            MovingObjectPosition var13;
            if (!var10.func_70067_L() || var10 == this.shootingEntity && this.ticksInAir < 5 || (var13 = (var12 = var10.field_70121_D.func_72314_b((double)(var11 = 0.3f), (double)var11, (double)var11)).func_72327_a(var17, var3)) == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
            var5 = var10;
            var7 = var14;
        }
        if (var5 != null) {
            var4 = new MovingObjectPosition(var5);
        }
        if (var4 != null) {
            this.onImpact(var4);
            if (this.scheduledForDeath) {
                this.func_70106_y();
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void doFiringParticles() {
        this.field_70170_p.func_72869_a("mobSpellAmbient", this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(this.field_70159_w), this.gaussian(this.field_70181_x), this.gaussian(this.field_70179_y));
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.xTile);
        par1NBTTagCompound.func_74777_a("yTile", (short)this.yTile);
        par1NBTTagCompound.func_74777_a("zTile", (short)this.zTile);
        par1NBTTagCompound.func_74774_a("inTile", (byte)this.inTile);
        par1NBTTagCompound.func_74774_a("inData", (byte)this.inData);
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        par1NBTTagCompound.func_74768_a("ticksInAir", this.ticksInAir);
        par1NBTTagCompound.func_74768_a("maxTicksInAir", this.maxTicksInAir);
        par1NBTTagCompound.func_74768_a("projectileDamage", this.projectileDamage);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.func_74765_d("xTile");
        this.yTile = par1NBTTagCompound.func_74765_d("yTile");
        this.zTile = par1NBTTagCompound.func_74765_d("zTile");
        this.inTile = par1NBTTagCompound.func_74771_c("inTile") & 0xFF;
        this.inData = par1NBTTagCompound.func_74771_c("inData") & 0xFF;
        this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        this.ticksInAir = par1NBTTagCompound.func_74762_e("ticksInAir");
        this.maxTicksInAir = par1NBTTagCompound.func_74762_e("maxTicksInAir");
        this.projectileDamage = par1NBTTagCompound.func_74762_e("projectileDamage");
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setKnockbackStrength(int par1) {
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setIsCritical(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (par1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 1)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte var1 = this.field_70180_af.func_75683_a(16);
        return (var1 & 1) != 0;
    }

    public void onImpact(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g != null) {
            if (mop.field_72308_g == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.field_72308_g);
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.field_70170_p.func_72876_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.1f, true);
            this.func_70106_y();
        }
    }

    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.shootingEntity), 1.0f);
            this.func_70106_y();
        } else {
            if (mop instanceof EntityLivingBase) {
                ((EntityLivingBase)mop).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 60, 2));
            }
            this.doDamage(this.projectileDamage, mop);
            this.field_70170_p.func_72876_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.1f, true);
        }
        this.spawnHitParticles("magicCrit", 8);
        this.func_70106_y();
    }

    private int d6() {
        return this.field_70146_Z.nextInt(6) + 1;
    }

    protected void spawnHitParticles(String string, int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.field_70170_p.func_72869_a(string, this.field_70165_t, this.field_70163_u - (double)(string == "portal" ? 1 : 0), this.field_70161_v, this.gaussian(this.field_70159_w), this.gaussian(this.field_70181_x), this.gaussian(this.field_70179_y));
        }
    }

    protected void doDamage(int i, Entity mop) {
        mop.func_70097_a(this.getDamageSource(), (float)i);
    }

    public DamageSource getDamageSource() {
        return DamageSource.func_76358_a((EntityLivingBase)this.shootingEntity);
    }

    public double smallGauss(double d) {
        return ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * d;
    }

    public double gaussian(double d) {
        return d + d * (((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0);
    }

    private int getRicochetMax() {
        return 0;
    }

    public Entity getThrower() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.shootingEntity = (EntityLivingBase)entity;
        }
    }
}

