/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.tileEntity.TEOrientable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockOrientable
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private static IIcon[] fireIcons;

    public BlockOrientable() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(AlchemicalWizardry.tabBloodMagic);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        fireIcons = BlockOrientable.registerIconsWithString(iconRegister, "fireEffectBlock");
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon[] registerIconsWithString(IIconRegister iconRegister, String blockString) {
        IIcon[] icons = new IIcon[]{iconRegister.func_94245_a("AlchemicalWizardry:" + blockString + "_input"), iconRegister.func_94245_a("AlchemicalWizardry:" + blockString + "_output"), iconRegister.func_94245_a("AlchemicalWizardry:" + blockString + "_upArrow"), iconRegister.func_94245_a("AlchemicalWizardry:" + blockString + "_downArrow"), iconRegister.func_94245_a("AlchemicalWizardry:" + blockString + "_leftArrow"), iconRegister.func_94245_a("AlchemicalWizardry:" + blockString + "_rightArrow"), iconRegister.func_94245_a("AlchemicalWizardry:" + blockString + "_blank")};
        return icons;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        IIcon[] icons = this.getIconsForMeta(meta);
        switch (side) {
            case 4: {
                return icons[1];
            }
        }
        return icons[6];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBlockTexture(IBlockAccess par1IBlockAccess, int x, int y, int z, int side) {
        TileEntity tile = par1IBlockAccess.func_147438_o(x, y, z);
        int meta = par1IBlockAccess.func_72805_g(x, y, z);
        if (tile instanceof TEOrientable) {
            ForgeDirection input = ((TEOrientable)tile).getInputDirection();
            ForgeDirection output = ((TEOrientable)tile).getOutputDirection();
            return this.getIconsForMeta(meta)[this.getTextureIndexForSideAndOrientation(side, input, output)];
        }
        return this.func_149691_a(side, meta);
    }

    public TileEntity func_149915_a(World world, int dunno) {
        return new TEOrientable();
    }

    public IIcon[] getIconsForMeta(int metadata) {
        return fireIcons;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float what, float these, float are) {
        if (world.field_72995_K) {
            return false;
        }
        ForgeDirection sideClicked = ForgeDirection.getOrientation((int)side);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TEOrientable) {
            TEOrientable newTile = (TEOrientable)tile;
            if (player.func_70093_af()) {
                int nextSide = TEOrientable.getIntForForgeDirection(newTile.getInputDirection()) + 1;
                if (nextSide > 5) {
                    nextSide = 0;
                }
                if (ForgeDirection.getOrientation((int)nextSide) == newTile.getOutputDirection() && ++nextSide > 5) {
                    nextSide = 0;
                }
                newTile.setInputDirection(ForgeDirection.getOrientation((int)nextSide));
            } else {
                int nextSide = TEOrientable.getIntForForgeDirection(newTile.getOutputDirection()) + 1;
                if (nextSide > 5) {
                    nextSide = 0;
                }
                if (ForgeDirection.getOrientation((int)nextSide) == newTile.getInputDirection() && ++nextSide > 5) {
                    nextSide = 0;
                }
                newTile.setOutputDirection(ForgeDirection.getOrientation((int)nextSide));
            }
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public int getTextureIndexForSideAndOrientation(int side, ForgeDirection input, ForgeDirection output) {
        if (ForgeDirection.getOrientation((int)side) == input) {
            return 0;
        }
        if (ForgeDirection.getOrientation((int)side) == output) {
            return 1;
        }
        if (ForgeDirection.getOrientation((int)side) == output.getOpposite()) {
            return 6;
        }
        switch (side) {
            case 0: {
                switch (output) {
                    case NORTH: {
                        return 2;
                    }
                    case SOUTH: {
                        return 3;
                    }
                    case EAST: {
                        return 4;
                    }
                    case WEST: {
                        return 5;
                    }
                }
                break;
            }
            case 1: {
                switch (output) {
                    case NORTH: {
                        return 2;
                    }
                    case SOUTH: {
                        return 3;
                    }
                    case EAST: {
                        return 5;
                    }
                    case WEST: {
                        return 4;
                    }
                }
                break;
            }
            case 2: {
                switch (output) {
                    case DOWN: {
                        return 3;
                    }
                    case UP: {
                        return 2;
                    }
                    case EAST: {
                        return 4;
                    }
                    case WEST: {
                        return 5;
                    }
                }
                break;
            }
            case 3: {
                switch (output) {
                    case DOWN: {
                        return 3;
                    }
                    case UP: {
                        return 2;
                    }
                    case EAST: {
                        return 5;
                    }
                    case WEST: {
                        return 4;
                    }
                }
                break;
            }
            case 4: {
                switch (output) {
                    case DOWN: {
                        return 3;
                    }
                    case UP: {
                        return 2;
                    }
                    case NORTH: {
                        return 5;
                    }
                    case SOUTH: {
                        return 4;
                    }
                }
                break;
            }
            case 5: {
                switch (output) {
                    case DOWN: {
                        return 3;
                    }
                    case UP: {
                        return 2;
                    }
                    case NORTH: {
                        return 4;
                    }
                    case SOUTH: {
                        return 5;
                    }
                }
            }
        }
        return 0;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }
}

