/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.common.ArmourComponent;
import WayofTime.alchemicalWizardry.common.ArmourUpgrade;
import WayofTime.alchemicalWizardry.common.items.BoundArmour;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TESocket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ArmourForge
extends Block {
    public static List<ArmourComponent> helmetList = new ArrayList<ArmourComponent>();
    public static List<ArmourComponent> plateList = new ArrayList<ArmourComponent>();
    public static List<ArmourComponent> leggingsList = new ArrayList<ArmourComponent>();
    public static List<ArmourComponent> bootsList = new ArrayList<ArmourComponent>();

    public ArmourForge() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(AlchemicalWizardry.tabBloodMagic);
        this.func_149663_c("armourForge");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("AlchemicalWizardry:SoulForge");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        if (world.field_72995_K) {
            return false;
        }
        int armourType = this.getArmourType(world, x, y, z);
        if (armourType == -1) {
            return false;
        }
        int direction = this.getDirectionForArmourType(world, x, y, z, armourType);
        if (!this.isParadigmValid(armourType, direction, world, x, y, z)) {
            return false;
        }
        List<ArmourComponent> list = null;
        ItemStack armourPiece = null;
        switch (armourType) {
            case 0: {
                list = plateList;
                armourPiece = new ItemStack(ModItems.boundPlate, 1, 0);
                break;
            }
            case 1: {
                list = leggingsList;
                armourPiece = new ItemStack(ModItems.boundLeggings, 1, 0);
                break;
            }
            case 2: {
                list = helmetList;
                armourPiece = new ItemStack(ModItems.boundHelmet, 1, 0);
                break;
            }
            case 3: {
                list = bootsList;
                armourPiece = new ItemStack(ModItems.boundBoots, 1, 0);
            }
        }
        if (list == null) {
            return false;
        }
        if (armourPiece == null) {
            return false;
        }
        if (armourPiece.field_77990_d == null) {
            armourPiece.func_77982_d(new NBTTagCompound());
        }
        for (ArmourComponent ac : list) {
            Item item;
            TileEntity tileEntity;
            int xOff = ac.getXOff();
            int zOff = ac.getZOff();
            switch (direction) {
                case 1: {
                    tileEntity = world.func_147438_o(x + xOff, y, z - zOff);
                    break;
                }
                case 2: {
                    tileEntity = world.func_147438_o(x + zOff, y, z + xOff);
                    break;
                }
                case 3: {
                    tileEntity = world.func_147438_o(x - xOff, y, z + zOff);
                    break;
                }
                case 4: {
                    tileEntity = world.func_147438_o(x - zOff, y, z - xOff);
                    break;
                }
                case 5: {
                    tileEntity = world.func_147438_o(x + xOff, y + zOff, z);
                    break;
                }
                case 6: {
                    tileEntity = world.func_147438_o(x, y + zOff, z + xOff);
                    break;
                }
                default: {
                    tileEntity = null;
                }
            }
            if (!(tileEntity instanceof TESocket)) continue;
            ItemStack itemStack = ((TESocket)tileEntity).func_70301_a(0);
            int xCoord = tileEntity.field_145851_c;
            int yCoord = tileEntity.field_145848_d;
            int zCoord = tileEntity.field_145849_e;
            ((TESocket)tileEntity).func_70299_a(0, null);
            world.func_147468_f(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
            for (int i = 0; i < 8; ++i) {
                SpellHelper.sendIndexedParticleToAllAround(world, xCoord, yCoord, zCoord, 20, world.field_73011_w.field_76574_g, 1, xCoord, yCoord, zCoord);
            }
            if (itemStack == null || !((item = itemStack.func_77973_b()) instanceof ArmourUpgrade)) continue;
            ((BoundArmour)armourPiece.func_77973_b()).hasAddedToInventory(armourPiece, itemStack.func_77946_l());
            ((TESocket)tileEntity).func_70299_a(0, null);
        }
        if (armourPiece != null) {
            int xOff = world.field_73012_v.nextInt(11) - 5;
            int zOff = (int)(Math.sqrt(25 - xOff * xOff) * ((double)world.field_73012_v.nextInt(2) - 0.5) * 2.0);
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)(x + xOff), (double)(y + 5), (double)(z + zOff)));
            world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)(y + 1), (double)z, armourPiece));
        }
        return true;
    }

    public int getArmourType(World world, int x, int y, int z) {
        for (int i = 0; i <= 3; ++i) {
            if (this.getDirectionForArmourType(world, x, y, z, i) == -1) continue;
            return i;
        }
        return -1;
    }

    public int getDirectionForArmourType(World world, int x, int y, int z, int armourType) {
        for (int i = 1; i <= 6; ++i) {
            if (!this.isParadigmValid(armourType, i, world, x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public boolean isParadigmValid(int armourType, int direction, World world, int x, int y, int z) {
        List<ArmourComponent> list = null;
        switch (armourType) {
            case 0: {
                list = plateList;
                break;
            }
            case 1: {
                list = leggingsList;
                break;
            }
            case 2: {
                list = helmetList;
                break;
            }
            case 3: {
                list = bootsList;
            }
        }
        if (list == null) {
            return false;
        }
        block14: for (ArmourComponent ac : list) {
            int xOff = ac.getXOff();
            int zOff = ac.getZOff();
            switch (direction) {
                case 1: {
                    if (world.func_147438_o(x + xOff, y, z - zOff) instanceof TESocket) continue block14;
                    return false;
                }
                case 2: {
                    if (world.func_147438_o(x + zOff, y, z + xOff) instanceof TESocket) continue block14;
                    return false;
                }
                case 3: {
                    if (world.func_147438_o(x - xOff, y, z + zOff) instanceof TESocket) continue block14;
                    return false;
                }
                case 4: {
                    if (world.func_147438_o(x - zOff, y, z - xOff) instanceof TESocket) continue block14;
                    return false;
                }
                case 5: {
                    if (world.func_147438_o(x + xOff, y + zOff, z) instanceof TESocket) continue block14;
                    return false;
                }
                case 6: {
                    if (world.func_147438_o(x, y + zOff, z + xOff) instanceof TESocket) continue block14;
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public static void initializeRecipes() {
        helmetList.add(new ArmourComponent(-1, 1));
        helmetList.add(new ArmourComponent(0, 1));
        helmetList.add(new ArmourComponent(1, 1));
        helmetList.add(new ArmourComponent(-1, 0));
        helmetList.add(new ArmourComponent(1, 0));
        bootsList.add(new ArmourComponent(-1, 1));
        bootsList.add(new ArmourComponent(1, 1));
        bootsList.add(new ArmourComponent(-1, 0));
        bootsList.add(new ArmourComponent(1, 0));
        plateList.add(new ArmourComponent(-1, 0));
        plateList.add(new ArmourComponent(1, 0));
        plateList.add(new ArmourComponent(-1, -1));
        plateList.add(new ArmourComponent(0, -1));
        plateList.add(new ArmourComponent(1, -1));
        plateList.add(new ArmourComponent(-1, -2));
        plateList.add(new ArmourComponent(0, -2));
        plateList.add(new ArmourComponent(1, -2));
        leggingsList.add(new ArmourComponent(-1, 1));
        leggingsList.add(new ArmourComponent(0, 1));
        leggingsList.add(new ArmourComponent(1, 1));
        leggingsList.add(new ArmourComponent(-1, 0));
        leggingsList.add(new ArmourComponent(1, 0));
        leggingsList.add(new ArmourComponent(-1, -1));
        leggingsList.add(new ArmourComponent(1, -1));
    }
}

